/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;

public abstract class SAAJMetaFactory {
    private static final String SYSTEM_PROPERTY = "javax.xml.soap.MetaFactory";
    private static final String DEFAULT_FACTORY = "com.ibm.ws.webservices.engine.soap.SAAJMetaFactoryImpl";

    protected SAAJMetaFactory() {
    }

    static SAAJMetaFactory getInstance() throws SOAPException {
        return SAAJMetaFactory._getInstance();
    }

    private static synchronized SAAJMetaFactory _getInstance() throws SOAPException {
        try {
            Object object;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String string = System.getProperty(SYSTEM_PROPERTY);
            if (string == null && (object = SAAJMetaFactory.loadJAXMProperties(classLoader)) != null) {
                string = ((Properties)object).getProperty(SYSTEM_PROPERTY);
            }
            if (string == null) {
                object = "META-INF/services/javax.xml.soap.MetaFactory";
                InputStream inputStream = null;
                inputStream = classLoader == null ? ClassLoader.getSystemResourceAsStream((String)object) : classLoader.getResourceAsStream((String)object);
                if (inputStream != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                    string = bufferedReader.readLine();
                    bufferedReader.close();
                }
            }
            if (string == null) {
                string = DEFAULT_FACTORY;
            }
            if (string == null) {
                throw new SOAPException("Provider for javax.xml.soap.MetaFactory cannot be found", null);
            }
            Class<?> clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            Object obj = clazz.newInstance();
            return (SAAJMetaFactory)obj;
        }
        catch (Exception exception) {
            throw new SOAPException("Unable to create SOAP Factory: " + exception.getMessage());
        }
    }

    private static Properties loadJAXMProperties(ClassLoader classLoader) {
        String string = System.getProperty("java.home");
        if (string == null) {
            return null;
        }
        final String string2 = string + "\\" + "lib\\jaxm.properties";
        Properties properties = null;
        try {
            properties = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    Properties properties = new Properties();
                    FileInputStream fileInputStream = null;
                    fileInputStream = new FileInputStream(string2);
                    if (fileInputStream == null) {
                        return null;
                    }
                    properties.load(fileInputStream);
                    return properties;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
        return properties;
    }

    protected abstract MessageFactory newMessageFactory(String var1) throws SOAPException;

    protected abstract SOAPFactory newSOAPFactory(String var1) throws SOAPException;
}

