/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import com.ibm.ws.ffdc.FFDCFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class MessageFactory {
    private static final String DEFAULT_MESSAGE_FACTORY = "com.ibm.ws.webservices.engine.soap.MessageFactoryImpl";
    private static final String MESSAGE_FACTORY_PROPERTY = "javax.xml.soap.MessageFactory";
    private static final String META_FACTORY_CLASS_NAME = "javax.xml.soap.SAAJMetaFactory";
    private static Class factoryClass = null;
    private static boolean getMetaFactoryCalled = false;
    private static Object metaFactory = null;
    private static Method newMessageFactoryMethod = null;
    private static final String ERR_1 = "MessageFactory could not constructed due to failure in SAAJMetaFactory.newMessageFactory.";
    private static final String ERR_2 = "MessageFactory could not constructed because SAAJMetaFactory could not be found.";

    public static synchronized MessageFactory newInstance() throws SOAPException {
        try {
            Object var0 = null;
            if (metaFactory != null) {
                MessageFactory messageFactory = MessageFactory.getMessageFactory(metaFactory, "SOAP 1.1 Protocol");
                if (messageFactory == null) {
                    throw new SOAPException(ERR_1);
                }
                return messageFactory;
            }
            if (factoryClass == null) {
                Object object;
                Object object2;
                String string = MESSAGE_FACTORY_PROPERTY;
                String string2 = DEFAULT_MESSAGE_FACTORY;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                String string3 = System.getProperty(string);
                if (string3 == null) {
                    object2 = "META-INF/services/" + string;
                    object = null;
                    object = classLoader == null ? ClassLoader.getSystemResourceAsStream((String)object2) : classLoader.getResourceAsStream((String)object2);
                    if (object != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                        string3 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                }
                if ((object2 = MessageFactory.getMetaFactory()) != null) {
                    object = MessageFactory.getMessageFactory(object2, "SOAP 1.1 Protocol");
                    if (object == null) {
                        throw new SOAPException(ERR_1);
                    }
                    return object;
                }
                if (string3 == null) {
                    string3 = string2;
                }
                if (string3 == null) {
                    throw new SOAPException("Provider for " + string + " cannot be found", null);
                }
                factoryClass = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
            }
            var0 = factoryClass.newInstance();
            return var0;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.soap.MessageFactory.newInstance", (String)"157");
            exception.printStackTrace();
            throw new SOAPException("Unable to create message factory for SOAP: " + exception.getMessage(), exception);
        }
    }

    public static synchronized MessageFactory newInstance(String string) throws SOAPException {
        Object object = MessageFactory.getMetaFactory();
        if (object == null) {
            throw new SOAPException(ERR_2);
        }
        MessageFactory messageFactory = MessageFactory.getMessageFactory(object, string);
        if (messageFactory == null) {
            throw new SOAPException(ERR_1);
        }
        return messageFactory;
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;

    private static synchronized Object getMetaFactory() {
        if (getMetaFactoryCalled) {
            return metaFactory;
        }
        getMetaFactoryCalled = true;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = null;
            clazz = classLoader == null ? Class.forName(META_FACTORY_CLASS_NAME) : classLoader.loadClass(META_FACTORY_CLASS_NAME);
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            metaFactory = method.invoke(null, new Object[0]);
            Class[] classArray = new Class[]{String.class};
            newMessageFactoryMethod = clazz.getDeclaredMethod("newMessageFactory", classArray);
        }
        catch (Exception exception) {
            return null;
        }
        return metaFactory;
    }

    private static MessageFactory getMessageFactory(Object object, String string) {
        try {
            return (MessageFactory)newMessageFactoryMethod.invoke(object, string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

