/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

class FactoryFinder {
    FactoryFinder() {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, InvocationTargetException {
                    Method method = null;
                    try {
                        method = Thread.class.getMethod("getContextClassLoader", null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        FFDCFilter.processException((Throwable)noSuchMethodException, (String)"javax.xml.rpc.FactoryFinder.findClassLoader", (String)"100");
                        return FactoryFinder.class.getClassLoader();
                    }
                    return method.invoke((Object)Thread.currentThread(), null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            String string = exception instanceof IllegalAccessException ? "Unexpected IllegalAccessException" : (exception instanceof InvocationTargetException ? "Unexpected InvocationTargetException" : "Unexpected Exception");
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.rpc.FactoryFinder.findClassLoader", (String)"140");
            throw new ConfigurationError(string, exception);
        }
    }

    private static Object newInstance(String string, ClassLoader classLoader) throws ConfigurationError {
        try {
            if (classLoader != null) {
                try {
                    return classLoader.loadClass(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"javax.xml.rpc.FactoryFinder.newInstance", (String)"133");
                }
            }
            return Class.forName(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            FFDCFilter.processException((Throwable)classNotFoundException, (String)"javax.xml.rpc.FactoryFinder.newInstance", (String)"138");
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"javax.xml.rpc.FactoryFinder.newInstance", (String)"142");
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String string, String string2) throws ConfigurationError {
        ClassLoader classLoader;
        block12: {
            Closeable closeable;
            Object object;
            String string3;
            classLoader = FactoryFinder.findClassLoader();
            try {
                string3 = System.getProperty(string);
                if (string3 != null) {
                    return FactoryFinder.newInstance(string3, classLoader);
                }
            }
            catch (SecurityException securityException) {
                FFDCFilter.processException((Throwable)securityException, (String)"javax.xml.rpc.FactoryFinder.find", (String)"179");
            }
            try {
                string3 = System.getProperty("java.home");
                object = string3 + File.separator + "lib" + File.separator + "jaxrpc.properties";
                closeable = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction((String)object){
                    final /* synthetic */ String val$configFile;
                    {
                        this.val$configFile = string;
                    }

                    public Object run() throws FileNotFoundException {
                        File file = new File(this.val$configFile);
                        if (file.exists()) {
                            return new FileInputStream(file);
                        }
                        return null;
                    }
                });
                if (closeable != null) {
                    Properties properties = new Properties();
                    properties.load((InputStream)closeable);
                    String string4 = properties.getProperty(string);
                    return FactoryFinder.newInstance(string4, classLoader);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"javax.xml.rpc.FactoryFinder.find", (String)"196");
            }
            string3 = "META-INF/services/" + string;
            try {
                object = null;
                object = classLoader == null ? ClassLoader.getSystemResourceAsStream(string3) : classLoader.getResourceAsStream(string3);
                if (object == null) break block12;
                try {
                    closeable = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"javax.xml.rpc.FactoryFinder.find", (String)"233");
                    closeable = new BufferedReader(new InputStreamReader((InputStream)object));
                }
                String string5 = ((BufferedReader)closeable).readLine();
                ((BufferedReader)closeable).close();
                if (string5 != null && !"".equals(string5)) {
                    return FactoryFinder.newInstance(string5, classLoader);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"javax.xml.rpc.FactoryFinder.find", (String)"247");
            }
        }
        if (string2 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        return FactoryFinder.newInstance(string2, classLoader);
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

