/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServerMBean;
import javax.management.remote.JMXServiceURL;

public abstract class JMXConnectorServer
extends NotificationBroadcasterSupport
implements JMXConnectorServerMBean,
MBeanRegistration {
    private static final MBeanNotificationInfo[] notifications = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.remote.connection.opened", "jmx.remote.connection.closed", "jmx.remote.connection.failed"}, (class$javax$management$remote$JMXConnectionNotification == null ? (class$javax$management$remote$JMXConnectionNotification = JMXConnectorServer.class$("javax.management.remote.JMXConnectionNotification")) : class$javax$management$remote$JMXConnectionNotification).getName(), "Notifications emitted by the JMXConnectorServer MBean upon opening, closing or failing of a connection")};
    private MBeanServer server;
    private ObjectName name;
    private HashSet connections = new HashSet();
    static /* synthetic */ Class class$javax$management$remote$JMXConnectionNotification;

    public JMXConnectorServer() {
    }

    public JMXConnectorServer(MBeanServer server) {
        this.server = server;
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.server == null) {
            this.server = server;
        }
        this.name = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifications;
    }

    public MBeanServer getMBeanServer() {
        return this.server;
    }

    public JMXConnector getStub(Map environment) throws IOException {
        JMXServiceURL address = this.getAddress();
        return JMXConnectorFactory.newConnector(address, environment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConnectionIds() {
        Set copy = null;
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            copy = (Set)this.connections.clone();
        }
        return copy.toArray(new String[copy.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openedConnection(String connectionId, String message, Object userData) {
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            boolean added = this.connections.add(connectionId);
            if (!added) {
                throw new IllegalStateException("Duplicate connection ID: " + connectionId);
            }
        }
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.opened", this.name, connectionId, 0L, message, userData);
        this.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closedConnection(String connectionId, String message, Object userData) {
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            boolean removed = this.connections.remove(connectionId);
            if (!removed) {
                throw new IllegalStateException("Connection ID not present: " + connectionId);
            }
        }
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.closed", this.name, connectionId, 0L, message, userData);
        this.sendNotification(notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failedConnection(String connectionId, String message, Object userData) {
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            boolean removed = this.connections.remove(connectionId);
            if (!removed) {
                throw new IllegalStateException("Connection ID not present: " + connectionId);
            }
        }
        JMXConnectionNotification notification = new JMXConnectionNotification("jmx.remote.connection.failed", this.name, connectionId, 0L, message, userData);
        this.sendNotification(notification);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

