/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote;

import java.io.IOException;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorProvider;
import javax.management.remote.JMXProviderException;
import javax.management.remote.JMXServiceURL;

public class JMXConnectorFactory {
    public static final String DEFAULT_CLASS_LOADER = "jmx.remote.default.class.loader";
    public static final String PROTOCOL_PROVIDER_PACKAGES = "jmx.remote.protocol.provider.pkgs";
    public static final String PROTOCOL_PROVIDER_CLASS_LOADER = "jmx.remote.protocol.provider.class.loader";
    static /* synthetic */ Class class$javax$management$remote$JMXConnectorFactory;

    private JMXConnectorFactory() {
    }

    public static JMXConnector connect(JMXServiceURL url) throws IOException {
        return JMXConnectorFactory.connect(url, null);
    }

    public static JMXConnector connect(JMXServiceURL url, Map environment) throws IOException {
        JMXConnector connector2 = JMXConnectorFactory.newConnector(url, environment);
        connector2.connect(environment);
        return connector2;
    }

    public static JMXConnector newConnector(JMXServiceURL url, Map env) throws IOException {
        HashMap<String, ClassLoader> envCopy = env == null ? new HashMap<String, ClassLoader>() : new HashMap(env);
        String protocol = url.getProtocol();
        protocol = protocol.replace('+', '.');
        protocol = protocol.replace('-', '_');
        String providerPackages = JMXConnectorFactory.findProviderPackageList(envCopy);
        ClassLoader classLoader = JMXConnectorFactory.findProviderClassLoader(envCopy);
        JMXConnectorProvider provider = JMXConnectorFactory.loadProvider(providerPackages, protocol, classLoader);
        envCopy.put(PROTOCOL_PROVIDER_CLASS_LOADER, classLoader);
        return provider.newConnector(url, Collections.unmodifiableMap(envCopy));
    }

    private static String findProviderPackageList(Map environment) throws JMXProviderException {
        String providerPackages = null;
        if (environment != null) {
            Object pkgs = environment.get(PROTOCOL_PROVIDER_PACKAGES);
            if (pkgs != null && !(pkgs instanceof String)) {
                throw new JMXProviderException("Provider package list must be a string");
            }
            providerPackages = (String)pkgs;
        }
        if (providerPackages == null) {
            providerPackages = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES);
                }
            });
        }
        providerPackages = providerPackages == null || providerPackages.trim().length() == 0 ? "mx4j.remote.provider|mx4j.tools.remote.provider" : providerPackages + "|mx4j.remote.provider|mx4j.tools.remote.provider";
        return providerPackages;
    }

    private static ClassLoader findProviderClassLoader(Map environment) {
        ClassLoader classLoader = null;
        if (environment != null) {
            Object loader = environment.get(PROTOCOL_PROVIDER_CLASS_LOADER);
            if (loader != null && !(loader instanceof ClassLoader)) {
                throw new IllegalArgumentException("Provider classloader is not a classloader");
            }
            classLoader = (ClassLoader)loader;
        }
        if (classLoader == null) {
            classLoader = (class$javax$management$remote$JMXConnectorFactory == null ? (class$javax$management$remote$JMXConnectorFactory = JMXConnectorFactory.class$("javax.management.remote.JMXConnectorFactory")) : class$javax$management$remote$JMXConnectorFactory).getClassLoader();
        }
        return classLoader;
    }

    private static JMXConnectorProvider loadProvider(String packages, String protocol, ClassLoader loader) throws JMXProviderException, MalformedURLException {
        StringTokenizer tokenizer = new StringTokenizer(packages, "|");
        while (tokenizer.hasMoreTokens()) {
            String pkg = tokenizer.nextToken().trim();
            if (pkg.length() == 0) {
                throw new JMXProviderException("Empty package list not allowed: " + packages);
            }
            String providerClassName = pkg + "." + protocol + ".Provider";
            Class<?> providerClass = null;
            try {
                providerClass = loader == null ? Class.forName(providerClassName, false, null) : loader.loadClass(providerClassName);
            }
            catch (ClassNotFoundException x) {
                continue;
            }
            catch (Exception x) {
                throw new JMXProviderException("Cannot load provider class " + providerClassName, x);
            }
            try {
                return (JMXConnectorProvider)providerClass.newInstance();
            }
            catch (Exception x) {
                throw new JMXProviderException("Cannot instantiate the provider " + providerClassName, x);
            }
        }
        throw new MalformedURLException("Could not find provider for protocol " + protocol + " in package list '" + packages + "'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

