/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanParameterInfo;
import mx4j.util.Utils;

public class MBeanOperationInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6178860474881375330L;
    public static final int INFO = 0;
    public static final int ACTION = 1;
    public static final int ACTION_INFO = 2;
    public static final int UNKNOWN = 3;
    private MBeanParameterInfo[] signature;
    private String type;
    private int impact;

    public MBeanOperationInfo(String description, Method method) {
        super(method.getName(), description);
        Class<?>[] params = method.getParameterTypes();
        this.signature = new MBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            this.signature[i] = new MBeanParameterInfo("Parameter " + i, params[i].getName(), "An Operation Parameter");
        }
        this.type = method.getReturnType().getName();
        this.impact = 3;
    }

    public MBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description);
        this.signature = signature == null ? new MBeanParameterInfo[]{} : signature;
        this.type = type;
        this.impact = impact;
    }

    public String getReturnType() {
        return this.type;
    }

    public MBeanParameterInfo[] getSignature() {
        return this.signature != null ? (MBeanParameterInfo[])this.signature.clone() : new MBeanParameterInfo[]{};
    }

    public int getImpact() {
        return this.impact;
    }

    public int hashCode() {
        int hash = super.hashCode();
        String type = this.getReturnType();
        hash ^= type == null ? 0 : type.hashCode();
        hash ^= this.getImpact();
        return hash ^= Utils.arrayHashCode((Object[])this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        try {
            MBeanOperationInfo other = (MBeanOperationInfo)obj;
            String type = this.getReturnType();
            String otherType = other.getReturnType();
            if (type != null && !type.equals(otherType)) {
                return false;
            }
            if (type == null && otherType != null) {
                return false;
            }
            if (this.getImpact() != other.getImpact()) {
                return false;
            }
            return Utils.arrayEquals((Object[])this.getSignature(), (Object[])other.getSignature());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public Object clone() {
        MBeanOperationInfo clone = null;
        try {
            clone = (MBeanOperationInfo)super.clone();
        }
        catch (CloneNotSupportedException exc) {
            return null;
        }
        clone.impact = this.impact;
        clone.signature = (MBeanParameterInfo[])this.signature.clone();
        clone.type = this.type;
        return clone;
    }
}

