/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ScalarDataModel
extends DataModel {
    private int _rowIndex = -1;
    private Object _data;

    public ScalarDataModel() {
    }

    public ScalarDataModel(Object scalar) {
        this.setWrappedData(scalar);
    }

    public int getRowCount() {
        return this._data != null ? 1 : -1;
    }

    public Object getRowData() {
        if (this._data == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this._data;
    }

    public int getRowIndex() {
        return this._rowIndex;
    }

    public Object getWrappedData() {
        return this._data;
    }

    public boolean isRowAvailable() {
        if (this._data == null) {
            return false;
        }
        return this._rowIndex == 0;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + rowIndex);
        }
        int oldRowIndex = this._rowIndex;
        this._rowIndex = rowIndex;
        if (this._data != null && oldRowIndex != this._rowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event2 = new DataModelEvent(this, this._rowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event2);
            }
        }
    }

    public void setWrappedData(Object data) {
        this._data = data;
        int rowIndex = this._data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }
}

