/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ResultSetDataModel
extends DataModel {
    private int _currentIndex = -1;
    private ResultSet _resultSet = null;
    private ResultSetMetaData _resultSetMetadata = null;
    private boolean _currentRowUpdated = false;

    public ResultSetDataModel() {
        this(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        this.setWrappedData(resultSet);
    }

    public int getRowCount() {
        return -1;
    }

    public Object getRowData() {
        if (this._resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("the requested row is not available in the ResultSet - you have scrolled beyond the end.");
        }
        try {
            return new WrapResultSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    public int getRowIndex() {
        return this._currentIndex;
    }

    public Object getWrappedData() {
        return this._resultSet;
    }

    public boolean isRowAvailable() {
        if (this._resultSet == null) {
            return false;
        }
        if (this._currentIndex < 0) {
            return false;
        }
        try {
            return this._resultSet.absolute(this._currentIndex + 1);
        }
        catch (SQLException e) {
            throw new FacesException(e);
        }
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("you cannot set the rowIndex to anything less than 0");
        }
        if (this._currentRowUpdated && this._resultSet != null) {
            try {
                if (!this._resultSet.rowDeleted()) {
                    this._resultSet.updateRow();
                }
                this.setCurrentRowUpdated(false);
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        int old = this._currentIndex;
        this._currentIndex = rowIndex;
        if (this._resultSet == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this._currentIndex && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event2 = new DataModelEvent(this, this._currentIndex, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (listeners[i] == null) continue;
                listeners[i].rowSelected(event2);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this._resultSetMetadata = null;
            this._resultSet = null;
            this.setRowIndex(-1);
        } else {
            this._resultSetMetadata = null;
            this._resultSet = (ResultSet)data;
            this._currentIndex = -1;
            this.setRowIndex(0);
        }
    }

    private ResultSetMetaData getResultSetMetadata() {
        if (this._resultSetMetadata == null) {
            try {
                this._resultSetMetadata = this._resultSet.getMetaData();
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }
        return this._resultSetMetadata;
    }

    private void setCurrentRowUpdated(boolean currentRowUpdated) {
        this._currentRowUpdated = currentRowUpdated;
    }

    private static class WrapResultSetValuesIterator
    implements Iterator {
        private WrapResultSetMap _wrapMap;
        private Iterator<Object> _keyIterator;

        public WrapResultSetValuesIterator(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
            this._keyIterator = this._wrapMap.keySet().iterator();
        }

        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        public Object next() {
            return this._wrapMap.get(this._keyIterator.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("it is not allowed to remove from this map");
        }
    }

    private static class WrapResultSetValues
    extends AbstractCollection {
        private WrapResultSetMap _wrapMap;

        public WrapResultSetValues(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("it is not allowed to add to this collection");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to add to this collection");
        }

        public void clear() {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        public boolean contains(Object value) {
            return this._wrapMap.containsValue(value);
        }

        public Iterator iterator() {
            return new WrapResultSetValuesIterator(this._wrapMap);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this collection");
        }

        public int size() {
            return this._wrapMap.size();
        }
    }

    private static class WrapResultSetKeysIterator
    implements Iterator {
        private Iterator _keyIterator = null;

        public WrapResultSetKeysIterator(WrapResultSetMap map) {
            this._keyIterator = map.getUnderlyingKeys();
        }

        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        public Object next() {
            return this._keyIterator.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("it is not allowed to remove from this iterator");
        }
    }

    private static class WrapResultSetKeys
    extends AbstractSet {
        private WrapResultSetMap _wrapMap;

        public WrapResultSetKeys(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("It is not allowed to add to this set");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("It is not allowed to add to this set");
        }

        public void clear() {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public boolean contains(Object obj) {
            return this._wrapMap.containsKey(obj);
        }

        public boolean isEmpty() {
            return this._wrapMap.isEmpty();
        }

        public Iterator iterator() {
            return new WrapResultSetKeysIterator(this._wrapMap);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("It is not allowed to remove from this set");
        }

        public int size() {
            return this._wrapMap.size();
        }
    }

    private static class WrapResultSetEntry
    implements Map.Entry {
        private WrapResultSetMap _wrapMap;
        private Object _entryKey;

        public WrapResultSetEntry(WrapResultSetMap wrapMap, Object entryKey) {
            this._wrapMap = wrapMap;
            this._entryKey = entryKey;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry cmpEntry = (Map.Entry)o;
            if (this._entryKey == null ? cmpEntry.getKey() != null : !this._entryKey.equals(cmpEntry.getKey())) {
                return false;
            }
            Object value = this._wrapMap.get(this._entryKey);
            Object cmpValue = cmpEntry.getValue();
            return value == null ? cmpValue != null : value.equals(cmpValue);
        }

        public Object getKey() {
            return this._entryKey;
        }

        public Object getValue() {
            return this._wrapMap.get(this._entryKey);
        }

        public int hashCode() {
            int result = this._entryKey != null ? this._entryKey.hashCode() : 0;
            result = 29 * result + (this._wrapMap.get(this._entryKey) != null ? this._wrapMap.get(this._entryKey).hashCode() : 0);
            return result;
        }

        public Object setValue(Object value) {
            Object oldValue = this._wrapMap.get(this._entryKey);
            this._wrapMap.put(this._entryKey, value);
            return oldValue;
        }
    }

    private static class WrapResultSetEntriesIterator
    implements Iterator {
        private WrapResultSetMap _wrapMap = null;
        private Iterator<Object> _keyIterator = null;

        public WrapResultSetEntriesIterator(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
            this._keyIterator = this._wrapMap.keySet().iterator();
        }

        public boolean hasNext() {
            return this._keyIterator.hasNext();
        }

        public Object next() {
            return new WrapResultSetEntry(this._wrapMap, this._keyIterator.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("It is not allowed to remove from this iterator");
        }
    }

    private static class WrapResultSetEntries
    extends AbstractSet {
        private WrapResultSetMap _wrapMap;

        public WrapResultSetEntries(WrapResultSetMap wrapMap) {
            this._wrapMap = wrapMap;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("it is not allowed to add to this set");
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to add to this set");
        }

        public void clear() {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (!this._wrapMap.containsKey(key)) {
                return false;
            }
            Object value = e.getValue();
            Object cmpValue = this._wrapMap.get(key);
            return value == null ? cmpValue == null : value.equals(cmpValue);
        }

        public boolean isEmpty() {
            return this._wrapMap.isEmpty();
        }

        public Iterator iterator() {
            return new WrapResultSetEntriesIterator(this._wrapMap);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException("it is not allowed to remove from this set");
        }

        public int size() {
            return this._wrapMap.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrapResultSetMap
    extends TreeMap {
        private static final long serialVersionUID = -4321143404567038922L;
        private int _currentIndex;

        public WrapResultSetMap(Comparator comparator) throws SQLException {
            super(comparator);
            this._currentIndex = ResultSetDataModel.this._currentIndex;
            ResultSetDataModel.this._resultSet.absolute(this._currentIndex + 1);
            int columnCount = ResultSetDataModel.this.getResultSetMetadata().getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                super.put(ResultSetDataModel.this.getResultSetMetadata().getColumnName(i), ResultSetDataModel.this.getResultSetMetadata().getColumnName(i));
            }
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("It is not allowed to remove from this map");
        }

        @Override
        public boolean containsValue(Object value) {
            Set<Object> keys = this.keySet();
            Iterator<Object> iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object object = this.get(iterator.next());
                if (object == null) {
                    return value == null;
                }
                if (!object.equals(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set entrySet() {
            return new WrapResultSetEntries(this);
        }

        @Override
        public Object get(Object key) {
            if (!this.containsKey(key)) {
                return null;
            }
            return this.basicGet(key);
        }

        private Object basicGet(Object key) {
            try {
                ResultSetDataModel.this._resultSet.absolute(this._currentIndex + 1);
                return ResultSetDataModel.this._resultSet.getObject((String)this.getUnderlyingKey(key));
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        @Override
        public Set<Object> keySet() {
            return new WrapResultSetKeys(this);
        }

        @Override
        public Object put(Object key, Object value) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException("underlying result set does not provide this key");
            }
            if (!(key instanceof String)) {
                throw new IllegalArgumentException("key must be of type 'String', is of type : " + (key == null ? "null" : key.getClass().getName()));
            }
            try {
                ResultSetDataModel.this._resultSet.absolute(this._currentIndex + 1);
                Object oldValue = ResultSetDataModel.this._resultSet.getObject((String)this.getUnderlyingKey(key));
                if (oldValue == null ? value == null : oldValue.equals(value)) {
                    return oldValue;
                }
                ResultSetDataModel.this._resultSet.updateObject((String)this.getUnderlyingKey(key), value);
                ResultSetDataModel.this.setCurrentRowUpdated(true);
                return oldValue;
            }
            catch (SQLException e) {
                throw new FacesException(e);
            }
        }

        @Override
        public void putAll(Map map) {
            for (Map.Entry entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("It is not allowed to remove entries from this set.");
        }

        @Override
        public Collection<Object> values() {
            return new WrapResultSetValues(this);
        }

        Object getUnderlyingKey(Object key) {
            return super.get(key);
        }

        Iterator getUnderlyingKeys() {
            return super.keySet().iterator();
        }
    }
}

