/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Currency;
import java.util.Locale;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class NumberConverter
implements Converter,
StateHolder {
    public static final String CONVERTER_ID = "javax.faces.Number";
    public static final String STRING_ID = "javax.faces.converter.STRING";
    public static final String CURRENCY_ID = "javax.faces.converter.NumberConverter.CURRENCY";
    public static final String NUMBER_ID = "javax.faces.converter.NumberConverter.NUMBER";
    public static final String PATTERN_ID = "javax.faces.converter.NumberConverter.PATTERN";
    public static final String PERCENT_ID = "javax.faces.converter.NumberConverter.PERCENT";
    private static final boolean JAVA_VERSION_14 = NumberConverter.checkJavaVersion14();
    private String _currencyCode;
    private String _currencySymbol;
    private Locale _locale;
    private int _maxFractionDigits;
    private int _maxIntegerDigits;
    private int _minFractionDigits;
    private int _minIntegerDigits;
    private String _pattern;
    private String _type = "number";
    private boolean _groupingUsed = true;
    private boolean _integerOnly = false;
    private boolean _transient;
    private boolean _maxFractionDigitsSet;
    private boolean _maxIntegerDigitsSet;
    private boolean _minFractionDigitsSet;
    private boolean _minIntegerDigitsSet;

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        block12: {
            if (facesContext == null) {
                throw new NullPointerException("facesContext");
            }
            if (uiComponent == null) {
                throw new NullPointerException("uiComponent");
            }
            if (value != null && (value = value.trim()).length() > 0) {
                NumberFormat format = this.getNumberFormat(facesContext);
                format.setParseIntegerOnly(this._integerOnly);
                DecimalFormat df = (DecimalFormat)format;
                DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
                boolean changed = false;
                if (dfs.getGroupingSeparator() == '\u00a0') {
                    dfs.setGroupingSeparator(' ');
                    df.setDecimalFormatSymbols(dfs);
                    changed = true;
                }
                try {
                    return format.parse(value);
                }
                catch (ParseException e) {
                    if (changed) {
                        dfs.setGroupingSeparator('\u00a0');
                        df.setDecimalFormatSymbols(dfs);
                    }
                    try {
                        return format.parse(value);
                    }
                    catch (ParseException pe) {
                        if (this.getPattern() != null) {
                            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, PATTERN_ID, new Object[]{value, "$###,###", _MessageUtils.getLabel(facesContext, uiComponent)}));
                        }
                        if (this.getType().equals("number")) {
                            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, NUMBER_ID, new Object[]{value, "21", _MessageUtils.getLabel(facesContext, uiComponent)}));
                        }
                        if (this.getType().equals("currency")) {
                            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, CURRENCY_ID, new Object[]{value, "42.25", _MessageUtils.getLabel(facesContext, uiComponent)}));
                        }
                        if (!this.getType().equals("percent")) break block12;
                        throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, PERCENT_ID, new Object[]{value, ".90", _MessageUtils.getLabel(facesContext, uiComponent)}));
                    }
                }
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        NumberFormat format = this.getNumberFormat(facesContext);
        format.setGroupingUsed(this._groupingUsed);
        if (this._maxFractionDigitsSet) {
            format.setMaximumFractionDigits(this._maxFractionDigits);
        }
        if (this._maxIntegerDigitsSet) {
            format.setMaximumIntegerDigits(this._maxIntegerDigits);
        }
        if (this._minFractionDigitsSet) {
            format.setMinimumFractionDigits(this._minFractionDigits);
        }
        if (this._minIntegerDigitsSet) {
            format.setMinimumIntegerDigits(this._minIntegerDigits);
        }
        this.formatCurrency(format);
        try {
            return format.format(value);
        }
        catch (Exception e) {
            throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, STRING_ID, new Object[]{value, _MessageUtils.getLabel(facesContext, uiComponent)}), (Throwable)e);
        }
    }

    private NumberFormat getNumberFormat(FacesContext facesContext) {
        Locale locale;
        Locale locale2 = locale = this._locale != null ? this._locale : facesContext.getViewRoot().getLocale();
        if (this._pattern == null && this._type == null) {
            throw new ConverterException("Cannot get NumberFormat, either type or pattern needed.");
        }
        if (this._pattern != null) {
            return new DecimalFormat(this._pattern, new DecimalFormatSymbols(locale));
        }
        if (this._type.equals("number")) {
            return NumberFormat.getNumberInstance(locale);
        }
        if (this._type.equals("currency")) {
            return NumberFormat.getCurrencyInstance(locale);
        }
        if (this._type.equals("percent")) {
            return NumberFormat.getPercentInstance(locale);
        }
        throw new ConverterException("Cannot get NumberFormat, illegal type " + this._type);
    }

    private void formatCurrency(NumberFormat format) {
        boolean useCurrencyCode;
        if (this._currencyCode == null && this._currencySymbol == null) {
            return;
        }
        if (JAVA_VERSION_14) {
            useCurrencyCode = this._currencyCode != null;
        } else {
            boolean bl = useCurrencyCode = this._currencySymbol == null;
        }
        if (useCurrencyCode) {
            try {
                format.setCurrency(Currency.getInstance(this._currencyCode));
            }
            catch (Exception e) {
                throw new ConverterException("Unable to get Currency instance for currencyCode " + this._currencyCode);
            }
        } else if (format instanceof DecimalFormat) {
            DecimalFormat dFormat = (DecimalFormat)format;
            DecimalFormatSymbols symbols = dFormat.getDecimalFormatSymbols();
            symbols.setCurrencySymbol(this._currencySymbol);
            dFormat.setDecimalFormatSymbols(symbols);
        }
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this._currencyCode = (String)values[0];
        this._currencySymbol = (String)values[1];
        this._locale = (Locale)values[2];
        Integer value = (Integer)values[3];
        this._maxFractionDigits = value != null ? value : 0;
        value = (Integer)values[4];
        this._maxIntegerDigits = value != null ? value : 0;
        value = (Integer)values[5];
        this._minFractionDigits = value != null ? value : 0;
        value = (Integer)values[6];
        this._minIntegerDigits = value != null ? value : 0;
        this._pattern = (String)values[7];
        this._type = (String)values[8];
        this._groupingUsed = (Boolean)values[9];
        this._integerOnly = (Boolean)values[10];
        this._maxFractionDigitsSet = (Boolean)values[11];
        this._maxIntegerDigitsSet = (Boolean)values[12];
        this._minFractionDigitsSet = (Boolean)values[13];
        this._minIntegerDigitsSet = (Boolean)values[14];
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._currencyCode, this._currencySymbol, this._locale, this._maxFractionDigitsSet ? new Integer(this._maxFractionDigits) : null, this._maxIntegerDigitsSet ? new Integer(this._maxIntegerDigits) : null, this._minFractionDigitsSet ? new Integer(this._minFractionDigits) : null, this._minIntegerDigitsSet ? new Integer(this._minIntegerDigits) : null, this._pattern, this._type, this._groupingUsed ? Boolean.TRUE : Boolean.FALSE, this._integerOnly ? Boolean.TRUE : Boolean.FALSE, this._maxFractionDigitsSet ? Boolean.TRUE : Boolean.FALSE, this._maxIntegerDigitsSet ? Boolean.TRUE : Boolean.FALSE, this._minFractionDigitsSet ? Boolean.TRUE : Boolean.FALSE, this._minIntegerDigitsSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public String getCurrencyCode() {
        return this._currencyCode != null ? this._currencyCode : this.getDecimalFormatSymbols().getInternationalCurrencySymbol();
    }

    public void setCurrencyCode(String currencyCode) {
        this._currencyCode = currencyCode;
    }

    public String getCurrencySymbol() {
        return this._currencySymbol != null ? this._currencySymbol : this.getDecimalFormatSymbols().getCurrencySymbol();
    }

    public void setCurrencySymbol(String currencySymbol) {
        this._currencySymbol = currencySymbol;
    }

    public boolean isGroupingUsed() {
        return this._groupingUsed;
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this._groupingUsed = groupingUsed;
    }

    public boolean isIntegerOnly() {
        return this._integerOnly;
    }

    public void setIntegerOnly(boolean integerOnly) {
        this._integerOnly = integerOnly;
    }

    public Locale getLocale() {
        if (this._locale != null) {
            return this._locale;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public int getMaxFractionDigits() {
        return this._maxFractionDigits;
    }

    public void setMaxFractionDigits(int maxFractionDigits) {
        this._maxFractionDigitsSet = true;
        this._maxFractionDigits = maxFractionDigits;
    }

    public int getMaxIntegerDigits() {
        return this._maxIntegerDigits;
    }

    public void setMaxIntegerDigits(int maxIntegerDigits) {
        this._maxIntegerDigitsSet = true;
        this._maxIntegerDigits = maxIntegerDigits;
    }

    public int getMinFractionDigits() {
        return this._minFractionDigits;
    }

    public void setMinFractionDigits(int minFractionDigits) {
        this._minFractionDigitsSet = true;
        this._minFractionDigits = minFractionDigits;
    }

    public int getMinIntegerDigits() {
        return this._minIntegerDigits;
    }

    public void setMinIntegerDigits(int minIntegerDigits) {
        this._minIntegerDigitsSet = true;
        this._minIntegerDigits = minIntegerDigits;
    }

    public String getPattern() {
        return this._pattern;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void setTransient(boolean aTransient) {
        this._transient = aTransient;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    private static boolean checkJavaVersion14() {
        String version = System.getProperty("java.version");
        if (version == null) {
            return false;
        }
        int java14 = 0;
        int idx = version.indexOf(46);
        int i = 0;
        while (idx > 0 || version != null) {
            byte value;
            if (idx > 0) {
                value = Byte.parseByte(version.substring(0, 1));
                version = version.substring(idx + 1, version.length());
                idx = version.indexOf(46);
                switch (i) {
                    case 0: {
                        if (value == 1) {
                            java14 = 1;
                            break;
                        }
                        if (value > 1) {
                            java14 = 2;
                        }
                    }
                    case 1: {
                        if (java14 > 0 && value >= 4) {
                            java14 = 2;
                        }
                    }
                    default: {
                        idx = 0;
                        version = null;
                        break;
                    }
                }
            } else {
                value = Byte.parseByte(version.substring(0, 1));
                if (java14 <= 0 || value < 4) break;
                java14 = 2;
                break;
            }
            ++i;
        }
        return java14 == 2;
    }

    private DecimalFormatSymbols getDecimalFormatSymbols() {
        return new DecimalFormatSymbols(this.getLocale());
    }
}

