/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.taglib.jsf_core;

import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.webapp.ConverterELTag;
import javax.servlet.jsp.JspException;

public class AbstractConverterTag
extends ConverterELTag {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    protected ValueExpression binding = null;
    protected ValueExpression converterId = null;

    public void setBinding(ValueExpression binding) {
        this.binding = binding;
    }

    public void setConverterId(ValueExpression converterId) {
        this.converterId = converterId;
    }

    protected Converter createConverter() throws JspException {
        try {
            return AbstractConverterTag.createConverter(this.converterId, this.binding, FacesContext.getCurrentInstance());
        }
        catch (FacesException fe) {
            throw new JspException(fe.getCause());
        }
    }

    protected static Converter createConverter(ValueExpression converterId, ValueExpression binding, FacesContext facesContext) {
        ELContext elContext = facesContext.getELContext();
        Converter converter = null;
        if (binding != null) {
            try {
                converter = (Converter)binding.getValue(elContext);
                if (converter != null) {
                    return converter;
                }
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
        if (converterId != null) {
            try {
                String converterIdVal = (String)converterId.getValue(elContext);
                converter = facesContext.getApplication().createConverter(converterIdVal);
                if (converter != null && binding != null) {
                    binding.setValue(elContext, converter);
                }
            }
            catch (Exception e) {
                throw new FacesException(e);
            }
        }
        if (converter == null && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, MessageUtils.getExceptionMessageString("com.sun.faces.CANNOT_CONVERT", converterId != null ? converterId.getExpressionString() : "", binding != null ? binding.getExpressionString() : ""));
        }
        return converter;
    }
}

