/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.MenuRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;

public class SelectManyCheckboxListRenderer
extends MenuRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.SELECTMANYCHECKBOX);

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        Object borderObj;
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        boolean alignVertical = false;
        int border = 0;
        String alignStr = (String)component2.getAttributes().get("layout");
        if (null != alignStr) {
            alignVertical = alignStr.equalsIgnoreCase("pageDirection");
        }
        if (null != (borderObj = component2.getAttributes().get("border"))) {
            border = (Integer)borderObj;
        }
        Converter converter = null;
        if (component2 instanceof ValueHolder) {
            converter = ((ValueHolder)((Object)component2)).getConverter();
        }
        this.renderBeginText(component2, border, alignVertical, context, true);
        List<SelectItem> items = RenderKitUtils.getSelectItems(context, component2);
        if (!items.isEmpty()) {
            int idx = -1;
            for (SelectItem curItem : items) {
                ++idx;
                if (curItem instanceof SelectItemGroup) {
                    if (curItem.getLabel() != null) {
                        if (alignVertical) {
                            writer.startElement("tr", component2);
                        }
                        writer.startElement("td", component2);
                        writer.writeText(curItem.getLabel(), component2, "label");
                        writer.endElement("td");
                        if (alignVertical) {
                            writer.endElement("tr");
                        }
                    }
                    if (alignVertical) {
                        writer.startElement("tr", component2);
                    }
                    writer.startElement("td", component2);
                    writer.writeText("\n", component2, null);
                    this.renderBeginText(component2, 0, alignVertical, context, false);
                    SelectItem[] itemsArray = ((SelectItemGroup)curItem).getSelectItems();
                    for (int i = 0; i < itemsArray.length; ++i) {
                        this.renderOption(context, component2, converter, itemsArray[i], alignVertical, i);
                    }
                    this.renderEndText(component2, alignVertical, context);
                    writer.endElement("td");
                    if (!alignVertical) continue;
                    writer.endElement("tr");
                    writer.writeText("\n", component2, null);
                    continue;
                }
                this.renderOption(context, component2, converter, curItem, alignVertical, idx);
            }
        }
        this.renderEndText(component2, alignVertical, context);
    }

    protected void renderBeginText(UIComponent component2, int border, boolean alignVertical, FacesContext context, boolean outerTable) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        writer.startElement("table", component2);
        if (border != Integer.MIN_VALUE) {
            writer.writeAttribute("border", border, "border");
        }
        if (outerTable) {
            if (this.shouldWriteIdAttribute(component2)) {
                this.writeIdAttributeIfNecessary(context, writer, component2);
            }
            String styleClass = (String)component2.getAttributes().get("styleClass");
            String style = (String)component2.getAttributes().get("style");
            if (styleClass != null) {
                writer.writeAttribute("class", styleClass, "class");
            }
            if (style != null) {
                writer.writeAttribute("style", style, "style");
            }
        }
        writer.writeText("\n", component2, null);
        if (!alignVertical) {
            writer.writeText("\t", component2, null);
            writer.startElement("tr", component2);
            writer.writeText("\n", component2, null);
        }
    }

    protected void renderEndText(UIComponent component2, boolean alignVertical, FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        if (!alignVertical) {
            writer.writeText("\t", component2, null);
            writer.endElement("tr");
            writer.writeText("\n", component2, null);
        }
        writer.endElement("table");
    }

    protected void renderOption(FacesContext context, UIComponent component2, Converter converter, SelectItem curItem, boolean alignVertical, int itemNumber) throws IOException {
        String itemLabel;
        Object newValue;
        Object itemValue;
        Object valuesArray;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        boolean componentDisabled = Util.componentIsDisabled(component2);
        String labelClass = componentDisabled || curItem.isDisabled() ? (String)component2.getAttributes().get("disabledClass") : (String)component2.getAttributes().get("enabledClass");
        if (alignVertical) {
            writer.writeText("\t", component2, null);
            writer.startElement("tr", component2);
            writer.writeText("\n", component2, null);
        }
        writer.startElement("td", component2);
        writer.writeText("\n", component2, null);
        writer.startElement("input", component2);
        writer.writeAttribute("name", component2.getClientId(context), "clientId");
        String idString = component2.getClientId(context) + ':' + Integer.toString(itemNumber);
        writer.writeAttribute("id", idString, "id");
        String valueString = this.getFormattedValue(context, component2, curItem.getValue(), converter);
        writer.writeAttribute("value", valueString, "value");
        writer.writeAttribute("type", "checkbox", null);
        Object[] submittedValues = this.getSubmittedSelectedValues(component2);
        Class type = String.class;
        if (submittedValues != null) {
            valuesArray = submittedValues;
            itemValue = valueString;
        } else {
            valuesArray = this.getCurrentSelectedValues(component2);
            itemValue = curItem.getValue();
        }
        if (valuesArray != null) {
            type = valuesArray.getClass().getComponentType();
        }
        Map<String, Object> requestMap = context.getExternalContext().getRequestMap();
        requestMap.put("com.sun.faces.ComponentForValue", component2);
        try {
            newValue = context.getApplication().getExpressionFactory().coerceToType(itemValue, type);
        }
        catch (ELException ele) {
            newValue = itemValue;
        }
        catch (IllegalArgumentException iae) {
            newValue = itemValue;
        }
        boolean isSelected = this.isSelected(newValue, valuesArray);
        if (isSelected) {
            writer.writeAttribute(this.getSelectedTextString(), Boolean.TRUE, null);
        }
        if (!Util.componentIsDisabled(component2) && curItem.isDisabled()) {
            writer.writeAttribute("disabled", true, "disabled");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component2);
        writer.endElement("input");
        writer.startElement("label", component2);
        writer.writeAttribute("for", idString, "for");
        if (labelClass != null) {
            writer.writeAttribute("class", labelClass, "labelClass");
        }
        if ((itemLabel = curItem.getLabel()) != null) {
            writer.writeText(" ", component2, null);
            if (!curItem.isEscape()) {
                writer.write(itemLabel);
            } else {
                writer.writeText(itemLabel, component2, "label");
            }
        }
        writer.endElement("label");
        writer.endElement("td");
        writer.writeText("\n", component2, null);
        if (alignVertical) {
            writer.writeText("\t", component2, null);
            writer.endElement("tr");
            writer.writeText("\n", component2, null);
        }
    }

    String getSelectedTextString() {
        return "checked";
    }
}

