/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessages;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessagesRenderer
extends HtmlBasicRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.MESSAGESMESSAGES);

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        UIMessages messages2 = (UIMessages)component2;
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String clientId = null;
        if (clientId == null && messages2.isGlobalOnly()) {
            clientId = "";
        }
        Iterator messageIter = this.getMessageIter(context, clientId, component2);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            return;
        }
        String layout = (String)component2.getAttributes().get("layout");
        boolean showSummary = messages2.isShowSummary();
        boolean showDetail = messages2.isShowDetail();
        String styleClass = (String)component2.getAttributes().get("styleClass");
        boolean wroteTable = false;
        if (layout != null && layout.equals("table")) {
            writer.startElement("table", component2);
            wroteTable = true;
        } else {
            writer.startElement("ul", component2);
        }
        this.writeIdAttributeIfNecessary(context, writer, component2);
        if (null != styleClass) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        while (messageIter.hasNext()) {
            Object val;
            FacesMessage curMessage = (FacesMessage)messageIter.next();
            String severityStyle = null;
            String severityStyleClass = null;
            String summary = curMessage.getSummary();
            summary = null != summary ? summary : "";
            String detail = curMessage.getDetail();
            String string = detail = null != detail ? detail : summary;
            if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
                severityStyle = (String)component2.getAttributes().get("infoStyle");
                severityStyleClass = (String)component2.getAttributes().get("infoClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
                severityStyle = (String)component2.getAttributes().get("warnStyle");
                severityStyleClass = (String)component2.getAttributes().get("warnClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
                severityStyle = (String)component2.getAttributes().get("errorStyle");
                severityStyleClass = (String)component2.getAttributes().get("errorClass");
            } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
                severityStyle = (String)component2.getAttributes().get("fatalStyle");
                severityStyleClass = (String)component2.getAttributes().get("fatalClass");
            }
            if (wroteTable) {
                writer.startElement("tr", component2);
            } else {
                writer.startElement("li", component2);
            }
            if (severityStyle != null) {
                writer.writeAttribute("style", severityStyle, "style");
            }
            if (severityStyleClass != null) {
                styleClass = severityStyleClass;
                writer.writeAttribute("class", styleClass, "styleClass");
            }
            if (wroteTable) {
                writer.startElement("td", component2);
            }
            boolean isTooltip = (val = component2.getAttributes().get("tooltip")) != null && Boolean.valueOf(val.toString()) != false;
            boolean wroteTooltip = false;
            if (showSummary && showDetail && isTooltip) {
                writer.startElement("span", component2);
                String title = (String)component2.getAttributes().get("title");
                if (title == null || title.length() == 0) {
                    writer.writeAttribute("title", summary, "title");
                }
                writer.flush();
                writer.writeText("\t", component2, null);
                wroteTooltip = true;
            }
            if (!wroteTooltip && showSummary) {
                writer.writeText("\t", component2, null);
                writer.writeText(summary, component2, null);
                writer.writeText(" ", component2, null);
            }
            if (showDetail) {
                writer.writeText(detail, component2, null);
            }
            if (wroteTooltip) {
                writer.endElement("span");
            }
            if (wroteTable) {
                writer.endElement("td");
                writer.endElement("tr");
                continue;
            }
            writer.endElement("li");
        }
        if (wroteTable) {
            writer.endElement("table");
        } else {
            writer.endElement("ul");
        }
    }
}

