/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.renderkit.html_basic.OutputMessageRenderer;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class MessageRenderer
extends HtmlBasicRenderer {
    private OutputMessageRenderer omRenderer = new OutputMessageRenderer();

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (component2 instanceof UIOutput) {
            this.omRenderer.encodeBegin(context, component2);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (component2 instanceof UIOutput) {
            this.omRenderer.encodeChildren(context, component2);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        Object val;
        this.rendererParamsNotNull(context, component2);
        if (component2 instanceof UIOutput) {
            this.omRenderer.encodeEnd(context, component2);
            return;
        }
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        UIMessage message = (UIMessage)component2;
        String clientId = message.getFor();
        if (clientId == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("'for' attribute cannot be null");
            }
            return;
        }
        clientId = this.augmentIdReference(clientId, component2);
        Iterator messageIter = this.getMessageIter(context, clientId, component2);
        assert (messageIter != null);
        if (!messageIter.hasNext()) {
            return;
        }
        FacesMessage curMessage = (FacesMessage)messageIter.next();
        String severityStyle = null;
        String severityStyleClass = null;
        boolean showSummary = message.isShowSummary();
        boolean showDetail = message.isShowDetail();
        String summary = curMessage.getSummary();
        summary = null != summary ? summary : "";
        String detail = curMessage.getDetail();
        String string = detail = null != detail ? detail : summary;
        if (curMessage.getSeverity() == FacesMessage.SEVERITY_INFO) {
            severityStyle = (String)component2.getAttributes().get("infoStyle");
            severityStyleClass = (String)component2.getAttributes().get("infoClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_WARN) {
            severityStyle = (String)component2.getAttributes().get("warnStyle");
            severityStyleClass = (String)component2.getAttributes().get("warnClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_ERROR) {
            severityStyle = (String)component2.getAttributes().get("errorStyle");
            severityStyleClass = (String)component2.getAttributes().get("errorClass");
        } else if (curMessage.getSeverity() == FacesMessage.SEVERITY_FATAL) {
            severityStyle = (String)component2.getAttributes().get("fatalStyle");
            severityStyleClass = (String)component2.getAttributes().get("fatalClass");
        }
        String style = (String)component2.getAttributes().get("style");
        String styleClass = (String)component2.getAttributes().get("styleClass");
        String dir = (String)component2.getAttributes().get("dir");
        String lang = (String)component2.getAttributes().get("lang");
        String title = (String)component2.getAttributes().get("title");
        if (style != null && severityStyle != null) {
            style = severityStyle;
        } else if (style == null && severityStyle != null) {
            style = severityStyle;
        }
        if (styleClass != null && severityStyleClass != null) {
            styleClass = severityStyleClass;
        } else if (styleClass == null && severityStyleClass != null) {
            styleClass = severityStyleClass;
        }
        boolean wroteSpan = false;
        if (styleClass != null || style != null || dir != null || lang != null || title != null || this.shouldWriteIdAttribute(component2)) {
            writer.startElement("span", component2);
            this.writeIdAttributeIfNecessary(context, writer, component2);
            wroteSpan = true;
            if (style != null) {
                writer.writeAttribute("style", style, "style");
            }
            if (styleClass != null) {
                writer.writeAttribute("class", styleClass, "styleClass");
            }
            if (dir != null) {
                writer.writeAttribute("dir", dir, "dir");
            }
            if (lang != null) {
                writer.writeAttribute(RenderKitUtils.prefixAttribute("lang", writer), lang, "lang");
            }
            if (title != null) {
                writer.writeAttribute("title", title, "title");
            }
        }
        boolean isTooltip = (val = component2.getAttributes().get("tooltip")) != null && Boolean.valueOf(val.toString()) != false;
        boolean wroteTooltip = false;
        if (showSummary && showDetail && isTooltip) {
            if (!wroteSpan) {
                writer.startElement("span", component2);
            }
            if (title == null || title.length() == 0) {
                writer.writeAttribute("title", summary, "title");
            }
            writer.flush();
            wroteTooltip = true;
        } else if (wroteSpan) {
            writer.flush();
        }
        if (!wroteTooltip && showSummary) {
            writer.writeText(summary, component2, null);
            if (showDetail) {
                writer.writeText(" ", component2, null);
            }
        }
        if (showDetail) {
            writer.writeText(detail, component2, null);
        }
        if (wroteSpan || wroteTooltip) {
            writer.endElement("span");
        }
    }
}

