/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class GridRenderer
extends BaseTableRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.PANELGRID);

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        this.renderTableStart(context, component2, writer, ATTRIBUTES);
        this.renderCaption(context, component2, writer);
        this.renderHeader(context, component2, writer);
        this.renderFooter(context, component2, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncodeChildren(component2)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(component2);
        int columnCount = info.columns.size();
        boolean open = false;
        int i = 0;
        this.renderTableBodyStart(component2, writer);
        Iterator<UIComponent> kids = this.getChildren(component2);
        while (kids.hasNext()) {
            UIComponent child = kids.next();
            if (!child.isRendered()) continue;
            if (i % columnCount == 0) {
                if (open) {
                    this.renderRowEnd(component2, writer);
                    open = false;
                }
                this.renderRowStart(component2, writer);
                open = true;
                info.columnStyleCounter = 0;
            }
            this.renderRow(context, component2, child, writer);
            ++i;
        }
        if (open) {
            this.renderRowEnd(component2, writer);
        }
        this.renderTableBodyEnd(component2, writer);
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        this.renderTableEnd(component2, context.getResponseWriter());
        this.clearMetaInfo(component2);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderRow(FacesContext context, UIComponent table, UIComponent child, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        writer.startElement("td", table);
        if (info.columnClasses.length > 0) {
            writer.writeAttribute("class", info.getCurrentColumnClass(), "columns");
        }
        this.encodeRecursive(context, child);
        writer.endElement("td");
        writer.writeText("\n", table, null);
    }

    protected void renderHeader(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        UIComponent header = this.getFacet(table, "header");
        String headerClass = (String)table.getAttributes().get("headerClass");
        if (header != null) {
            writer.startElement("thead", table);
            writer.writeText("\n", table, null);
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", headerClass, "headerClass");
            }
            writer.writeAttribute("colspan", String.valueOf(info.columns.size()), null);
            writer.writeAttribute("scope", "colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            writer.endElement("tr");
            writer.writeText("\n", table, null);
            writer.endElement("thead");
            writer.writeText("\n", table, null);
        }
    }

    protected void renderFooter(FacesContext context, UIComponent table, ResponseWriter writer) throws IOException {
        BaseTableRenderer.TableMetaInfo info = this.getMetaInfo(table);
        UIComponent footer = this.getFacet(table, "footer");
        String footerClass = (String)table.getAttributes().get("footerClass");
        if (footer != null) {
            writer.startElement("tfoot", table);
            writer.writeText("\n", table, null);
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", footerClass, "footerClass");
            }
            writer.writeAttribute("colspan", String.valueOf(info.columns.size()), null);
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText("\n", table, null);
            writer.endElement("tfoot");
            writer.writeText("\n", table, null);
        }
    }
}

