/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;

public class ButtonRenderer
extends HtmlBasicRenderer {
    private static final String[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.COMMANDBUTTON);

    public void decode(FacesContext context, UIComponent component2) {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldDecode(component2)) {
            return;
        }
        if (ButtonRenderer.wasClicked(context, component2) && !ButtonRenderer.isReset(component2)) {
            component2.queueEvent(new ActionEvent(component2));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("This command resulted in form submission  ActionEvent queued.");
                logger.log(Level.FINE, "End decoding component {0}", component2.getId());
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
        if (!this.shouldEncode(component2)) {
            return;
        }
        String type = ButtonRenderer.getButtonType(component2);
        ResponseWriter writer = context.getResponseWriter();
        assert (writer != null);
        String label = "";
        Object value = ((UICommand)component2).getValue();
        if (value != null) {
            label = value.toString();
        }
        String imageSrc = (String)component2.getAttributes().get("image");
        writer.startElement("input", component2);
        this.writeIdAttributeIfNecessary(context, writer, component2);
        String clientId = component2.getClientId(context);
        if (imageSrc != null) {
            writer.writeAttribute("type", "image", "type");
            writer.writeURIAttribute("src", ButtonRenderer.src(context, imageSrc), "image");
            writer.writeAttribute("name", clientId, "clientId");
        } else {
            writer.writeAttribute("type", type, "type");
            writer.writeAttribute("name", clientId, "clientId");
            writer.writeAttribute("value", label, "value");
        }
        RenderKitUtils.renderPassThruAttributes(writer, component2, ATTRIBUTES);
        RenderKitUtils.renderXHTMLStyleBooleanAttributes(writer, component2);
        String styleClass = (String)component2.getAttributes().get("styleClass");
        if (styleClass != null && styleClass.length() > 0) {
            writer.writeAttribute("class", styleClass, "styleClass");
        }
        writer.endElement("input");
    }

    public void encodeEnd(FacesContext context, UIComponent component2) throws IOException {
        this.rendererParamsNotNull(context, component2);
    }

    private static String src(FacesContext context, String imageURI) {
        if (imageURI == null) {
            return "";
        }
        String u = context.getApplication().getViewHandler().getResourceURL(context, imageURI);
        return context.getExternalContext().encodeResourceURL(u);
    }

    private static boolean wasClicked(FacesContext context, UIComponent component2) {
        String clientId = component2.getClientId(context);
        Map<String, String> requestParameterMap = context.getExternalContext().getRequestParameterMap();
        if (requestParameterMap.get(clientId) == null) {
            StringBuilder builder = new StringBuilder(clientId);
            String xValue = builder.append(".x").toString();
            builder.setLength(clientId.length());
            String yValue = builder.append(".y").toString();
            return requestParameterMap.get(xValue) != null && requestParameterMap.get(yValue) != null;
        }
        return true;
    }

    private static boolean isReset(UIComponent component2) {
        return "reset".equals(component2.getAttributes().get("type"));
    }

    private static String getButtonType(UIComponent component2) {
        String type = (String)component2.getAttributes().get("type");
        if (type == null || !"reset".equals(type) && !"submit".equals(type)) {
            type = "submit";
            component2.getAttributes().put("type", type);
        }
        return type;
    }
}

