/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.ELUtils;
import com.sun.faces.util.FacesLogger;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class ELResolverInitPhaseListener
implements PhaseListener {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    private boolean postInitCompleted;
    private boolean preInitCompleted;

    public synchronized void afterPhase(PhaseEvent event2) {
        if (!this.postInitCompleted) {
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory("javax.faces.lifecycle.LifecycleFactory");
            Iterator<String> i = factory.getLifecycleIds();
            while (i.hasNext()) {
                Lifecycle lifecycle = factory.getLifecycle(i.next());
                lifecycle.removePhaseListener(this);
            }
            this.postInitCompleted = true;
        }
    }

    public synchronized void beforePhase(PhaseEvent event2) {
        if (!this.preInitCompleted) {
            ApplicationAssociate associate = ApplicationAssociate.getInstance(FacesContext.getCurrentInstance().getExternalContext());
            associate.setRequestServiced();
            this.populateFacesELResolverForJsp(event2.getFacesContext());
            this.preInitCompleted = true;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected void populateFacesELResolverForJsp(FacesContext context) {
        ApplicationAssociate appAssociate = ApplicationAssociate.getInstance(context.getExternalContext());
        CompositeELResolver compositeELResolverForJsp = appAssociate.getFacesELResolverForJsp();
        if (compositeELResolverForJsp == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.lifecycle.initphaselistener.resolvers_not_registered", new Object[]{appAssociate.getContextName()});
            }
            return;
        }
        ELUtils.buildJSPResolver(compositeELResolverForJsp, appAssociate);
        context.getApplication().getELResolver();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.lifecycle.initphaselistener.resolvers_registered", new Object[]{appAssociate.getContextName()});
        }
    }
}

