/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.context.ApplicationMap;
import com.sun.faces.context.InitParameterMap;
import com.sun.faces.context.RequestCookieMap;
import com.sun.faces.context.RequestHeaderMap;
import com.sun.faces.context.RequestHeaderValuesMap;
import com.sun.faces.context.RequestMap;
import com.sun.faces.context.RequestParameterMap;
import com.sun.faces.context.RequestParameterValuesMap;
import com.sun.faces.context.SessionMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.TypedCollections;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalContextImpl
extends ExternalContext {
    private ServletContext servletContext = null;
    private ServletRequest request = null;
    private ServletResponse response = null;
    private Map<String, Object> applicationMap = null;
    private Map<String, Object> sessionMap = null;
    private Map<String, Object> requestMap = null;
    private Map<String, String> requestParameterMap = null;
    private Map<String, String[]> requestParameterValuesMap = null;
    private Map<String, String> requestHeaderMap = null;
    private Map<String, String[]> requestHeaderValuesMap = null;
    private Map<String, Object> cookieMap = null;
    private Map<String, String> initParameterMap = null;
    private static final String EXTERNALCONTEXT_IMPL_ATTR_NAME = "com.sun.faces.ExternalContextImpl";
    static final Class theUnmodifiableMapClass = Collections.unmodifiableMap(new HashMap()).getClass();

    public ExternalContextImpl(ServletContext sc, ServletRequest request, ServletResponse response) {
        try {
            Util.parameterNonNull(sc);
            Util.parameterNonNull(request);
            Util.parameterNonNull(response);
        }
        catch (Exception e) {
            throw new FacesException(MessageUtils.getExceptionMessageString("com.sun.faces.FACES_CONTEXT_CONSTRUCTION_ERROR", new Object[0]));
        }
        this.servletContext = sc;
        this.request = request;
        this.response = response;
        WebConfiguration config = WebConfiguration.getInstance(sc);
        if (config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.SendPoweredByHeader)) {
            ((HttpServletResponse)response).addHeader("X-Powered-By", "JSF/1.2");
        }
        this.getRequestMap().put(EXTERNALCONTEXT_IMPL_ATTR_NAME, this);
    }

    @Override
    public Object getSession(boolean create) {
        return ((HttpServletRequest)this.request).getSession(create);
    }

    @Override
    public Object getContext() {
        return this.servletContext;
    }

    @Override
    public Object getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(Object request) {
        if (request instanceof ServletRequest) {
            this.request = (ServletRequest)request;
            this.requestHeaderMap = null;
            this.requestHeaderValuesMap = null;
            this.requestHeaderValuesMap = null;
            this.requestMap = null;
            this.requestParameterMap = null;
            this.requestParameterValuesMap = null;
        }
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(encoding);
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Object response) {
        if (response instanceof ServletResponse) {
            this.response = (ServletResponse)response;
        }
    }

    @Override
    public void setResponseCharacterEncoding(String encoding) {
        this.response.setCharacterEncoding(encoding);
    }

    @Override
    public Map<String, Object> getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new ApplicationMap(this.servletContext);
        }
        return this.applicationMap;
    }

    @Override
    public Map<String, Object> getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new SessionMap((HttpServletRequest)this.request);
        }
        return this.sessionMap;
    }

    @Override
    public Map<String, Object> getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new RequestMap(this.request);
        }
        return this.requestMap;
    }

    @Override
    public Map<String, String> getRequestHeaderMap() {
        if (null == this.requestHeaderMap) {
            this.requestHeaderMap = Collections.unmodifiableMap(new RequestHeaderMap((HttpServletRequest)this.request));
        }
        return this.requestHeaderMap;
    }

    @Override
    public Map<String, String[]> getRequestHeaderValuesMap() {
        if (null == this.requestHeaderValuesMap) {
            this.requestHeaderValuesMap = Collections.unmodifiableMap(new RequestHeaderValuesMap((HttpServletRequest)this.request));
        }
        return this.requestHeaderValuesMap;
    }

    @Override
    public Map<String, Object> getRequestCookieMap() {
        if (null == this.cookieMap) {
            this.cookieMap = Collections.unmodifiableMap(new RequestCookieMap((HttpServletRequest)this.request));
        }
        return this.cookieMap;
    }

    @Override
    public Map<String, String> getInitParameterMap() {
        if (null == this.initParameterMap) {
            this.initParameterMap = Collections.unmodifiableMap(new InitParameterMap(this.servletContext));
        }
        return this.initParameterMap;
    }

    @Override
    public Map<String, String> getRequestParameterMap() {
        if (null == this.requestParameterMap) {
            this.requestParameterMap = Collections.unmodifiableMap(new RequestParameterMap(this.request));
        }
        return this.requestParameterMap;
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        if (null == this.requestParameterValuesMap) {
            this.requestParameterValuesMap = Collections.unmodifiableMap(new RequestParameterValuesMap(this.request));
        }
        return this.requestParameterValuesMap;
    }

    @Override
    public Iterator<String> getRequestParameterNames() {
        final Enumeration namEnum = this.request.getParameterNames();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return namEnum.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)namEnum.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Locale getRequestLocale() {
        return this.request.getLocale();
    }

    @Override
    public Iterator<Locale> getRequestLocales() {
        return new LocalesIterator(this.request.getLocales());
    }

    @Override
    public String getRequestPathInfo() {
        return ((HttpServletRequest)this.request).getPathInfo();
    }

    public Cookie[] getRequestCookies() {
        return ((HttpServletRequest)this.request).getCookies();
    }

    @Override
    public String getRequestContextPath() {
        return ((HttpServletRequest)this.request).getContextPath();
    }

    @Override
    public String getRequestServletPath() {
        return ((HttpServletRequest)this.request).getServletPath();
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    public String getRequestContentType() {
        return this.request.getContentType();
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    @Override
    public String getResponseContentType() {
        return this.response.getContentType();
    }

    @Override
    public String getInitParameter(String name) {
        return this.servletContext.getInitParameter(name);
    }

    @Override
    public Set<String> getResourcePaths(String path) {
        return TypedCollections.dynamicallyCastSet(this.servletContext.getResourcePaths(path), String.class);
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        return this.servletContext.getResourceAsStream(path);
    }

    @Override
    public URL getResource(String path) {
        URL url;
        try {
            url = this.servletContext.getResource(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return url;
    }

    @Override
    public String encodeActionURL(String sb) {
        return ((HttpServletResponse)this.response).encodeURL(sb);
    }

    @Override
    public String encodeResourceURL(String sb) {
        return ((HttpServletResponse)this.response).encodeURL(sb);
    }

    @Override
    public String encodeNamespace(String aValue) {
        return aValue;
    }

    public String encodeURL(String url) {
        return ((HttpServletResponse)this.response).encodeURL(url);
    }

    @Override
    public void dispatch(String requestURI) throws IOException, FacesException {
        RequestDispatcher requestDispatcher = this.request.getRequestDispatcher(requestURI);
        if (requestDispatcher == null) {
            ((HttpServletResponse)this.response).sendError(404);
            return;
        }
        try {
            requestDispatcher.forward(this.request, this.response);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (ServletException se) {
            throw new FacesException(se);
        }
    }

    @Override
    public void redirect(String requestURI) throws IOException {
        ((HttpServletResponse)this.response).sendRedirect(requestURI);
        FacesContext.getCurrentInstance().responseComplete();
    }

    @Override
    public void log(String message) {
        this.servletContext.log(message);
    }

    @Override
    public void log(String message, Throwable throwable) {
        this.servletContext.log(message, throwable);
    }

    @Override
    public String getAuthType() {
        return ((HttpServletRequest)this.request).getAuthType();
    }

    @Override
    public String getRemoteUser() {
        return ((HttpServletRequest)this.request).getRemoteUser();
    }

    @Override
    public Principal getUserPrincipal() {
        return ((HttpServletRequest)this.request).getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return ((HttpServletRequest)this.request).isUserInRole(role);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalesIterator
    implements Iterator<Locale> {
        private Enumeration locales;

        public LocalesIterator(Enumeration locales) {
            this.locales = locales;
        }

        @Override
        public boolean hasNext() {
            return this.locales.hasMoreElements();
        }

        @Override
        public Locale next() {
            return (Locale)this.locales.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

