/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SecurityCache;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.token.WSCredentialTokenMapperInterface;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditEventGeneratorImpl;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditService;
import com.ibm.ws.webservices.wssecurity.audit.WSSAuditServiceImpl;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.token.LoginProcessor;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.IdUtil;
import com.ibm.ws.wssecurity.xss4j.dsig.util.Base64;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.security.token.TokenHolder;
import com.ibm.wsspi.security.token.WSOpaqueTokenHelper;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.TokenPropagationCallbackHandler;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import com.ibm.wsspi.wssecurity.auth.token.LTPATokenWrapper;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.token.TokenConsumerComponent;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenConsumer
implements TokenConsumerComponent {
    private static final TraceComponent tc = Tr.register(LTPATokenConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = LTPATokenConsumer.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Node node, Map map) throws SoapSecurityException {
        QName qName;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Node target[" + DOMUtil.getDisplayName((Node)node) + "], " + "Map context)"));
        }
        TokenConsumerConfig tokenConsumerConfig = (TokenConsumerConfig)map.remove("com.ibm.wsspi.wssecurity.config.tokenConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TokenConsumerConfig [" + tokenConsumerConfig + "]."));
        }
        if ((qName = tokenConsumerConfig.getType()) == null) {
            qName = Constants.LTPA_TOKEN;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No token value type defined in the Token Consumer configuration, defualt [" + Constants.LTPA_TOKEN.toString() + "] is used."));
            }
        } else if (!qName.equals(Constants.LTPA_TOKEN) && !qName.equals(Constants.LTPA_TOKEN_PROPAGATION)) {
            String string = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
            throw SoapSecurityException.format("security.wssecurity.WSEC0162E", new String[]{qName.toString(), clsName, string});
        }
        if (node.getNodeType() == 1) {
            Object object;
            Object object2;
            Element element = (Element)node;
            String string = null;
            String string2 = IdUtil.getInstance().getIdAttributeName(element);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The identifier attribute of the target element is [" + string2 + "]."));
            }
            if (string2 != null) {
                string = element.getAttribute(string2);
            }
            byte[] byArray = Base64.decode((String)DOMUtil.getStringValue((Node)node));
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Base64-decoded binary credential [" + byArray + "]"));
            }
            if (byArray == null || byArray.length == 0) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0163E");
            }
            int n = 0;
            Object v = map.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
            if (v != null && v instanceof Integer) {
                n = (Integer)v;
            }
            QName qName2 = DOMUtil.getQName((Element)element, (String)element.getAttribute("ValueType"), (int)n);
            boolean bl = false;
            if (qName2 == null) {
                throw SoapSecurityException.format("security.wssecurity.WSEC0164E", new String[]{qName.toString()});
            }
            if (!Constants.LTPA_TOKEN.equals(qName2)) {
                if (Constants.LTPA_TOKEN_PROPAGATION.equals(qName2)) {
                    bl = true;
                } else {
                    String string3 = Constants.LTPA_TOKEN.toString() + ", " + Constants.LTPA_TOKEN_PROPAGATION.toString();
                    throw SoapSecurityException.format("security.wssecurity.WSEC0165E", new String[]{qName.toString(), clsName, string3});
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("token propagation is " + bl));
            }
            LTPAToken lTPAToken = null;
            if (bl) {
                int n2;
                WSCredentialTokenMapperInterface wSCredentialTokenMapperInterface;
                ArrayList arrayList;
                SecurityCache securityCache;
                Object[] objectArray;
                block81: {
                    object2 = null;
                    objectArray = null;
                    object = null;
                    securityCache = null;
                    arrayList = null;
                    wSCredentialTokenMapperInterface = null;
                    wSCredentialTokenMapperInterface = _wsCredToken._wsCredTokenMapper;
                    securityCache = ContextManagerFactory.getInstance().getSecurityCache();
                    try {
                        arrayList = WSOpaqueTokenHelper.getInstance().createTokenHolderListFromOpaqueToken(byArray);
                        objectArray = this.getSubjectFromTokenHolderCacheKey(null, arrayList);
                    }
                    catch (WSSecurityException wSSecurityException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caught WSSecurityException trying to get cached Subject: " + wSSecurityException));
                        }
                    }
                    catch (Exception exception) {
                        if (!tc.isDebugEnabled()) break block81;
                        Tr.debug((TraceComponent)tc, (String)("Caught Exception trying to get cached Subject: " + exception));
                    }
                }
                if (objectArray != null) {
                    object2 = (Subject)objectArray[0];
                    object = (String)objectArray[1];
                }
                WSCredential wSCredential = null;
                WSPrincipal wSPrincipal = null;
                if (object2 != null) {
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object2);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object2);
                    if (wSCredential != null) {
                        boolean bl2 = wSCredential.isDestroyed();
                        n2 = 0;
                        try {
                            n2 = wSCredential.isForwardable();
                        }
                        catch (Exception exception) {
                            bl2 = true;
                        }
                        boolean bl3 = false;
                        if (securityCache != null && wSCredentialTokenMapperInterface != null) {
                            bl3 = wSCredentialTokenMapperInterface.checkCushionValidityOfAllTokens((Subject)object2, securityCache.getCushion());
                        }
                        if (tc.isDebugEnabled()) {
                            if (n2 != 0) {
                                Tr.debug((TraceComponent)tc, (String)("credential is forwardable, subject valid = " + bl3));
                            } else {
                                Tr.debug((TraceComponent)tc, (String)"non-forwardable Subject");
                            }
                        }
                        if (bl2 || n2 != 0 && !bl3) {
                            object2 = null;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Credential has expired or is destroyed, logging in again.");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Cached subject is valid.");
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No WSCredential in Subject, logging in again.");
                        }
                        object2 = null;
                    }
                }
                if (object2 == null) {
                    Object object3;
                    Object object4;
                    wSCredential = null;
                    wSPrincipal = null;
                    String string4 = tokenConsumerConfig.getJAASConfig();
                    if (string4 == null || string4.length() == 0) {
                        string4 = "system.WSS_INBOUND";
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Using JAAS config: " + string4));
                    }
                    n2 = 0;
                    if (arrayList != null) {
                        n2 = arrayList.size();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("tokenList size = " + n2));
                    }
                    byte[] byArray2 = null;
                    for (int i = 0; i < n2; ++i) {
                        object4 = arrayList.get(i);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("tokenList object [" + i + "] = " + object4.getClass().getName()));
                        }
                        if (!(object4 instanceof TokenHolder)) continue;
                        object3 = (TokenHolder)object4;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("th[" + i + "].name = " + ((TokenHolder)object3).getName()));
                            Tr.debug((TraceComponent)tc, (String)("th[" + i + "].version = " + ((TokenHolder)object3).getVersion()));
                        }
                        if (!"com.ibm.ws.security.token.AuthorizationTokenImpl".equals(((TokenHolder)object3).getName())) continue;
                        byArray2 = ((TokenHolder)object3).getBytes();
                        if (!tc.isDebugEnabled()) continue;
                        if (byArray2 != null && byArray2.length > 0) {
                            Tr.debug((TraceComponent)tc, (String)"Got cred bytes from authz TokenHolder");
                            continue;
                        }
                        Tr.debug((TraceComponent)tc, (String)"Cred bytes from authz TokenHolder was null or zero-length");
                    }
                    LoginContext loginContext = null;
                    try {
                        object4 = new TokenPropagationCallbackHandler(map, arrayList, byArray2);
                        loginContext = new LoginContext(string4, (CallbackHandler)object4);
                        loginContext.login();
                    }
                    catch (LoginException loginException) {
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                            object3 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, loginException.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object3, "AuthnType", qName.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData((Map)object3, string4, "SUCCESS");
                            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
                        }
                        Tr.processException((Throwable)loginException, (String)(LTPATokenConsumer.class.getName() + ".invoke()"), (String)"387", (Object)this);
                        throw new SoapSecurityException("Error logging in: " + loginException.getClass().getName() + ": " + loginException.getMessage());
                    }
                    object2 = object4 = loginContext.getSubject();
                    if (object == null || ((String)object).length() == 0) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No cache key string found in token list; will not cache new subject.");
                        }
                    } else if (securityCache != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caching new subject with cache key string: " + (String)object));
                        }
                        securityCache.insert((Subject)object4, new Object[]{object});
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Not caching new subject because Securitycache instance is null.");
                    }
                    wSCredential = SubjectHelper.getWSCredentialFromSubject((Subject)object4);
                    wSPrincipal = SubjectHelper.getPrincipalFromSubject((Subject)object4);
                    lTPAToken = new LTPATokenWrapper(string, null, wSCredential, wSPrincipal);
                    if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                        object3 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object3, "AuthnType", tokenConsumerConfig.getType().toString());
                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object3, "TokenId", lTPAToken.getId());
                        WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object3, "Username", wSPrincipal.getName());
                        WSSAuditEventGeneratorImpl.getInstance().addProviderData((Map)object3, string4, "SUCCESS");
                        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                        WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
                    }
                }
                final LTPAToken lTPAToken2 = lTPAToken;
                final TokenConsumerConfig tokenConsumerConfig2 = tokenConsumerConfig;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        lTPAToken2.setUsedTokenConsumer(tokenConsumerConfig2);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(map, lTPAToken);
                if (object2 != null) {
                    LoginProcessor.addToSubject((Map)map, (Subject)object2);
                }
            } else {
                Object object5;
                lTPAToken = new LTPAToken(string, null);
                object2 = (Boolean)tokenConsumerConfig.getProperties().get("com.ibm.wsspi.wssecurity.token.decouple");
                boolean bl4 = true;
                if (object2 != null) {
                    bl4 = (Boolean)object2;
                }
                object = null;
                object = !bl4 ? element : DOMUtil.clone((Element)element);
                lTPAToken.setElement((Element)object);
                final LTPAToken lTPAToken3 = lTPAToken;
                final TokenConsumerConfig tokenConsumerConfig3 = tokenConsumerConfig;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        lTPAToken3.setUsedTokenConsumer(tokenConsumerConfig3);
                        return null;
                    }
                });
                LTPATokenConsumer.setTokenToSubject(map, lTPAToken);
                final LTPAToken lTPAToken4 = lTPAToken;
                final byte[] byArray3 = byArray;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        lTPAToken4.setBytes(byArray3);
                        return null;
                    }
                });
                WSSConsumerConfig wSSConsumerConfig = (WSSConsumerConfig)map.get("com.ibm.wsspi.wssecurity.config.wssConsumer.configKey");
                Set set = wSSConsumerConfig.getCallers();
                boolean bl5 = false;
                if (set != null) {
                    for (Object object6 : set) {
                        object5 = object6.getTokenType();
                        if (!((QName)object5).equals(qName2)) continue;
                        bl5 = true;
                        break;
                    }
                }
                if (!bl5) {
                    Object object6;
                    Object object7 = null;
                    try {
                        object6 = getLTPAMethod._validateLTPATokenMethod;
                        object5 = getLTPAMethod._ltpaServerObject;
                        if (object6 != null && object5 != null) {
                            object7 = ((Method)object6).invoke(object5, new Object[]{byArray});
                        }
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.SUCCESS)) {
                            Map map2 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.SUCCESS, WSSAuditService.WSSAuditReason.AUTHN_SUCCESS, null);
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map2, "AuthnType", tokenConsumerConfig.getType().toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData(map2, "TokenId", string);
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData(map2, tokenConsumerConfig.getJAASConfig(), "SUCCESS");
                            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Auditing SECURITY_AUTHN event not enabled.");
                        }
                    }
                    catch (Exception exception) {
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.ERROR)) {
                            object5 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.ERROR, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, exception.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object5, "AuthnType", tokenConsumerConfig.getType().toString());
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData((Map)object5, tokenConsumerConfig.getJAASConfig(), "FAILURE");
                            SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, sOAPMessageContext, map);
                        }
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                    if (object7 == null) {
                        if (WSSAuditServiceImpl.getInstance().isEventRequired(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, WSSAuditService.WSSAuditOutcome.DENIED)) {
                            object6 = WSSAuditEventGeneratorImpl.getInstance().setAuditEventContext(map, WSSAuditService.WSSAuditOutcome.DENIED, WSSAuditService.WSSAuditReason.AUTHN_LOGIN_EXCEPTION, null);
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object6, "AuthnType", qName.toString());
                            WSSAuditEventGeneratorImpl.getInstance().addExtendedAuditData((Map)object6, "TokenId", lTPAToken.getId());
                            WSSAuditEventGeneratorImpl.getInstance().addProviderData((Map)object6, tokenConsumerConfig.getJAASConfig(), "SUCCESS");
                            object5 = (SOAPMessageContext)map.get("com.ibm.wsspi.wssecurity.core.messageContext");
                            WSSAuditEventGeneratorImpl.getInstance().sendEvent(WSSAuditService.WSSAuditEventType.SECURITY_AUTHN, (SOAPMessageContext)object5, map);
                        }
                        throw new SoapSecurityException("security.wssecurityLTPA Token validation failed");
                    }
                }
            }
            object2 = tokenConsumerConfig.getJAASConfig();
            if (object2 != null && !bl && tc.isDebugEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"security.wssecurity.LTPATokenConsumer.s01", (Object)object2);
            }
            if (tokenConsumerConfig.getTrustedIDEvaluator() != null) {
                boolean bl6 = tokenConsumerConfig.getTrustedIDEvaluator().evaluate("***");
                object = lTPAToken;
                if (!bl6) {
                    Tr.warning((TraceComponent)tc, (String)"security.wssecurity.UsernameTokenConsumer.s02", (Object)new Object[]{string});
                }
                AccessController.doPrivileged(new PrivilegedAction((LTPAToken)object, bl6){
                    final /* synthetic */ LTPAToken val$tokenPriv;
                    final /* synthetic */ boolean val$trusted;
                    {
                        this.val$tokenPriv = lTPAToken;
                        this.val$trusted = bl;
                    }

                    public Object run() {
                        this.val$tokenPriv.setTrusted(this.val$trusted);
                        return null;
                    }
                });
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Acquired token is [" + lTPAToken + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("WARNING: Unsupported node type: " + node.getNodeName()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Node target,Map context)");
        }
    }

    private static void setTokenToSubject(Map map, LTPAToken lTPAToken) {
        TokenManager.setToken((Map)map, (Token)lTPAToken);
    }

    private Object[] getSubjectFromTokenHolderCacheKey(byte[] byArray, List list) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey", (Object)new Object[]{byArray, list});
        }
        Subject subject = null;
        String string = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                Object object;
                TokenHolder tokenHolder = (TokenHolder)list.get(i);
                if (!tokenHolder.getName().equals("com.ibm.wsspi.security.cred.cacheKey")) continue;
                byte[] byArray2 = tokenHolder.getBytes();
                if (byArray2 != null) {
                    string = StringBytesConversion.getConvertedString((byte[])byArray2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found cache key from token holder list: " + string));
                    }
                    object = ContextManagerFactory.getInstance().getSecurityCache();
                    subject = object.getSubject((Object)string);
                }
                if (subject == null) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found Subject using cacheKey from prop token.");
                }
                if (byArray == null) continue;
                object = SubjectHelper.getWSCredentialFromSubject(subject);
                SingleSignonToken singleSignonToken = SubjectHelper.getDefaultSSOTokenFromSubject(subject);
                boolean bl2 = bl = object != null && Arrays.equals(byArray, object.getCredentialToken()) || singleSignonToken != null && Arrays.equals(byArray, singleSignonToken.getBytes());
                if (bl) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Subject found from cacheKey does not have matching LTPA token.");
                }
                subject = null;
            }
        }
        Object[] objectArray = null;
        if (subject != null || string != null) {
            objectArray = new Object[]{subject, string};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubjectFromTokenHolderCacheKey", objectArray);
        }
        return objectArray;
    }

    private static class _wsCredToken {
        static WSCredentialTokenMapperInterface _wsCredTokenMapper = null;

        private _wsCredToken() {
        }

        static {
            try {
                Class<?> clazz = Class.forName("com.ibm.ws.security.token.WSCredentialTokenMapper");
                Object obj = clazz.newInstance();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got instance of WSCredTokenMapper.");
                }
                _wsCredTokenMapper = (WSCredentialTokenMapperInterface)obj;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(clsName + "init"), (String)"788");
            }
        }
    }

    private static class getLTPAMethod {
        private static final String LTPA_SERVER_OBJECT_CLASS = "com.ibm.ws.security.ltpa.LTPAServerObject";
        private static Class _ltpaServerObjectClass = null;
        private static Method _validateLTPATokenMethod = null;
        private static Method _getLTPAServerMethod = null;
        private static Object _ltpaServerObject = null;

        private getLTPAMethod() {
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (_ltpaServerObjectClass == null) {
                        Class<?> clazz = null;
                        try {
                            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                            clazz = classLoader != null ? classLoader.loadClass(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS) : Class.forName(getLTPAMethod.LTPA_SERVER_OBJECT_CLASS);
                            _ltpaServerObjectClass = clazz;
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    if (_getLTPAServerMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _getLTPAServerMethod = _ltpaServerObjectClass.getMethod("getLTPAServer", new Class[0]);
                            if (_getLTPAServerMethod != null) {
                                _ltpaServerObject = _getLTPAServerMethod.invoke(null, new Object[0]);
                            }
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    if (_validateLTPATokenMethod == null && _ltpaServerObjectClass != null) {
                        try {
                            _validateLTPATokenMethod = _ltpaServerObjectClass.getMethod("validateToken", byte[].class);
                        }
                        catch (Exception exception) {
                            throw new UndeclaredThrowableException(exception);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

