/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.config;

import com.ibm.ws.webservices.wssecurity.util.CORBAHelper;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocatorException;
import com.ibm.wsspi.wssecurity.config.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;

public class WSIdKeyStoreMapKeyLocator
extends KeyStoreKeyLocator {
    private static final TraceComponent tc = Tr.register(WSIdKeyStoreMapKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private Map secName2KeyName = new HashMap();

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(map)");
        }
        super.init(map);
        for (String string : map.keySet()) {
            if (!string.startsWith("id_")) continue;
            String string2 = (String)map.get(string);
            String string3 = (String)map.get("mappedName_" + string.substring("id_".length()));
            this.secName2KeyName.put(string2, string3);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("init() - " + string + ": secName \"" + string2 + "\" maps to keyName \"" + string3 + "\""));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init()");
        }
    }

    public Key getEncryptionKey(String string, Object object) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getEncryptionKey(" + string + "," + object + ")"));
        }
        Key key = super.getEncryptionKey(this.getKeyName(), object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getEncryptionKey(String name, Object context) returns " + key));
        }
        return key;
    }

    public Certificate getCertificate(String string) throws KeyLocatorException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCertificate(" + string + ")"));
        }
        Certificate certificate = super.getCertificate(this.getKeyName());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCertificate(String name) returns " + certificate));
        }
        return certificate;
    }

    private String getKeyName() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKeyName()");
        }
        String string = WSIdKeyStoreMapKeyLocator.unqualifySecurityName(CORBAHelper.getSecurityName());
        String string2 = null;
        if (this.secName2KeyName.containsKey(string)) {
            string2 = (String)this.secName2KeyName.get(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKeyName() returns " + string2));
        }
        return string2;
    }

    private static String unqualifySecurityName(String string) {
        int n;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Qualified security name: " + string));
        }
        String string2 = string;
        if (string != null && string.length() != 0 && (n = string.indexOf("/")) != -1) {
            string2 = string.substring(n + 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Security name: " + string2));
        }
        return string2;
    }
}

