/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.module.BSTokenLoginModule;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.security.Provider;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import javax.security.auth.login.LoginException;

public class X509LoginModule
extends BSTokenLoginModule {
    protected static final TraceComponent tc = Tr.register(X509LoginModule.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509LoginModule.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        if (bl = super.login()) {
            Object object;
            Object object2;
            Object object3;
            if (this._cert == null) {
                try {
                    this._cert = CertificateUtil.generateX509Certificate((byte[])this._binary, null);
                }
                catch (Exception exception) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s01", (String[])new String[]{exception.toString()}));
                }
            }
            if (this._cert == null) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.setCertToSubject01"));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Succeeded to generate a X509 certificate [" + this._cert + "]"));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Checking the validity of X509 certificate...");
                }
                this._cert.checkValidity();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to check the validity of X509 certificate.");
                }
            }
            catch (Exception exception) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s02", (String[])new String[]{exception.toString()}));
            }
            boolean bl2 = false;
            String string = (String)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.trustAny");
            if (string != null && string.length() > 0) {
                bl2 = ConfigUtil.isTrue((String)string);
                if (tc.isDebugEnabled() && bl2) {
                    Tr.debug((TraceComponent)tc, (String)"This login module trusts any certificate.");
                }
            }
            if (!bl2) {
                string = (String)this._properties.get(Constants.WSSECURITY_ISSUER_NAME);
                String string2 = (String)this._properties.get(Constants.WSSECURITY_ISSUER_SERIAL);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Issuer name of its own certificate is [" + string + "]."));
                    Tr.debug((TraceComponent)tc, (String)("Serial number of its own certificate is [" + string2 + "]."));
                }
                if (string != null && string2 != null) {
                    object3 = this._cert.getIssuerDN().getName();
                    object3 = KeyInfo.X509Data.encodeDName((String)object3);
                    object2 = KeyInfo.X509Data.encodeDName((String)string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Comparing issuer name of a certificate [" + (String)object3 + "] with [" + (String)object2 + "]."));
                    }
                    if (((String)object3).equals(object2)) {
                        object = this._cert.getSerialNumber();
                        BigInteger bigInteger = null;
                        try {
                            bigInteger = CertificateUtil.convertSerialNumber((String)string2);
                        }
                        catch (ParseException parseException) {
                            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s04", (String[])new String[]{string2, parseException.toString()}));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Comparing issuer serial of a certificate [" + object + "] with [" + bigInteger + "]."));
                        }
                        if (((BigInteger)object).equals(bigInteger)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"The cert is its own certificate, so this login module trusts it.");
                            }
                            bl2 = true;
                        }
                    }
                } else if (string != null) {
                    Tr.debug((TraceComponent)tc, (String)"There is issuer name, but not serial number.");
                } else if (string2 != null) {
                    Tr.debug((TraceComponent)tc, (String)"There is serial number, but not issur name.");
                }
            }
            if (!bl2) {
                object3 = (Provider)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
                object2 = (PKIXBuilderParameters)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam");
                if (object2 == null) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s05"));
                }
                object = object2;
                synchronized (object) {
                    object2 = (PKIXBuilderParameters)((PKIXParameters)object2).clone();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Provider [" + object3 + "], PKIBuilderParameters [" + object2 + "]."));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Checking the cert path...");
                    }
                    CertificateUtil.validateX509Certificate((X509Certificate)this._cert, (Provider)object3, (PKIXParameters)object2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Succeeded to validate the cert path.");
                    }
                }
                catch (Exception exception) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s03", (String[])new String[]{exception.toString()}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return true;
    }
}

