/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BSTokenCallbackHandler;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class X509CallbackHandler
extends BSTokenCallbackHandler {
    private static final TraceComponent tc = Tr.register(X509CallbackHandler.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509CallbackHandler.class.getName();

    public X509CallbackHandler(Map map) {
        super(map);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"X509CallbackHandler(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"X509CallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        BSTokenCallbackHandler.TokenInformation tokenInformation;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
        }
        if ((tokenInformation = super._handle(callbackArray)) != null && tokenInformation._config != null) {
            try {
                Certificate certificate;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Getting the X509 Certificate with the alias [" + tokenInformation._alias + "]."));
                }
                if ((certificate = tokenInformation._config.getCertificate(tokenInformation._alias)) == null) {
                    throw this.processError(tokenInformation);
                }
                if (certificate instanceof X509Certificate) {
                    tokenInformation._bsCallback.setCert((X509Certificate)certificate);
                    tokenInformation._bsCallback.setKeyStorePath(tokenInformation._config.getKeyStorePath());
                    tokenInformation._bsCallback.setAlias(tokenInformation._alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Succeeded to get the X509 Certificate with the alias [" + tokenInformation._alias + "]."));
                    }
                }
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, (String)(clsName + ".handle"), (String)"106", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.X509CallbackHandler.s01", (Object)new Object[]{soapSecurityException});
                IOException iOException = new IOException(soapSecurityException.getMessage());
                iOException.initCause(soapSecurityException);
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
        }
    }
}

