/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.callback.BSTokenCallbackHandler;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class PkiPathCallbackHandler
extends BSTokenCallbackHandler {
    private static final TraceComponent tc = Tr.register(PkiPathCallbackHandler.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathCallbackHandler.class.getName();

    public PkiPathCallbackHandler(Map map) {
        super(map);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PkiPathCallbackHandler(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PkiPathCallbackHandler(Map properties)");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        BSTokenCallbackHandler.TokenInformation tokenInformation;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)".handle(Callback[] callbacks)");
        }
        if ((tokenInformation = super._handle(callbackArray)) != null && tokenInformation._config != null) {
            Provider provider = (Provider)tokenInformation._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            List list = (List)tokenInformation._properties.get("com.ibm.wsspi.wssecurity.token.x509.certStores");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Provider [" + provider + "], CertStores [" + list + "]."));
            }
            try {
                byte[] byArray;
                Certificate certificate;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Getting the X509 Certificate with the alias [" + tokenInformation._alias + "]."));
                }
                if ((certificate = tokenInformation._config.getCertificate(tokenInformation._alias)) == null) {
                    throw this.processError(tokenInformation);
                }
                if (certificate instanceof X509Certificate) {
                    tokenInformation._bsCallback.setCert((X509Certificate)certificate);
                    tokenInformation._bsCallback.setKeyStorePath(tokenInformation._config.getKeyStorePath());
                    tokenInformation._bsCallback.setAlias(tokenInformation._alias);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Succeeded to get the X509 Certificate with the alias [" + tokenInformation._alias + "]."));
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Genarating the pki path with the alias [" + tokenInformation._alias + "]."));
                }
                if ((byArray = CertificateUtil.encodePkiPath((Provider)provider, (List)list, (KeyStore)tokenInformation._config.getKeyStore(), (String)tokenInformation._alias)) == null) {
                    throw new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s02"));
                }
                tokenInformation._bsCallback.setBinary(byArray);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Succeeded to generate the pki path with the alias [" + tokenInformation._alias + "]."));
                }
            }
            catch (CertificateException certificateException) {
                Tr.processException((Throwable)certificateException, (String)(clsName + ".handle"), (String)"137", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.PkiPathCallbackHandler.s01", (Object)new Object[]{certificateException});
                IOException iOException = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s01", (String[])new String[]{certificateException.getClass().getName() + ": " + certificateException.getMessage()}));
                iOException.initCause(certificateException);
                throw iOException;
            }
            catch (KeyStoreException keyStoreException) {
                Tr.processException((Throwable)keyStoreException, (String)(clsName + ".handle"), (String)"144", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.PkiPathCallbackHandler.s01", (Object)new Object[]{keyStoreException});
                IOException iOException = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s01", (String[])new String[]{keyStoreException.getClass().getName() + ": " + keyStoreException.getMessage()}));
                iOException.initCause(keyStoreException);
                throw iOException;
            }
            catch (SoapSecurityException soapSecurityException) {
                Tr.processException((Throwable)soapSecurityException, (String)(clsName + ".handle"), (String)"151", (Object)this);
                Tr.error((TraceComponent)tc, (String)"security.wssecurity.PkiPathCallbackHandler.s01", (Object)new Object[]{soapSecurityException});
                IOException iOException = new IOException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathCallbackHandler.s01", (String[])new String[]{soapSecurityException.getClass().getName() + ": " + soapSecurityException.getMessage()}));
                iOException.initCause(soapSecurityException);
                throw iOException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handle(Callback[] callbacks)");
        }
    }
}

