/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.ClauseNode;
import com.ibm.ws.webcontainer.webapp.WebAppDispatcherContext;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class URIMatcher
extends com.ibm.ws.util.URIMatcher {
    private static Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.wsspi.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.URIMatcher";
    private static String SLASH_STAR = "/*";

    public URIMatcher() {
    }

    public URIMatcher(boolean scalable) {
        super(scalable);
    }

    public Object match(IExtendedRequest req) {
        ClauseNode currentNode = this.root;
        ClauseNode prevNode = this.root;
        ClauseNode starNode = null;
        ClauseNode temp = null;
        WebAppDispatcherContext dispatchContext = (WebAppDispatcherContext)req.getWebAppDispatcherContext();
        String uri = dispatchContext.getRelativeUri().trim();
        dispatchContext.setPossibleSlashStarMapping(true);
        int lastStarLoc = 0;
        int prevLoc = 0;
        int jsessionIndex = uri.indexOf(59);
        int duplicateJSessionIndex = -1;
        boolean exact = true;
        int len = uri.length();
        int dot = -1;
        dot = jsessionIndex == -1 ? uri.lastIndexOf(46) : uri.substring(0, jsessionIndex).lastIndexOf(46);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "match", "uri->" + uri);
            logger.logp(Level.FINE, CLASS_NAME, "match", "jsessionIndex->" + jsessionIndex + ", index Of Dot For Extension Mapping-->" + dot);
        }
        int hash = 0;
        for (int i = 1; i < len; ++i) {
            char c = uri.charAt(i);
            if (c == '/') {
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                    break;
                }
                if (i == len - 1 && dot != -1 && (jsessionIndex == -1 || dot < jsessionIndex)) {
                    if (currentNode.traverse(this.star) == null) {
                        exact = false;
                        break;
                    }
                } else {
                    temp = prevNode.traverse(this.star);
                    if (temp != null) {
                        lastStarLoc = prevLoc;
                        starNode = temp;
                    }
                    prevNode = currentNode;
                    prevLoc = i;
                }
                hash = 0;
                continue;
            }
            if (i == len - 1) {
                if ((currentNode = currentNode.traverse(hash = range * hash + c)) != null) continue;
                exact = false;
                continue;
            }
            if (c == ';') {
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "match", "found a semicolon");
                }
                if ((currentNode = currentNode.traverse(hash)) == null) {
                    exact = false;
                }
                duplicateJSessionIndex = i;
                break;
            }
            hash = range * hash + c;
        }
        Object target = null;
        if (exact) {
            target = currentNode.getTarget();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "found exact target-->" + target);
            }
            if (target != null) {
                String pathInfo;
                String servletPath = jsessionIndex == -1 ? uri : uri.substring(0, jsessionIndex);
                String string = pathInfo = jsessionIndex == -1 ? null : uri.substring(jsessionIndex);
                if (servletPath.endsWith(SLASH_STAR)) {
                    servletPath = servletPath.substring(0, servletPath.length() - 2);
                    pathInfo = SLASH_STAR;
                }
                if (prevLoc > 0) {
                    dispatchContext.setPossibleSlashStarMapping(false);
                }
                dispatchContext.setPathElements(servletPath, pathInfo);
                return target;
            }
            temp = currentNode.traverse(this.star);
            if (temp != null && (target = temp.getTarget()) != null) {
                if (prevLoc > 0) {
                    dispatchContext.setPossibleSlashStarMapping(false);
                }
                dispatchContext.setPathElements(jsessionIndex == -1 ? uri : uri.substring(0, jsessionIndex), jsessionIndex == -1 ? null : uri.substring(jsessionIndex));
                return target;
            }
        }
        if ((temp = prevNode.traverse(this.star)) != null) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "found star node-->" + temp);
            }
            starNode = temp;
            lastStarLoc = prevLoc;
        }
        if (starNode != null && starNode != this.defaultNode) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "starNode exists and is not default node");
            }
            if (prevLoc > 0) {
                dispatchContext.setPossibleSlashStarMapping(false);
            }
            dispatchContext.setPathElements(uri.substring(0, lastStarLoc), uri.substring(lastStarLoc));
            return starNode.getTarget();
        }
        if (dot != -1 && (jsessionIndex == -1 || dot < jsessionIndex)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "looking for extension mapping");
            }
            String extensionStr = jsessionIndex == -1 ? uri.substring(dot + 1) : uri.substring(dot + 1, jsessionIndex);
            target = this.extensions.get(extensionStr);
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "match", "extensionStr-->" + extensionStr + ", target-->" + target);
            }
            if (target != null) {
                if (prevLoc > 0) {
                    dispatchContext.setPossibleSlashStarMapping(false);
                }
                dispatchContext.setPathElements(jsessionIndex == -1 ? uri : uri.substring(0, jsessionIndex), jsessionIndex == -1 ? null : uri.substring(jsessionIndex));
                return target;
            }
        }
        if (starNode != null) {
            dispatchContext.setPossibleSlashStarMapping(true);
            dispatchContext.setPathElements("", uri);
            return starNode.getTarget();
        }
        return null;
    }
}

