/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHelper {
    private static final TraceComponent tc = Tr.register(RegistryHelper.class, null, "com.ibm.ejs.resources.security");
    private static SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static UserRegistry getUserRegistry(String var0) throws WSSecurityException {
        if (RegistryHelper.tc.isEntryEnabled()) {
            Tr.entry(RegistryHelper.tc, "getUserRegistry", var0);
        }
        var1_1 = null;
        if (var0 == null || var0.length() == 0) {
            var1_1 = ContextManagerFactory.getInstance().getRegistry(null);
        } else {
            var2_2 = null;
            if (RegistryHelper.scm != null) {
                var2_2 = RegistryHelper.scm.getDomainForRealm(var0);
            }
            if (var2_2 != null && var2_2.length() > 0) {
                var3_3 = false;
                var4_4 = "domain";
                if (var2_2.equals("admin")) {
                    var4_4 = "admin";
                }
                try {
                    var3_3 = SecurityObjectLocator.pushContext((String)var2_2, (String)var4_4);
                    var5_5 = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
                    var1_1 = (UserRegistry)var5_5.getUserRegistryStub();
                }
                catch (Exception var5_6) {
                    if (!RegistryHelper.tc.isDebugEnabled()) ** GOTO lbl31
                    Tr.debug(RegistryHelper.tc, "getUserRegistry unexpected exception getting registry stub for domain: " + var2_2, var5_6);
                }
                finally {
                    if (var3_3) {
                        SecurityObjectLocator.popContext();
                    }
                }
            } else if (RegistryHelper.tc.isDebugEnabled()) {
                Tr.debug(RegistryHelper.tc, "no domain is configured with the active user registry that matches the realm name " + var0);
            }
        }
lbl31:
        // 7 sources

        if (RegistryHelper.tc.isEntryEnabled()) {
            Tr.exit(RegistryHelper.tc, "getRegistry", var1_1);
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static List<String> getInboundTrustedRealms(String var0) throws WSSecurityException {
        if (RegistryHelper.tc.isEntryEnabled()) {
            Tr.entry(RegistryHelper.tc, "getInboundTrustedRealms", var0);
        }
        var1_1 = new ArrayList<String>();
        var2_2 = false;
        var3_3 = null;
        if (var0 == null) {
            var3_3 = SecurityObjectLocator.getSecurityConfig().getInboundTrustedAuthenticationRealm();
        } else {
            var4_4 = null;
            if (RegistryHelper.scm != null) {
                var4_4 = RegistryHelper.scm.getDomainForRealm(var0);
            }
            if (var4_4 != null && var4_4.length() > 0) {
                var5_6 = false;
                var6_8 = "domain";
                if (var4_4.equals("admin")) {
                    var6_8 = "admin";
                }
                try {
                    var5_6 = SecurityObjectLocator.pushContext((String)var4_4, (String)var6_8);
                    var3_3 = SecurityObjectLocator.getSecurityConfig().getInboundTrustedAuthenticationRealm();
                }
                catch (Exception var7_10) {
                    if (!RegistryHelper.tc.isDebugEnabled()) ** GOTO lbl32
                    Tr.debug(RegistryHelper.tc, "getInboundTrustedAuthenticationRealm caught unexpected exception for domain: " + var4_4, var7_10);
                }
                finally {
                    if (var5_6) {
                        SecurityObjectLocator.popContext();
                    }
                }
            } else if (RegistryHelper.tc.isDebugEnabled()) {
                Tr.debug(RegistryHelper.tc, "no domain is configured with the active user registry that matches the realm name " + var0);
            }
        }
lbl32:
        // 7 sources

        if (var3_3 != null) {
            var4_5 = var3_3.getTrustAllRealms();
            if (var4_5) {
                if (RegistryHelper.tc.isDebugEnabled()) {
                    Tr.debug(RegistryHelper.tc, "all realms are trusted");
                }
                var1_1.add("*");
            } else {
                var5_7 = var3_3.getRealmList();
                if (var5_7 != null && var5_7.length() > 0) {
                    if (RegistryHelper.tc.isDebugEnabled()) {
                        Tr.debug(RegistryHelper.tc, "realmsList = " + var5_7);
                    }
                    try {
                        var6_8 = new StringTokenizer(var5_7, "|");
                        while (var6_8.hasMoreTokens()) {
                            var7_11 = var6_8.nextToken();
                            if (RegistryHelper.tc.isDebugEnabled()) {
                                Tr.debug(RegistryHelper.tc, "adding realm : " + var7_11 + " to the list");
                            }
                            var1_1.add(var7_11);
                        }
                    }
                    catch (Exception var6_9) {
                        if (RegistryHelper.tc.isEntryEnabled()) {
                            Tr.exit(RegistryHelper.tc, "getInboundTrustedRealms");
                        }
                        throw new WSSecurityException(var6_9.getMessage(), var6_9);
                    }
                }
                var6_8 = SecurityObjectLocator.getSecurityConfig((String)"security").getActiveUserRegistry().getString("realm");
                if (RegistryHelper.tc.isDebugEnabled()) {
                    Tr.debug(RegistryHelper.tc, "adding adminRealm =  " + (String)var6_8);
                }
                if (var6_8 != null) {
                    var1_1.add((String)var6_8);
                }
            }
        }
        if (RegistryHelper.tc.isEntryEnabled()) {
            Tr.exit(RegistryHelper.tc, "getInboundTrustedRealms", var1_1);
        }
        return var1_1;
    }

    public static boolean isRealmInboundTrusted(String string, String string2) {
        if (string == null) {
            return false;
        }
        try {
            List<String> list = RegistryHelper.getInboundTrustedRealms(string2);
            if (list.contains("*")) {
                return true;
            }
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!string.equalsIgnoreCase(iterator.next())) continue;
                return true;
            }
            return false;
        }
        catch (WSSecurityException wSSecurityException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSecurityException caught: " + wSSecurityException.getMessage());
            }
            return false;
        }
    }
}

