/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.policy;

import com.ibm.ws.security.policy.WSPolicyIterator;
import com.ibm.wsspi.security.policy.WSPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPolicies
implements WSPolicy {
    private static final long serialVersionUID = 1L;
    private static final String myClassName = AbstractPolicies.class.getName();
    private static final Logger log = Logger.getLogger(myClassName, "com.ibm.ejs.resources.security");
    private List<WSPolicy> policies;
    private Map<Class, Object> adapterCache;

    public AbstractPolicies() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "AbstractPolicies()");
        }
        this.policies = new ArrayList<WSPolicy>();
        this.adapterCache = new HashMap<Class, Object>();
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "AbstractPolicies()");
        }
    }

    @Override
    public void add(WSPolicy wSPolicy) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "add(WSPolicy)", wSPolicy);
        }
        this.policies.add(wSPolicy);
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, myClassName, "add(WSPolicy)", wSPolicy + " added.");
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "add(WSPolicy)");
        }
    }

    @Override
    public Object getExtensionAdapter(Class clazz) {
        Object object;
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "getExtensionAdapter(Class)", clazz);
        }
        if ((object = this.adapterCache.get(clazz)) == null) {
            object = Platform.getAdapterManager().getAdapter((Object)this, clazz);
            this.adapterCache.put(clazz, object);
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, myClassName, "getExtensionAdapter(Class)", "adapterCache=" + this.adapterCache);
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "getExtensionAdapter(Class)", object);
        }
        return object;
    }

    @Override
    public boolean isComplete() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "isComplete()");
        }
        boolean bl = true;
        for (WSPolicy wSPolicy : this) {
            if (bl = bl && wSPolicy.isComplete()) continue;
            break;
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "isComplete()", bl);
        }
        return bl;
    }

    @Override
    public Iterator<WSPolicy> iterator() {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "iterator()");
        }
        WSPolicyIterator wSPolicyIterator = new WSPolicyIterator(this.policies.iterator());
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "iterator()", wSPolicyIterator);
        }
        return wSPolicyIterator;
    }

    @Override
    public void remove(WSPolicy wSPolicy) {
        if (log.isLoggable(Level.FINER)) {
            log.entering(myClassName, "remove(WSPolicy)", wSPolicy);
        }
        int n = this.policies.indexOf(wSPolicy);
        while (n != -1) {
            this.policies.remove(n);
            if (log.isLoggable(Level.FINER)) {
                log.logp(Level.FINER, myClassName, "remove(WSPolicy)", wSPolicy + " removed.");
            }
            n = this.policies.indexOf(wSPolicy);
        }
        if (log.isLoggable(Level.FINER)) {
            log.exiting(myClassName, "remove(WSPolicy)");
        }
    }

    public String toString() {
        return super.toString() + " WSPolicy list=" + this.policies + " adapterCache size=" + this.adapterCache.size();
    }
}

