/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.runtime.component;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.component.ContainerHelper;
import com.ibm.ws.runtime.config.ConfigLocator;
import com.ibm.ws.runtime.config.ConfigLocatorAdapter;
import com.ibm.ws.runtime.config.ContainerConfig;
import com.ibm.ws.runtime.provisioning.ComponentMetaDataMgr;
import com.ibm.wsspi.runtime.component.WsComponent;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsContainer
extends WsComponentImpl {
    private static final TraceComponent tc = Tr.register(WsContainer.class, "Runtime", "com.ibm.ws.runtime.runtime");
    private List components = Collections.EMPTY_LIST;
    private List<Object> applicationComponents = Collections.EMPTY_LIST;
    private List children = Collections.synchronizedList(new ArrayList());
    private Map componentStartupData = Collections.synchronizedMap(new HashMap());
    private String pluginId;
    private ContainerHelper helper = new ContainerHelper((WsComponentImpl)this);

    protected WsContainer(String string) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init> plugin=" + string);
        }
        this.pluginId = string;
    }

    public void destroy() {
        this.destroyComponents();
    }

    protected void destroyComponents() {
        this.helper.destroyComponents(this.components, this.applicationComponents);
    }

    public void initialize(Object object) throws ComponentDisabledException, ConfigurationWarning, ConfigurationError {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize", new Object[]{object, this});
            }
            try {
                this.loadComponents(this.pluginId);
                if (object instanceof ContainerConfig) {
                    ContainerConfig containerConfig = (ContainerConfig)object;
                    EObject eObject = null;
                    try {
                        eObject = (EObject)containerConfig.getConfig();
                    }
                    catch (ClassCastException classCastException) {
                        Manager.Ffdc.log((Throwable)classCastException, (Object)this, WsComponentImpl.class.getName(), "141");
                    }
                    this.initializeComponents(eObject, containerConfig.getLocators());
                    break block13;
                }
                if (object instanceof com.ibm.wsspi.runtime.config.ContainerConfig) {
                    com.ibm.wsspi.runtime.config.ContainerConfig containerConfig = (com.ibm.wsspi.runtime.config.ContainerConfig)object;
                    ConfigObject configObject = null;
                    try {
                        configObject = containerConfig.getConfig();
                    }
                    catch (ClassCastException classCastException) {
                        Manager.Ffdc.log((Throwable)classCastException, (Object)this, WsComponentImpl.class.getName(), "154");
                    }
                    this.initializeComponents(configObject, containerConfig.getLocators());
                    break block13;
                }
                this.initializeComponents(null, new ConfigLocator[0]);
            }
            catch (Exception exception) {
                if (exception instanceof ComponentDisabledException) {
                    throw (ComponentDisabledException)exception;
                }
                if (exception instanceof ConfigurationWarning) {
                    throw (ConfigurationWarning)exception;
                }
                if (exception instanceof ConfigurationError) {
                    throw (ConfigurationError)exception;
                }
                Manager.Ffdc.log((Throwable)exception, (Object)this, WsComponent.class.getName(), "127");
                throw new ConfigurationWarning(exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", (Object)this);
        }
    }

    public void start() throws RuntimeError, RuntimeWarning {
        this.startComponents();
        this.componentStartupData.clear();
    }

    protected void startComponents() throws RuntimeWarning, RuntimeError {
        this.helper.startComponents(this.components, this.componentStartupData);
    }

    public void stop() {
        this.stopComponents();
    }

    protected List loadComponents(String string) throws ConfigurationError {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadComponents", new Object[]{this, string});
        }
        List list = ComponentMetaDataMgr.instance().getComponentsByExtensionPoint(string, (WsComponent)this);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "loadedComponents " + list.size(), (Object)this);
            for (int i = 0; i < list.size(); ++i) {
                Tr.debug(tc, " component " + i, list.get(i));
            }
        }
        this.components = list;
        return this.components;
    }

    private ConfigLocatorAdapter[] createConfigLocatorAdapters(Object[] objectArray) {
        return this.helper.createConfigLocatorAdapters(objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeComponents(ConfigObject configObject, com.ibm.wsspi.runtime.config.ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        List list = Collections.synchronizedList(new ArrayList());
        try {
            this.helper.initializeComponents((Object)configObject, this.createConfigLocatorAdapters(configLocatorArray), this.components, list, this.componentStartupData);
        }
        finally {
            this.components = list;
        }
    }

    protected void initializeComponents(EObject eObject, ConfigLocator[] configLocatorArray) throws ConfigurationWarning, ConfigurationError {
        this.initializeComponents((Object)eObject, this.createConfigLocatorAdapters(configLocatorArray));
    }

    private void initializeComponents(Object object, ConfigLocatorAdapter[] configLocatorAdapterArray) throws ConfigurationWarning, ConfigurationError {
        List list = Collections.synchronizedList(new ArrayList());
        try {
            this.helper.initializeComponents(object, configLocatorAdapterArray, this.components, list, this.componentStartupData);
            this.components = list;
        }
        catch (ConfigurationWarning configurationWarning) {
            this.components = list;
            throw configurationWarning;
        }
    }

    protected void stopComponents() {
        this.helper.stopComponents(this.components, this.applicationComponents);
    }

    public boolean add(Object object) {
        if (this.children.contains(object)) {
            return false;
        }
        this.children.add(object);
        return true;
    }

    public boolean remove(Object object) {
        if (!this.children.contains(object)) {
            return false;
        }
        this.children.remove(object);
        return true;
    }

    public ContainerHelper getContainerHelper() {
        return this.helper;
    }

    public void addActivatedComponents(List<Object> list) {
        if (this.applicationComponents == Collections.EMPTY_LIST) {
            this.applicationComponents = new ArrayList<Object>(3);
        }
        this.helper.addActivatedComponents(list, this.applicationComponents);
    }
}

