/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rasdiag.diagnosticProviderRegistration;

import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.AttributeInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.ConfigInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.SelfDiagnosticInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.StateInfo;
import com.ibm.wsspi.rasdiag.diagnosticProviderRegistration.TestInfo;
import java.io.Serializable;

public class DiagnosticProviderInfo
implements Serializable {
    static final long serialVersionUID = -117808001541981078L;
    public String resourceBundleName = null;
    public ConfigInfo configInfo = null;
    public StateInfo stateInfo = null;
    public SelfDiagnosticInfo selfDiagnosticInfo = null;

    public DiagnosticProviderInfo() {
        this.init();
    }

    public DiagnosticProviderInfo(String string) {
        this.init();
        this.resourceBundleName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(this.resourceBundleName + "\n ConfigInfo: (id, regd, descKey): \n");
        if (this.configInfo != null && this.configInfo.attributeInfo != null) {
            stringBuffer.append(this.getAttrInfo(this.configInfo.attributeInfo));
        }
        stringBuffer.append("\n StateInfo: (id, regd, descKey): \n");
        if (this.stateInfo != null && this.stateInfo.attributeInfo != null) {
            stringBuffer.append(this.getAttrInfo(this.stateInfo.attributeInfo));
        }
        stringBuffer.append("\n SelfDiagnosticInfo: (id, descKey, attrs): \n");
        if (this.selfDiagnosticInfo != null && this.selfDiagnosticInfo.testInfo != null) {
            stringBuffer.append(this.getTestInfo(this.selfDiagnosticInfo.testInfo));
        }
        return stringBuffer.toString();
    }

    private StringBuffer getAttrInfo(AttributeInfo[] attributeInfoArray) {
        StringBuffer stringBuffer = new StringBuffer(512);
        for (int i = 0; i < attributeInfoArray.length; ++i) {
            stringBuffer.append(i + ". " + attributeInfoArray[i].id + " " + attributeInfoArray[i].registered + " " + attributeInfoArray[i].descriptionKey + "\n");
        }
        return stringBuffer;
    }

    private StringBuffer getTestInfo(TestInfo[] testInfoArray) {
        StringBuffer stringBuffer = new StringBuffer(512);
        for (int i = 0; i < testInfoArray.length; ++i) {
            stringBuffer.append(i + ". " + testInfoArray[i].id + " " + testInfoArray[i].descriptionKey + "\n");
            if (testInfoArray[i].attributeInfo == null) continue;
            stringBuffer.append(this.getAttrInfo(testInfoArray[i].attributeInfo));
        }
        return stringBuffer;
    }

    private void init() {
        this.configInfo = new ConfigInfo();
        this.stateInfo = new StateInfo();
        this.selfDiagnosticInfo = new SelfDiagnosticInfo();
    }
}

