/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rasdiag;

import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiagnosticTypedValue {
    private static final String sThisClass = DiagnosticTypedValue.class.getName();
    private static Logger sDiagnosticTypedValueLogger = DiagnosticEventHelper.getLogger((String)sThisClass, (String)"com.ibm.ws.rasdiag.resources.RasDiagMessages");
    public static final short TYPESHORT = 0;
    public static final short TYPEINT = 1;
    public static final short TYPEBOOLEAN = 2;
    public static final short TYPEDOUBLE = 3;
    public static final short TYPELONG = 4;
    public static final short TYPESTRING = 5;
    public static final short TYPEDATE = 6;
    public static final short TYPECOLLECTIONEL = 7;
    public static final short MAXTYPECONST = 7;
    public static final String[] sTypeNames = new String[]{"Short:", "Int:", "Boolean:", "Double:", "Long:", "String:", "Date:", "Element.Collection:"};
    public short tvType;
    public String tvString;
    public String tvMsgKey;

    public DiagnosticTypedValue() {
    }

    public DiagnosticTypedValue(short s, String string) {
        this.tvType = 0;
        this.tvString = Short.toString(s);
        this.tvMsgKey = string;
    }

    public DiagnosticTypedValue(int n, String string) {
        this.tvType = 1;
        this.tvString = Integer.toString(n);
        this.tvMsgKey = string;
    }

    public DiagnosticTypedValue(boolean bl, String string) {
        this.tvType = (short)2;
        this.tvString = Boolean.toString(bl);
        this.tvMsgKey = string;
    }

    public DiagnosticTypedValue(double d, String string) {
        this.tvType = (short)3;
        this.tvString = Double.toString(d);
        this.tvMsgKey = string;
    }

    public DiagnosticTypedValue(long l, String string) {
        this.tvType = (short)4;
        this.tvString = Long.toString(l);
        this.tvMsgKey = string;
    }

    public DiagnosticTypedValue(String string, String string2) {
        this.tvType = (short)5;
        this.tvString = string == null ? "Null" : string;
        this.tvMsgKey = string2;
    }

    public DiagnosticTypedValue(Date date, String string) {
        this.tvType = (short)6;
        this.tvString = date == null ? "Null" : date.toString();
        this.tvMsgKey = string;
    }

    private DiagnosticTypedValue(Object object, short s, String string) {
        this.tvType = s;
        this.tvString = object == null ? "Null" : object.toString();
        this.tvMsgKey = string;
    }

    public String toString() {
        if (this.tvType >= sTypeNames.length || this.tvType < 0) {
            sDiagnosticTypedValueLogger.logp(Level.WARNING, sThisClass, "toString", "RasDiag.All.InvalidParm", new String(Short.toString(this.tvType)));
            return null;
        }
        return sTypeNames[this.tvType] + this.tvMsgKey + ":" + this.tvString;
    }

    public static DiagnosticTypedValue fromString(String string) {
        if (string == null) {
            sDiagnosticTypedValueLogger.logp(Level.WARNING, sThisClass, "fromString", "RasDiag.All.NullParm", string);
            return null;
        }
        int n = string.indexOf(58);
        if (n < 3 || n == string.length() - 1) {
            sDiagnosticTypedValueLogger.logp(Level.WARNING, sThisClass, "fromString", "RasDiag.All.InvalidParm", string);
            return null;
        }
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        n = string3.indexOf(58);
        DiagnosticTypedValue diagnosticTypedValue = new DiagnosticTypedValue();
        for (int i = 0; i < sTypeNames.length; ++i) {
            if (!string2.equals(sTypeNames[i])) continue;
            diagnosticTypedValue.tvType = (short)i;
            diagnosticTypedValue.tvMsgKey = string3.substring(0, n);
            diagnosticTypedValue.tvString = string3.substring(n + 1);
            return diagnosticTypedValue;
        }
        sDiagnosticTypedValueLogger.logp(Level.WARNING, sThisClass, "fromString", "RasDiag.All.InvalidParm", string);
        return null;
    }

    public static void addCollectionToHashMap(HashMap hashMap, String string, Collection collection, String string2) {
        DiagnosticTypedValue.addCollectionToHashMap(hashMap, string, collection, string2, (short)5);
    }

    public static void addCollectionToHashMap(HashMap hashMap, String string, Collection collection, String string2, short s) {
        if (hashMap == null || string == null || collection == null || string2 == null) {
            sDiagnosticTypedValueLogger.logp(Level.WARNING, sThisClass, "addCollectionToHashMap", "RasDiag.All.NullParm");
            return;
        }
        if (s > 7) {
            s = (short)5;
        }
        Iterator iterator = collection.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            hashMap.put(string + "-" + n++, new DiagnosticTypedValue(iterator.next(), s, string2));
        }
    }

    public static void addHashMap(HashMap hashMap, HashMap hashMap2, String string) {
        hashMap.put(string, hashMap2);
    }
}

