/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rasdiag;

import com.ibm.ws.rasdiag.DiagnosticEventHelper;
import com.ibm.wsspi.rasdiag.DiagnosticConfig;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DiagnosticConfigHome {
    private static Hashtable sDiagnosticConfigCache = new Hashtable(256);
    private static String sCollectionSpecString = null;
    private static Pattern[] newSpecDPs = null;
    private static String[] newSpecLocIds = null;
    private static boolean[] newSpecBools = null;
    private static final String sThisClass = DiagnosticConfigHome.class.getName();
    private static Logger sDiagnosticConfigHomeLogger = DiagnosticEventHelper.getLogger((String)sThisClass, (String)"com.ibm.ws.rasdiag.resources.RasDiagMessages");
    private static DiagnosticConfigHome sDiagnosticConfigHome = new DiagnosticConfigHome();

    private DiagnosticConfigHome() {
        sDiagnosticConfigHomeLogger.logp(Level.FINE, sThisClass, "DiagnosticConfigHome", "Constructing");
    }

    public static DiagnosticConfigHome getInstance() {
        return sDiagnosticConfigHome;
    }

    public String getStateCollectionSpec() {
        return sCollectionSpecString;
    }

    public void setStateCollectionSpec(String string) {
        if (string == null) {
            sDiagnosticConfigHomeLogger.logp(Level.WARNING, sThisClass, "setStateCollectionSpec", "RasDiag.DCH.nullSpecParm");
            return;
        }
        String string2 = sCollectionSpecString == null ? "Uninitialized Value" : sCollectionSpecString;
        sDiagnosticConfigHomeLogger.logp(Level.INFO, sThisClass, "setStateCollectionSpec", "RasDiag.DCH.setTraceSpec", new Object[]{string2, string});
        sCollectionSpecString = string;
        this.consumeNewSpec(string);
        String[] stringArray = this.findImpactedDPs();
        for (int i = 0; i < stringArray.length; ++i) {
            this.retrieveDPSpec(stringArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticConfig getDiagnosticConfig(String string) {
        if (string == null) {
            sDiagnosticConfigHomeLogger.logp(Level.WARNING, sThisClass, "getDiagnosticConfig", "RasDiag.DCH.NullDPName");
            return null;
        }
        sDiagnosticConfigHomeLogger.logp(Level.FINEST, sThisClass, "getDiagnosticConfig", "get for DPName: " + string);
        DiagnosticConfig diagnosticConfig = null;
        Hashtable hashtable = sDiagnosticConfigCache;
        synchronized (hashtable) {
            diagnosticConfig = (DiagnosticConfig)sDiagnosticConfigCache.get(string);
            if (diagnosticConfig == null) {
                if (sDiagnosticConfigHomeLogger.isLoggable(Level.FINEST)) {
                    sDiagnosticConfigHomeLogger.logp(Level.FINEST, sThisClass, "getDiagnoticConfig", "No DiagnosticConfig object for DPName " + string + " creating it and new sz is: " + sDiagnosticConfigCache.size());
                }
                diagnosticConfig = this.retrieveDPSpec(string);
                sDiagnosticConfigCache.put(string, diagnosticConfig);
            }
        }
        return diagnosticConfig;
    }

    public static void releaseDiagnosticConfig(String string) {
        if (string == null) {
            sDiagnosticConfigHomeLogger.logp(Level.WARNING, sThisClass, "getDiagnosticConfig", "RasDiag.DCH.NullDPName");
            return;
        }
        if (sDiagnosticConfigHomeLogger.isLoggable(Level.FINEST)) {
            sDiagnosticConfigHomeLogger.logp(Level.FINEST, sThisClass, "getDiagnosticConfig", "release for DPName: " + string + " PreHashSz: " + sDiagnosticConfigCache.size() + " And is it there?: " + sDiagnosticConfigCache.containsKey(string));
        }
        sDiagnosticConfigCache.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] findImpactedDPs() {
        String[] stringArray = new String[sDiagnosticConfigCache.size()];
        boolean[] blArray = new boolean[stringArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Hashtable hashtable = sDiagnosticConfigCache;
        synchronized (hashtable) {
            Enumeration enumeration = sDiagnosticConfigCache.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n4;
            for (n4 = 0; n4 < newSpecBools.length && !blArray[i]; ++n4) {
                if (!newSpecDPs[n4].matcher(stringArray[i]).matches()) continue;
                blArray[i] = true;
            }
            for (n4 = 0; n4 < newSpecBools.length && !blArray[i]; ++n4) {
                if (!newSpecDPs[n4].matcher(stringArray[i]).matches()) continue;
                blArray[i] = true;
            }
            if (!blArray[i]) continue;
            ++n2;
        }
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i]) continue;
            stringArray2[n3++] = stringArray[i];
        }
        return stringArray2;
    }

    private DiagnosticConfig retrieveDPSpec(String string) {
        String[] stringArray = null;
        boolean[] blArray = null;
        if (newSpecBools == null) {
            stringArray = new String[]{};
            blArray = new boolean[]{};
        } else {
            int n;
            int n2 = 0;
            int[] nArray = new int[newSpecBools.length];
            for (n = 0; n < newSpecBools.length; ++n) {
                if (!newSpecDPs[n].matcher(string).matches()) continue;
                nArray[n2++] = n;
            }
            stringArray = new String[n2];
            blArray = new boolean[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = newSpecLocIds[nArray[n]];
                blArray[n] = newSpecBools[nArray[n]];
            }
        }
        DiagnosticConfig diagnosticConfig = (DiagnosticConfig)sDiagnosticConfigCache.get(string);
        if (diagnosticConfig == null) {
            sDiagnosticConfigHomeLogger.logp(Level.FINEST, sThisClass, "retrieveDPSpec", "No DiagnosticConfig object for DPName " + string + ",  creating it for request");
            diagnosticConfig = new DiagnosticConfig(string, stringArray, blArray);
        } else {
            diagnosticConfig.setStateCollectionSpec(stringArray, blArray);
        }
        return diagnosticConfig;
    }

    private void consumeNewSpec(String string) {
        int n;
        int n2;
        String[] stringArray = string.split(";");
        int n3 = 0;
        int n4 = stringArray.length;
        Pattern[] patternArray = new Pattern[n4];
        String[] stringArray2 = new String[n4];
        boolean[] blArray = new boolean[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            n = stringArray[n2].indexOf(58);
            int n5 = stringArray[n2].indexOf(61, n);
            if (n < 1 || n > n5 - 2 || n5 < 4 || n5 > stringArray[n2].length() - 2) {
                sDiagnosticConfigHomeLogger.logp(Level.WARNING, sThisClass, "consumeNewSpec", "RasDiag.DC.InvSpec", stringArray[n2]);
                ++n3;
                stringArray2[n2] = null;
                continue;
            }
            patternArray[n2] = Pattern.compile(stringArray[n2].substring(0, n));
            stringArray2[n2] = stringArray[n2].substring(n + 1, n5);
            blArray[n2] = stringArray[n2].charAt(n5 + 1) == '1';
        }
        if (n3 == 0) {
            newSpecDPs = patternArray;
            newSpecLocIds = stringArray2;
            newSpecBools = blArray;
        } else {
            newSpecDPs = new Pattern[n4 - n3];
            newSpecLocIds = new String[n4 - n3];
            newSpecBools = new boolean[n4 - n3];
            n2 = 0;
            for (n = 0; n < n4; ++n) {
                if (stringArray2[n] == null) continue;
                DiagnosticConfigHome.newSpecDPs[n2] = patternArray[n];
                DiagnosticConfigHome.newSpecLocIds[n2] = stringArray2[n];
                DiagnosticConfigHome.newSpecBools[n2++] = blArray[n];
            }
        }
    }
}

