/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.profile;

import com.ibm.ws.install.configmanager.logging.LogUtils;
import com.ibm.ws.install.configmanager.logging.LoggerContext;
import com.ibm.ws.install.configmanager.logging.LoggerFactory;
import com.ibm.ws.install.configmanager.utils.CurrentEnvironment;
import com.ibm.ws.profile.WSProfileConstants;
import com.ibm.ws.profile.cli.WSProfileCLIModeInvoker;
import com.ibm.ws.profile.cli.output.OutputStreamHandler;
import com.ibm.ws.profile.datastore.WSProfileDataStore;
import com.ibm.ws.profile.processing.preprocessing.CompleteDefaultingPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.CompleteValidationPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.EarlyDefaultingPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.ExecuteModeHelpPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.IsDefaultValidationPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.LogReInitializerPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.RemoteEnvironmentPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.ResponseFilePreProcessingTask;
import com.ibm.ws.profile.processing.preprocessing.SetCurrentModeInvokerPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.StrictCommandLineValidationPreProcessor;
import com.ibm.ws.profile.processing.preprocessing.TemplatePathDefaultingPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.TemplatePathValidationPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.ValidateAndBuildTemplateStackPreProcessorTask;
import com.ibm.ws.profile.processing.preprocessing.WSProfileJobGeneratorPreProcessorTask;
import com.ibm.ws.profile.remote.RemoteWSProfileCLI;
import com.ibm.ws.profile.utils.WSProfileUtils;
import com.ibm.wsspi.profile.WSProfile;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSProfileCLI {
    private static final int N_KEY_JOB_INDEX = 0;
    private static Logger LOGGER = LoggerFactory.createLogger(WSProfileCLI.class);
    private static String S_CLASS_NAME = WSProfileCLI.class.getName();
    private static Class[] CA_ORDERED_PREPROCESSOR_LIST = new Class[]{ResponseFilePreProcessingTask.class, RemoteEnvironmentPreProcessorTask.class, SetCurrentModeInvokerPreProcessorTask.class, TemplatePathDefaultingPreProcessorTask.class, TemplatePathValidationPreProcessorTask.class, IsDefaultValidationPreProcessorTask.class, ExecuteModeHelpPreProcessorTask.class, ValidateAndBuildTemplateStackPreProcessorTask.class, EarlyDefaultingPreProcessorTask.class, LogReInitializerPreProcessorTask.class, CompleteDefaultingPreProcessorTask.class, CompleteValidationPreProcessorTask.class, WSProfileJobGeneratorPreProcessorTask.class, StrictCommandLineValidationPreProcessor.class};
    private static LoggerContext m_lcSwitcher;

    public static void main(String[] args) {
        WSProfileUtils.initLogger(args);
        LOGGER.entering(WSProfile.class.getName(), "main");
        int nReturnCode = WSProfileCLI.invokeWSProfile(args);
        LOGGER.exiting(WSProfile.class.getName(), "main");
        System.exit(nReturnCode);
    }

    public static int mainForInProcessCalls(String[] args) {
        m_lcSwitcher = new LoggerContext();
        m_lcSwitcher.saveAndSwitchCurrentContext();
        WSProfileUtils.initLogger(args);
        LOGGER.entering(WSProfile.class.getName(), "mainForInProcessCalls");
        OutputStreamHandler.init();
        int nReturnCode = WSProfileCLI.invokeWSProfile(args);
        LOGGER.exiting(WSProfile.class.getName(), "mainForInProcessCalls");
        m_lcSwitcher.restoreSavedContext();
        return nReturnCode;
    }

    public static Hashtable getOutput() {
        LOGGER.entering(WSProfile.class.getName(), "getOutput");
        LOGGER.exiting(WSProfile.class.getName(), "getOutput");
        return OutputStreamHandler.getOutput();
    }

    public static String getMode(String[] asRealArgs) {
        LOGGER.entering(WSProfile.class.getName(), "getMode");
        if (WSProfileCLIModeInvoker.isTheUserRequestingHelp(asRealArgs)) {
            LOGGER.exiting(WSProfile.class.getName(), "getMode");
            return "help";
        }
        LOGGER.exiting(WSProfile.class.getName(), "getMode");
        return WSProfileCLIModeInvoker.getModeInvoker(asRealArgs).getModeFlag();
    }

    private static int executePreProcessors() {
        LOGGER.entering(S_CLASS_NAME, "executePreProcessors");
        LOGGER.exiting(S_CLASS_NAME, "executePreProcessors");
        return WSProfileUtils.launchExecutionOfActions(CA_ORDERED_PREPROCESSOR_LIST);
    }

    private static void initializeDataStore(String[] saSpecifiedArgs) {
        LOGGER.entering(S_CLASS_NAME, "executePreProcessors");
        WSProfileDataStore.initialize();
        WSProfileDataStore.setCurrentLoggerContext(m_lcSwitcher);
        WSProfileDataStore.setIncomingArgs(saSpecifiedArgs);
        LOGGER.exiting(S_CLASS_NAME, "executePreProcessors");
    }

    private static int invokeWSProfile(String[] saSpecifiedArgs) {
        LOGGER.entering(S_CLASS_NAME, "invokeWSProfile");
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Incoming command line is: " + LogUtils.getArrayAsALoggableString(WSProfileUtils.hidePasswordArgs(saSpecifiedArgs)));
        WSProfileCLI.initializeDataStore(saSpecifiedArgs);
        int nPreProcessingResult = WSProfileCLI.executePreProcessors();
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Preproccessing finished with return code: " + nPreProcessingResult);
        if (CurrentEnvironment.isRemoteDisconnected() && !WSProfileDataStore.isHelpRequested() && nPreProcessingResult != 1) {
            return RemoteWSProfileCLI.invokeWSProfile(WSProfileDataStore.getIncomingArgsAsMap());
        }
        int tempReturn = nPreProcessingResult;
        if (nPreProcessingResult != 1 && !WSProfileDataStore.isHelpRequested()) {
            tempReturn = WSProfileUtils.executeAllJobs(WSProfileDataStore.getAllStoredJobs());
            if (WSProfileDataStore.getFlowControllingModeInvoker() != null && !WSProfileDataStore.isHelpRequested()) {
                if (WSProfileDataStore.getJobGroup(0) == null) {
                    WSProfileDataStore.getFlowControllingModeInvoker().printOutExecutionResult(tempReturn, WSProfileDataStore.getFlowControllingArgsAsMap());
                } else {
                    WSProfileDataStore.getFlowControllingModeInvoker().printOutExecutionResult(tempReturn, WSProfileDataStore.getJobGroup(0).getCurrentArgsAsMap());
                }
            }
        }
        if (nPreProcessingResult == 1 && !WSProfileDataStore.isHelpRequested() && WSProfileDataStore.didValidationPass() && WSProfileDataStore.getFlowControllingModeInvoker() != null) {
            WSProfileDataStore.getFlowControllingModeInvoker().printOutExecutionResult(1, new Hashtable<String, List>());
        }
        nPreProcessingResult = WSProfileUtils.getOutcome(nPreProcessingResult, tempReturn);
        LOGGER.logp(Level.INFO, S_CLASS_NAME, "invokeWSProfile", "Returning with return code: " + WSProfileConstants.AS_RETURN_CODES[nPreProcessingResult]);
        LOGGER.exiting(S_CLASS_NAME, "invokeWSProfile");
        return nPreProcessingResult;
    }
}

