/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer.util;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.ws.portletcontainer.portletserving.core.PortletControlParameter;
import com.ibm.ws.portletcontainer.portletserving.util.URLTokenizer;
import com.ibm.wsspi.portletcontainer.InvalidURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletURLHelper {
    private static final String CLASS_NAME = PortletURLHelper.class.getName();
    private static Logger logger = Logger.getLogger(CLASS_NAME, "com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private static NLS nls = new NLS("com.ibm.ws.portletcontainer.portletserving.resources.Messages");
    private String context;
    private String portletName;
    private String portletWindowId;
    private String version;
    private boolean action;
    private String portletMode;
    private String windowState;
    private Map<String, String[]> rParams = new HashMap<String, String[]>();
    private boolean serveResource;
    private String resourceId;
    private String cacheLevel;
    public static final String URL_TARGET_WINDOWID = "com.ibm.wsspi.portlet.url.target.wid";
    public static final String URL_PREFIX = "com.ibm.wsspi.portlet.url.prefix";
    public static final String URL_SUFFIX = "com.ibm.wsspi.portlet.url.suffix";
    public static final String URL_QUERYPARAMS = "com.ibm.wsspi.portlet.url.queryparams";

    public PortletURLHelper(String url) throws InvalidURLException {
        this.analyzeURL(url);
    }

    public PortletURLHelper(String context, String portletName, String pathInfo) throws InvalidURLException {
        this.context = context;
        this.portletName = portletName;
        this.analyzePathInfo(pathInfo);
    }

    public String getContext() {
        return this.context;
    }

    public String getPortletName() {
        return this.portletName;
    }

    public String getPortletWindowId() {
        return this.portletWindowId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAction() {
        return this.action;
    }

    public boolean isRender() {
        return !this.action && !this.serveResource;
    }

    public String getId() {
        return this.resourceId;
    }

    public String getCacheability() {
        return this.cacheLevel;
    }

    public boolean isServeResource() {
        return this.serveResource;
    }

    public String getPortletMode() {
        return this.portletMode;
    }

    public String getWindowState() {
        return this.windowState;
    }

    public Map<String, String[]> getRenderParameters() {
        return this.rParams;
    }

    public static PortletMode getPortletMode(String mode) {
        if (mode == null) {
            return null;
        }
        if (PortletMode.VIEW.toString().equals(mode)) {
            return PortletMode.VIEW;
        }
        if (PortletMode.EDIT.toString().equals(mode)) {
            return PortletMode.EDIT;
        }
        if (PortletMode.HELP.toString().equals(mode)) {
            return PortletMode.HELP;
        }
        return new PortletMode(mode);
    }

    public static WindowState getWindowState(String state) {
        if (state == null) {
            return null;
        }
        if (WindowState.NORMAL.toString().equals(state)) {
            return WindowState.NORMAL;
        }
        if (WindowState.MAXIMIZED.toString().equals(state)) {
            return WindowState.MAXIMIZED;
        }
        if (WindowState.MINIMIZED.toString().equals(state)) {
            return WindowState.MINIMIZED;
        }
        return new WindowState(state);
    }

    private void analyzePathInfo(String pathInfo) throws InvalidURLException {
        logger.entering(CLASS_NAME, "analyzePathInfo", pathInfo);
        boolean isLoggingFINEST = logger.isLoggable(Level.FINEST);
        if (pathInfo == null) {
            pathInfo = "";
        }
        URLTokenizer tokenizer = new URLTokenizer(pathInfo, "/");
        this.analyzePathInfo(tokenizer, isLoggingFINEST);
        logger.exiting(CLASS_NAME, "analyzePathInfo");
    }

    private void analyzeURL(String url) throws InvalidURLException {
        logger.entering(CLASS_NAME, "analyzeURL", url);
        boolean isLoggingFINEST = logger.isLoggable(Level.FINEST);
        URLTokenizer tokenizer = new URLTokenizer(url, "/");
        this.context = tokenizer.nextToken();
        if (isLoggingFINEST) {
            logger.logp(Level.FINEST, CLASS_NAME, "analyzeURL", "context: " + this.context);
        }
        this.verifyParameterValue(this.context);
        this.portletName = tokenizer.nextToken();
        if (isLoggingFINEST) {
            logger.logp(Level.FINEST, CLASS_NAME, "analyzeURL", "portletName: " + this.portletName);
        }
        this.verifyParameterValue(this.portletName);
        this.analyzePathInfo(tokenizer, isLoggingFINEST);
        logger.exiting(CLASS_NAME, "analyzeURL");
    }

    private void analyzePathInfo(URLTokenizer tokenizer, boolean isLoggingFINEST) throws InvalidURLException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "analyzePathInfo", tokenizer);
        }
        this.version = "1.0";
        if (tokenizer.hasMoreTokens()) {
            String token;
            this.portletWindowId = tokenizer.nextToken();
            if (isLoggingFINEST) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzePathInfo", "PortletWindowId: " + this.portletWindowId);
            }
            this.verifyParameterValue(this.portletWindowId);
            String string = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
            if (PortletControlParameter.isVersionParam((String)token)) {
                String[] nameValue = this.analyzePortletStateToken(token, isLoggingFINEST);
                this.version = nameValue[1];
                if (isLoggingFINEST) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzePathInfo", "Version: " + this.version);
                }
                if (!"1.0".equalsIgnoreCase(this.version) && !"2.0".equalsIgnoreCase(this.version)) {
                    throw new InvalidURLException(this.getInvalidURLMessage());
                }
                token = this.analyzePortletState(tokenizer, isLoggingFINEST);
            }
            if (!"".equals(token)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "analyzePathInfo", "Last unanalyzed token:" + token);
                }
                throw new InvalidURLException(this.getInvalidURLMessage());
            }
        } else {
            this.portletWindowId = "default";
        }
        logger.exiting(CLASS_NAME, "analyzePathInfo");
    }

    private String analyzePortletState(URLTokenizer tokenizer, boolean isLoggingFINEST) throws InvalidURLException {
        String[] nameValue;
        String token;
        String string = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
        if (PortletControlParameter.isServeResourceParam((String)token)) {
            String[] id_name_value;
            if (isLoggingFINEST) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "Recognized serveResource.");
            }
            if (!"2.0".equalsIgnoreCase(this.version)) {
                throw new InvalidURLException(this.getInvalidURLMessage());
            }
            this.serveResource = true;
            String string2 = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
            if (PortletControlParameter.isResourceIdParam((String)token)) {
                if (isLoggingFINEST) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "Recognized resourceId " + token);
                }
                id_name_value = this.analyzePortletStateToken(token, isLoggingFINEST);
                this.resourceId = PortletControlParameter.decodeValue((String)id_name_value[1]);
                String string3 = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
            }
            if (PortletControlParameter.isCacheabilityParam((String)token)) {
                if (isLoggingFINEST) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "Recognized cacheability " + token);
                }
                id_name_value = this.analyzePortletStateToken(token, isLoggingFINEST);
                this.cacheLevel = PortletControlParameter.decodeValue((String)id_name_value[1]);
                String string4 = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
            }
        }
        if (PortletControlParameter.isActionParam((String)token)) {
            if (isLoggingFINEST) {
                logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "Recognized Action.");
            }
            this.action = true;
            String string5 = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
        }
        if (PortletControlParameter.isPortletModeParam((String)token)) {
            nameValue = this.analyzePortletStateToken(token, isLoggingFINEST);
            this.portletMode = nameValue[1];
            String string6 = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
        }
        if (PortletControlParameter.isWindowStateParam((String)token)) {
            nameValue = this.analyzePortletStateToken(token, isLoggingFINEST);
            this.windowState = nameValue[1];
            String string7 = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
        }
        if (PortletControlParameter.isRenderParam((String)token)) {
            boolean isMoreParameters = true;
            while (isMoreParameters) {
                StringTokenizer tokenizer2 = new StringTokenizer(token, "=");
                String rparam = tokenizer2.nextToken();
                if (!PortletControlParameter.isStateControlParamName((String)rparam)) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "analyzePortletState", "Last unanalyzed token:" + rparam);
                    }
                    throw new InvalidURLException(this.getInvalidURLMessage());
                }
                if (!tokenizer2.hasMoreTokens()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "analyzePortletState", "Render parameters must at least have a name.");
                    }
                    throw new InvalidURLException(this.getInvalidURLMessage());
                }
                String name = PortletControlParameter.decodeParameterName((String)tokenizer2.nextToken());
                this.verifyParameterValue(name);
                String[] values = null;
                if (tokenizer2.hasMoreTokens()) {
                    values = new String[tokenizer2.countTokens()];
                    int i = 0;
                    while (tokenizer2.hasMoreTokens()) {
                        String value = tokenizer2.nextToken();
                        this.verifyParameterValue(value);
                        values[i] = PortletControlParameter.decodeValue((String)value);
                        ++i;
                    }
                }
                if (isLoggingFINEST) {
                    logger.logp(Level.FINEST, CLASS_NAME, "analyzePortletState", "RParam Name: " + name + " - Values: " + values);
                }
                this.rParams.put(name, values);
                token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
                if (PortletControlParameter.isRenderParam((String)token)) continue;
                isMoreParameters = false;
            }
        }
        return token;
    }

    private String[] analyzePortletStateToken(String token, boolean isLoggingFINEST) throws InvalidURLException {
        String[] ret;
        logger.entering(CLASS_NAME, "analyzeControlParameterToken", token);
        StringTokenizer tokenizer2 = new StringTokenizer(token, "=");
        if (tokenizer2.countTokens() != 2) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "analyzeControlParameterToken", "Control parameter token must have name and value:" + token);
            }
            throw new InvalidURLException(this.getInvalidURLMessage());
        }
        ret = new String[]{PortletControlParameter.decodeParameterName((String)tokenizer2.nextToken()), PortletControlParameter.decodeParameterValue((String)ret[0], (String)tokenizer2.nextToken())};
        if (isLoggingFINEST) {
            logger.logp(Level.FINEST, CLASS_NAME, "analyzeControlParameterToken", "Name: " + ret[0] + " - Value: " + ret[1]);
        }
        this.verifyParameterValue(ret[1]);
        logger.exiting(CLASS_NAME, "analyzeControlParameterToken", ret);
        return ret;
    }

    private void verifyParameterValue(String value) throws InvalidURLException {
        if ("".equals(value)) {
            throw new InvalidURLException(this.getInvalidURLMessage());
        }
    }

    private String getInvalidURLMessage() {
        return nls.getString("portletserving.invalid.url.error.0", "An InvalidURLException occurred. The provided portlet url is invalid.");
    }

    public static String encodeParameter(String value) {
        return PortletControlParameter.encodeValue((String)value);
    }
}

