/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer.util;

import com.ibm.ws.portletcontainer.core.InternalPortletEvent;
import com.ibm.ws.portletcontainer.core.impl.EventImpl;
import com.ibm.ws.portletcontainer.om.OMAccess;
import com.ibm.ws.portletcontainer.om.portlet.EventDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletApplicationDefinition;
import com.ibm.ws.portletcontainer.om.portlet.PortletDefinition;
import com.ibm.ws.portletcontainer.om.window.PortletWindow;
import com.ibm.ws.portletcontainer.util.JavaObjectInputStream;
import com.ibm.wsspi.portletcontainer.InvalidPortletWindowIdentifierException;
import com.ibm.wsspi.portletcontainer.PortletWindowIdentifier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.portlet.Event;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class EventFactory {
    private EventFactory() {
    }

    public static Event createEvent(QName name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException("The event name must not be null");
        }
        EventImpl event2 = new EventImpl(name, value);
        event2.setSerializeType(0);
        return (Event)event2;
    }

    public static Event createJAVASerializedEvent(QName name, byte[] value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("The event name or value must not be null");
        }
        EventImpl event2 = new EventImpl(name, (Serializable)value);
        event2.setSerializeType(2);
        return (Event)event2;
    }

    public static Event createJAXBSerializedEvent(QName name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("The event name or  value must not be null");
        }
        EventImpl event2 = new EventImpl(name, (Serializable)((Object)value));
        event2.setSerializeType(1);
        return (Event)event2;
    }

    public static Event serializeJava(Event event2) throws IOException {
        if (event2.getValue() instanceof Serializable && event2 instanceof InternalPortletEvent) {
            InternalPortletEvent ipe = (InternalPortletEvent)event2;
            if (ipe.getSerializeType() == 0) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream ous = new ObjectOutputStream(baos);
                ous.writeObject(event2.getValue());
                baos.close();
                byte[] return_value = baos.toByteArray();
                baos.close();
                ipe.setValue((Serializable)return_value);
                ipe.setSerializeType(2);
                return event2;
            }
            return event2;
        }
        throw new IllegalArgumentException("The event value must not be null");
    }

    public static Event serializeJAXB(Event event2) throws JAXBException, IOException {
        if (event2.getValue() instanceof Serializable && event2 instanceof InternalPortletEvent) {
            InternalPortletEvent ipe = (InternalPortletEvent)event2;
            if (ipe.getSerializeType() == 0) {
                ipe.setValue((Serializable)((Object)EventFactory.serializeJAXB(event2.getQName(), event2.getValue())));
                ipe.setSerializeType(1);
                return event2;
            }
            return event2;
        }
        throw new IllegalArgumentException("The event value must not be null");
    }

    public static Event deserializeJava(ClassLoader classLoader, Event event2) throws IOException, ClassNotFoundException {
        if (event2 instanceof InternalPortletEvent && event2.getValue() != null) {
            InternalPortletEvent ipe = (InternalPortletEvent)event2;
            if (ipe.getSerializeType() == 2) {
                ByteArrayInputStream bais = new ByteArrayInputStream((byte[])event2.getValue());
                JavaObjectInputStream ois = new JavaObjectInputStream(classLoader, (InputStream)bais);
                Object o = ois.readObject();
                ois.close();
                bais.close();
                ipe.setValue((Serializable)o);
                ipe.setSerializeType(0);
                return event2;
            }
            throw new IllegalArgumentException("The event is not serialized with Java serialization");
        }
        throw new IllegalArgumentException("The event or the eventvalue is null");
    }

    public static Event deserializeJAXB(ClassLoader classLoader, Event event2, PortletWindowIdentifier windowId) throws JAXBException, IOException, InvalidPortletWindowIdentifierException, ClassNotFoundException {
        if (event2 instanceof InternalPortletEvent) {
            InternalPortletEvent pe = (InternalPortletEvent)event2;
            if (pe.getSerializeType() == 1) {
                String eventclass = EventFactory.getEventClass(event2, windowId);
                if (eventclass == null) {
                    throw new IllegalArgumentException("unable to deserialize event, because no event value type has been defined for event " + event2.getQName() + " in portlet " + windowId.getPortletName());
                }
                Object value = EventFactory.deSerializeJAXB(classLoader, (String)((Object)event2.getValue()), eventclass);
                pe.setSerializeType(0);
                pe.setValue((Serializable)value);
                return event2;
            }
            throw new IllegalArgumentException("The eventvalue is not JAXB serialized");
        }
        throw new IllegalArgumentException("The eventvalue must not be null");
    }

    public static Event deserializeJAXB(ClassLoader classLoader, Event event2, String valueType) throws JAXBException, IOException, InvalidPortletWindowIdentifierException, ClassNotFoundException {
        if (event2 instanceof InternalPortletEvent) {
            InternalPortletEvent pe = (InternalPortletEvent)event2;
            if (pe.getSerializeType() == 1) {
                Object value = EventFactory.deSerializeJAXB(classLoader, (String)((Object)event2.getValue()), valueType);
                pe.setSerializeType(0);
                pe.setValue((Serializable)value);
                return event2;
            }
            throw new IllegalArgumentException("The eventvalue is not JAXB serialized");
        }
        throw new IllegalArgumentException("The eventvalue must not be null");
    }

    private static String serializeJAXB(QName eventName, Object value) throws JAXBException, IOException {
        String serialized_value = null;
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{value.getClass()});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBElement wrapperElement = new JAXBElement(eventName, value.getClass(), value);
        marshaller.marshal((Object)wrapperElement, (OutputStream)baos);
        serialized_value = new String(baos.toByteArray());
        baos.close();
        return serialized_value;
    }

    private static Object deSerializeJAXB(ClassLoader classLoader, String serialized_value, String value_type) throws JAXBException, IOException, ClassNotFoundException {
        Object value = null;
        Class<?> class_type = classLoader.loadClass(value_type);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{class_type});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        ByteArrayInputStream bais = new ByteArrayInputStream(serialized_value.getBytes());
        StreamSource source = new StreamSource(bais);
        JAXBElement jaxbElement = unmarshaller.unmarshal((Source)source, class_type);
        value = jaxbElement.getValue();
        bais.close();
        return value;
    }

    private static String getEventClass(Event event2, PortletWindowIdentifier windowId) throws InvalidPortletWindowIdentifierException {
        PortletWindow portletWindow = EventFactory.getPortletWindow(windowId);
        PortletDefinition portletDefinition = portletWindow.getPortletDefinition();
        PortletApplicationDefinition portletApplicationDefinition = portletDefinition.getPortletApplicationDefinition();
        Iterator eventDefinitions = portletApplicationDefinition.getEventDefinitions().iterator();
        String eventClass = null;
        while (eventDefinitions.hasNext()) {
            EventDefinition element = (EventDefinition)eventDefinitions.next();
            QName eventQName = element.getEventName();
            if (eventQName == null || !event2.getQName().equals(eventQName)) continue;
            return element.getJavaClass();
        }
        if (eventClass == null) {
            throw new RuntimeException("no Eventdefinition for event: " + event2.getQName() + " found in the portlet.xml of portlet: " + portletDefinition.getName());
        }
        return eventClass;
    }

    private static PortletWindow getPortletWindow(PortletWindowIdentifier portletIdentifier) throws InvalidPortletWindowIdentifierException {
        return OMAccess.createPortletWindow((PortletWindowIdentifier)portletIdentifier);
    }
}

