/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer.services.persistence;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.portletcontainer.services.persistence.Preference;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceAdapter;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSet;
import com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSetCtrl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreferenceSetAdapter
implements PreferenceSet,
PreferenceSetCtrl,
Cloneable {
    private Map namePrefMap;
    private PreferenceSet defaultPreferences;

    public PreferenceSetAdapter() {
        this(null);
    }

    public PreferenceSetAdapter(PreferenceSet defaultPreferences) {
        this.defaultPreferences = defaultPreferences;
        this.namePrefMap = new HashMap();
    }

    public Iterator iterator() {
        return Collections.unmodifiableCollection(this.namePrefMap.values()).iterator();
    }

    public Preference get(String name) {
        return (Preference)this.namePrefMap.get(name);
    }

    public Preference getDefault(String name) {
        if (this.defaultPreferences != null) {
            return this.defaultPreferences.get(name);
        }
        return null;
    }

    public PreferenceSetCtrl getController() {
        try {
            return (PreferenceSetCtrl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.wsspi.portletcontainer.services.persistence.PreferenceSetAdapter.getController", (String)"108", (Object)this);
            String className = this.getClass().getName();
            Logger.getLogger(className).logp(Level.SEVERE, className, "getController", "The PreferenceSetAdapter should be cloneable.");
            return null;
        }
    }

    public Iterator defaultIterator() {
        if (this.defaultPreferences == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.defaultPreferences.iterator();
    }

    public Preference set(String name, List values) {
        Preference previousPreference = (Preference)this.namePrefMap.get(name);
        PreferenceAdapter newPreference = previousPreference != null ? new PreferenceAdapter(name, values, previousPreference.isReadOnly()) : new PreferenceAdapter(name, values);
        this.namePrefMap.put(newPreference.getName(), newPreference);
        return newPreference;
    }

    public Preference remove(String name) {
        return (Preference)this.namePrefMap.remove(name);
    }

    public void add(String name, List values, boolean readOnly) {
        PreferenceAdapter preference = new PreferenceAdapter(name, values, readOnly);
        this.namePrefMap.put(preference.getName(), preference);
    }
}

