/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.portletcontainer.services.persistence;

import com.ibm.wsspi.portletcontainer.services.persistence.Preference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PreferenceAdapter
implements Preference {
    private String name;
    private ArrayList values;
    private List unmodifiableValues;
    private boolean readOnly;

    public PreferenceAdapter(String name) {
        this(name, null);
    }

    public PreferenceAdapter(String name, List values) {
        this(name, values, false);
    }

    public PreferenceAdapter(String name, List values, boolean readOnly) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid name");
        }
        this.name = name;
        this.values = values != null ? new ArrayList(values) : null;
        this.readOnly = readOnly;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List getValues() {
        if (this.values == null) {
            return null;
        }
        if (this.unmodifiableValues == null) {
            this.unmodifiableValues = Collections.unmodifiableList(this.values);
        }
        return this.unmodifiableValues;
    }

    public void setValues(List values) {
        if (values == null) {
            this.values = null;
            this.unmodifiableValues = null;
        } else {
            if (this.values == null) {
                this.values = new ArrayList(values.size());
                this.unmodifiableValues = null;
            } else {
                this.values.clear();
            }
            this.values.addAll(values);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

