/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;

public class JmsMessageListenerSupport {
    private static final Map _messageListenerSetters;
    private static final TraceNLS _nls;
    private static final TraceComponent tc;

    public static void setMessageListener(MessageConsumer consumer, MessageListener listener) throws JMSException {
        MessageListenerSetter setter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageListener", new Object[]{consumer, listener});
        }
        if ((setter = (MessageListenerSetter)_messageListenerSetters.get(consumer.getClass().getName())) == null) {
            String message = _nls.getFormattedMessage("UNKNOWN_SESSION_TYPE_WMSG0500E", new Object[]{consumer.getClass().getName()}, null);
            JMSException e = new JMSException(message);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "setMessageListener", e);
            }
            throw e;
        }
        setter.setMessageListener(consumer, listener);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageListener");
        }
    }

    static {
        tc = Tr.register(JmsMessageListenerSupport.class, "Messaging", "com.ibm.ejs.jms.messaging");
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<clinit>");
        }
        _nls = TraceNLS.getTraceNLS("com.ibm.ejs.jms.messaging");
        _messageListenerSetters = new HashMap();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        String epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".jmsMessageListenerSetters";
        IConfigurationElement[] setters = registry.getConfigurationElementsFor(epid);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "processing " + setters.length + " message listener setters");
        }
        for (int i = 0; i < setters.length; ++i) {
            try {
                String setterType = setters[i].getAttribute("type");
                Object setter = setters[i].createExecutableExtension("setter");
                _messageListenerSetters.put(setterType, setter);
                continue;
            }
            catch (CoreException ce) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "exception loading class", (Object)ce);
                }
                FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ejs.jms.JmsMessageListenerSupport.<clinit>", (String)"85");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<clinit>");
        }
    }

    public static interface MessageListenerSetter {
        public void setMessageListener(MessageConsumer var1, MessageListener var2) throws JMSException;
    }
}

