/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca.screenable;

import com.ibm.connector2.screen.IExtendedAttributes;
import com.ibm.connector2.screen.IFieldAttrInfo;
import com.ibm.connector2.screen.IFieldData;
import com.ibm.connector2.screen.IScreenInfo;
import com.ibm.connector2.screen.IScreenable;
import com.ibm.connector2.screen.ITextAttrInfo;
import com.ibm.connector2.screen.IndexOutOfBoundsException;
import com.ibm.connector2.screen.NameNotFoundException;
import com.ibm.connector2.screen.ScreenException;
import com.ibm.wsif.format.jca.Match;
import com.ibm.wsif.jca.screenable.FieldDataImpl;
import com.ibm.wsif.jca.screenable.FieldRecord;
import com.ibm.wsif.jca.screenable.IFieldRecord;
import com.ibm.wsif.jca.screenable.IScreenRecord;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.wsif.format.WSIFFormatHandler;
import org.apache.wsif.format.WSIFFormatPart;
import org.apache.wsif.logging.Trc;

public class WSIFFormatHandler_JCAScreenable
implements WSIFFormatHandler,
IExtendedAttributes,
IScreenable,
IScreenRecord,
Match,
Serializable {
    private static final String copyright = "(c) Copyright IBM Corporation 2001, 2002.";
    private static final long serialVersionUID = 5L;
    private boolean updateMode_;
    private HashMap fields_;
    private HashMap nameMap_;
    private String screenId_ = "";
    private int depth_ = 24;
    private int width_ = 80;
    protected int fieldIndex_ = 0;
    protected Object fieldDataBean;
    protected IScreenInfo scrInfo_;
    protected HashMap positionMap_ = new HashMap();

    public WSIFFormatHandler_JCAScreenable() {
        this.fields_ = new HashMap();
        this.nameMap_ = new HashMap();
    }

    void addField(FieldRecord fieldRecord, int n, int n2) {
        Integer n3 = new Integer(n);
        this.fields_.put(n3, fieldRecord);
        if (!this.nameMap_.containsKey(fieldRecord.getName())) {
            this.nameMap_.put(fieldRecord.getName(), n3);
        }
        Integer n4 = new Integer(n2);
        this.positionMap_.put(n4, fieldRecord);
    }

    public void beginBuild(IScreenInfo iScreenInfo, boolean bl) {
        if (bl) {
            this.depth_ = iScreenInfo.getDepth();
            this.width_ = iScreenInfo.getWidth();
            int n = iScreenInfo.getFieldCount();
            this.fields_.clear();
            this.nameMap_.clear();
            this.fieldIndex_ = 0;
            this.updateMode_ = false;
            this.scrInfo_ = iScreenInfo;
        } else {
            this.updateMode_ = true;
        }
    }

    public void buildField(IFieldData iFieldData, IFieldAttrInfo iFieldAttrInfo, ITextAttrInfo iTextAttrInfo) throws ScreenException {
        int n = iFieldData.getPos();
        if (!this.updateMode_) {
            ++this.fieldIndex_;
            FieldRecord fieldRecord = new FieldRecord(iFieldData.getName(), n, this.depth_, this.width_, iFieldData.getText(), iFieldData.getMaxLength(), iFieldAttrInfo, iTextAttrInfo);
            this.addField(fieldRecord, this.fieldIndex_, n);
        } else {
            Iterator iterator = this.getFields();
            while (iterator.hasNext()) {
                FieldRecord fieldRecord = (FieldRecord)iterator.next();
                if (fieldRecord.getStartPos() != n) continue;
                fieldRecord.setTextPriv(iFieldData.getText());
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        WSIFFormatHandler_JCAScreenable wSIFFormatHandler_JCAScreenable = (WSIFFormatHandler_JCAScreenable)super.clone();
        Iterator iterator = this.getFields();
        int n = 0;
        while (iterator.hasNext()) {
            FieldRecord fieldRecord = (FieldRecord)((FieldRecord)iterator.next()).clone();
            wSIFFormatHandler_JCAScreenable.addField(fieldRecord, n, fieldRecord.getStartPos());
            ++n;
        }
        return wSIFFormatHandler_JCAScreenable;
    }

    public void endBuild() {
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof WSIFFormatHandler_JCAScreenable)) {
            return false;
        }
        WSIFFormatHandler_JCAScreenable wSIFFormatHandler_JCAScreenable = (WSIFFormatHandler_JCAScreenable)object;
        if (this.fieldIndex_ != wSIFFormatHandler_JCAScreenable.fieldIndex_) {
            return false;
        }
        if (this.depth_ != wSIFFormatHandler_JCAScreenable.depth_) {
            return false;
        }
        if (this.width_ != wSIFFormatHandler_JCAScreenable.width_) {
            return false;
        }
        if (this.fields_ == null ^ wSIFFormatHandler_JCAScreenable.fields_ == null) {
            return false;
        }
        if (this.fields_ != null && !this.fields_.equals(wSIFFormatHandler_JCAScreenable.fields_)) {
            return false;
        }
        if (this.positionMap_ == null ^ wSIFFormatHandler_JCAScreenable.positionMap_ == null) {
            return false;
        }
        if (this.positionMap_ != null && !this.positionMap_.equals(wSIFFormatHandler_JCAScreenable.positionMap_)) {
            return false;
        }
        if (this.nameMap_ == null ^ wSIFFormatHandler_JCAScreenable.nameMap_ == null) {
            return false;
        }
        if (this.nameMap_ != null && !this.nameMap_.equals(wSIFFormatHandler_JCAScreenable.nameMap_)) {
            return false;
        }
        if (this.screenId_ == null ^ wSIFFormatHandler_JCAScreenable.screenId_ == null) {
            return false;
        }
        return this.screenId_ == null || this.screenId_.equals(wSIFFormatHandler_JCAScreenable.screenId_);
    }

    public IFieldRecord getField(int n) throws ScreenException {
        if (n - 1 > this.fields_.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (IFieldRecord)this.fields_.get(new Integer(n));
    }

    public IFieldRecord getFieldByPosition(int n) throws ScreenException {
        if (n > this.depth_ * this.width_ - 1) {
            throw new IndexOutOfBoundsException();
        }
        return (IFieldRecord)this.positionMap_.get(new Integer(n));
    }

    public String getFieldTextByPosition(int n) throws ScreenException {
        if (n > this.depth_ * this.width_ - 1) {
            throw new IndexOutOfBoundsException();
        }
        FieldRecord fieldRecord = (FieldRecord)this.positionMap_.get(new Integer(n));
        if (fieldRecord == null) {
            return "";
        }
        String string = fieldRecord.getText();
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public IFieldRecord getField(String string) throws ScreenException {
        Integer n = (Integer)this.nameMap_.get(string);
        if (n == null) {
            throw new NameNotFoundException("Field: " + string + "is not present");
        }
        return (IFieldRecord)this.fields_.get(n);
    }

    public int getFieldCount() {
        return this.fields_.size();
    }

    public Iterator getFields() {
        return new FieldIterator();
    }

    public Iterator getModifiedFields() {
        return new Iterator(){
            HashMap modifiedFields = new HashMap();
            int numberElements = 0;
            int numFields = WSIFFormatHandler_JCAScreenable.this.getFieldCount();
            int currentElement;
            {
                int n = 1;
                while (n <= this.numFields) {
                    FieldRecord fieldRecord = null;
                    try {
                        fieldRecord = (FieldRecord)WSIFFormatHandler_JCAScreenable.this.getField(n);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fieldRecord.isModified() && !fieldRecord.isProtected()) {
                        ++this.numberElements;
                        this.modifiedFields.put(new Integer(this.numberElements), fieldRecord);
                    }
                    ++n;
                }
                this.currentElement = 0;
            }

            public boolean hasNext() {
                return this.currentElement < this.numberElements;
            }

            public Object next() {
                ++this.currentElement;
                return this.modifiedFields.get(new Integer(this.currentElement));
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(string + "[WSIFFormatHandler_JCAScreenable" + string);
            int n = this.fields_.size();
            stringBuffer.append("Number of fields = " + n + string);
            stringBuffer.append("Depth = " + this.depth_ + string);
            stringBuffer.append("Width = " + this.width_ + string);
            int n2 = 1;
            while (n2 <= n) {
                FieldRecord fieldRecord = (FieldRecord)this.fields_.get(new Integer(n2));
                stringBuffer.append("  Field" + n2 + ":" + string);
                stringBuffer.append("    position: " + fieldRecord.getStartPos() + string);
                stringBuffer.append("    row: " + fieldRecord.getStartRow() + string);
                stringBuffer.append("    column: " + fieldRecord.getStartCol() + string);
                stringBuffer.append("    maximum text length: " + fieldRecord.getMaxTextLength() + string);
                stringBuffer.append("    text: \"" + fieldRecord.getText() + "\"" + string);
                stringBuffer.append("    text position: \"" + fieldRecord.getTextPos() + "\"" + string);
                stringBuffer.append("    text row: \"" + fieldRecord.getTextRow() + "\"" + string);
                stringBuffer.append("    text column: \"" + fieldRecord.getTextCol() + "\"" + string);
                stringBuffer.append("    transparency: " + fieldRecord.getTransparency() + string);
                stringBuffer.append("    backgroundcolour: " + fieldRecord.getBackGroundColor() + string);
                stringBuffer.append("    foregroundcolour: " + fieldRecord.getForeGroundColor() + string);
                stringBuffer.append("    highlight: " + fieldRecord.getHighlight() + string);
                stringBuffer.append("    isDisplay: " + fieldRecord.isDisplay() + string);
                stringBuffer.append("    isHighIntensity: " + fieldRecord.isHighIntensity() + string);
                stringBuffer.append("    isModified: " + fieldRecord.isModified() + string);
                stringBuffer.append("    isNumeric: " + fieldRecord.isNumeric() + string);
                stringBuffer.append("    isPenDetectable: " + fieldRecord.isPenDetectable() + string);
                stringBuffer.append("    isProtected: " + fieldRecord.isProtected() + string);
                ++n2;
            }
            stringBuffer.append("]" + string);
            return stringBuffer.toString();
        }
        catch (Throwable throwable) {
            return "null " + stringBuffer.toString();
        }
    }

    public int getScreenDepth() {
        return this.depth_;
    }

    public String getScreenId() {
        return this.screenId_;
    }

    public int getScreenWidth() {
        return this.width_;
    }

    protected void setScreenDimensions(int n, int n2) {
        this.depth_ = n;
        this.width_ = n2;
    }

    protected void setScreenDimensions(IScreenInfo iScreenInfo) {
        this.depth_ = iScreenInfo.getDepth();
        this.width_ = iScreenInfo.getWidth();
    }

    public void setScreenId(String string) {
        this.screenId_ = string;
    }

    public Object getObjectPart(Class clazz) {
        return this.fieldDataBean;
    }

    public Object getObjectPart() {
        return this.fieldDataBean;
    }

    public void setObjectPart(Object object) {
        this.fieldDataBean = object;
        if (this.fieldDataBean instanceof WSIFFormatPart) {
            ((WSIFFormatPart)this.fieldDataBean)._setFormatHandler((WSIFFormatHandler)this);
        }
    }

    public Object getElement(String string) {
        try {
            FieldRecord fieldRecord = (FieldRecord)this.getField(string);
            if (fieldRecord != null) {
                return fieldRecord.getText();
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            Trc.event((Object)this, (Object)(exception.getClass().getName() + stringWriter.toString()));
            throw new RuntimeException(exception.getLocalizedMessage());
        }
        return null;
    }

    public Object getElement(String string, int n) {
        try {
            FieldRecord fieldRecord = (FieldRecord)this.getField(string);
            if (fieldRecord != null) {
                return fieldRecord.getText();
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            Trc.event((Object)this, (Object)(exception.getClass().getName() + stringWriter.toString()));
            throw new RuntimeException(exception.getLocalizedMessage());
        }
        return null;
    }

    public void setElement(String string, Object object) {
        try {
            FieldRecord fieldRecord;
            if (object instanceof String && (fieldRecord = (FieldRecord)this.getField(string)) != null) {
                fieldRecord.setText((String)object);
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            Trc.event((Object)this, (Object)(exception.getClass().getName() + stringWriter.toString()));
            throw new RuntimeException(exception.getLocalizedMessage());
        }
    }

    public void setElement(String string, int n, Object object) {
        try {
            FieldRecord fieldRecord;
            if (object instanceof String && (fieldRecord = (FieldRecord)this.getField(string)) != null) {
                fieldRecord.setText((String)object);
            }
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            Trc.event((Object)this, (Object)(exception.getClass().getName() + stringWriter.toString()));
            throw new RuntimeException(exception.getLocalizedMessage());
        }
    }

    public boolean match(Object object) {
        boolean bl = false;
        if (object instanceof WSIFFormatHandler_JCAScreenable) {
            WSIFFormatHandler_JCAScreenable wSIFFormatHandler_JCAScreenable = (WSIFFormatHandler_JCAScreenable)object;
            if (wSIFFormatHandler_JCAScreenable.getScreenDepth() != this.getScreenDepth()) {
                return false;
            }
            if (wSIFFormatHandler_JCAScreenable.getScreenWidth() != this.getScreenWidth()) {
                return false;
            }
            if (wSIFFormatHandler_JCAScreenable.getFieldCount() != this.getFieldCount()) {
                return false;
            }
            int n = this.getFieldCount();
            int n2 = 1;
            while (n2 <= n) {
                FieldRecord fieldRecord = null;
                FieldRecord fieldRecord2 = null;
                try {
                    fieldRecord = (FieldRecord)this.getField(n2);
                    fieldRecord2 = (FieldRecord)wSIFFormatHandler_JCAScreenable.getField(n2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fieldRecord.getStartPos() != fieldRecord2.getStartPos()) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public void populate(Object object) {
        if (object instanceof WSIFFormatHandler_JCAScreenable) {
            WSIFFormatHandler_JCAScreenable wSIFFormatHandler_JCAScreenable = (WSIFFormatHandler_JCAScreenable)object;
            this.beginBuild(wSIFFormatHandler_JCAScreenable.scrInfo_, true);
            int n = wSIFFormatHandler_JCAScreenable.getFieldCount();
            int n2 = 1;
            while (n2 <= n) {
                FieldRecord fieldRecord = null;
                try {
                    fieldRecord = (FieldRecord)wSIFFormatHandler_JCAScreenable.getField(n2);
                    FieldDataImpl fieldDataImpl = new FieldDataImpl(fieldRecord.getName(), fieldRecord.getText(), fieldRecord.getStartPos(), fieldRecord.getMaxLength());
                    this.buildField(fieldDataImpl, fieldRecord.fieldAttributes_, fieldRecord.textAttributes_);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
            this.endBuild();
        }
    }

    public boolean compareFieldText(WSIFFormatHandler_JCAScreenable wSIFFormatHandler_JCAScreenable, int n, String string, int n2, boolean bl) {
        String string2;
        try {
            FieldRecord fieldRecord = (FieldRecord)wSIFFormatHandler_JCAScreenable.getFieldByPosition(n);
            if (fieldRecord == null) {
                return false;
            }
            string2 = fieldRecord.text_;
        }
        catch (Exception exception) {
            return false;
        }
        if (string == null || string2 == null || n2 < 0) {
            return false;
        }
        if (string2.length() < string.length() + n2) {
            return false;
        }
        if (string.equals("")) {
            return string.equals(string2.substring(n2).trim());
        }
        if (bl) {
            string2 = string2.toUpperCase();
        }
        return string.equals(string2.substring(n2, n2 + string.length()));
    }

    public QName getPartQName() {
        return null;
    }

    public void setPartQName(QName qName) {
    }

    protected final class FieldIterator
    implements Iterator {
        int iteratorIndex = 0;

        public boolean hasNext() {
            return this.iteratorIndex < WSIFFormatHandler_JCAScreenable.this.getFieldCount();
        }

        public Object next() {
            ++this.iteratorIndex;
            IFieldRecord iFieldRecord = null;
            try {
                iFieldRecord = WSIFFormatHandler_JCAScreenable.this.getField(this.iteratorIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return iFieldRecord;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

