/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsif.jca;

import com.ibm.wsif.WSIFCorrelationId;
import com.ibm.wsif.WSIFException;
import com.ibm.wsif.WSIFMessage;
import com.ibm.wsif.WSIFOperation;
import com.ibm.wsif.WSIFResponseHandler;
import com.ibm.wsif.jca.JCAStreamableMessage;
import com.ibm.wsif.jca.WSIFDynamicProviderJCAExtensions;
import com.ibm.wsif.jca.log.JCAResource;
import com.ibm.wsif.logging.Trc;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.Interaction;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.Record;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;

public class JCAOperation
implements WSIFOperation {
    private static final String copyright = "Licensed Material - Property of IBM <<PART NUMBER - 5724-D15>> (C) Copyright IBM Corp. 2001, 2003 - All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.".intern();
    private static final long serialVersionUID = 5L;
    protected Connection fieldConnection;
    protected InteractionSpec fieldInteractionSpec;
    protected Definition fieldDefinition;
    protected Binding fieldBinding;
    protected String fieldOperationName;
    protected String fieldInputName;
    protected String fieldOutputName;
    protected Operation fieldOperation;
    protected WSIFDynamicProviderJCAExtensions fieldFactory = null;
    private static final String crlf = System.getProperty("line.separator");
    private int traceLevel = 0;

    public JCAOperation(Definition definition, Binding binding, String string, String string2, String string3, Connection connection, InteractionSpec interactionSpec, WSIFDynamicProviderJCAExtensions wSIFDynamicProviderJCAExtensions) {
        this.fieldDefinition = definition;
        this.fieldInteractionSpec = interactionSpec;
        this.fieldConnection = connection;
        this.fieldFactory = wSIFDynamicProviderJCAExtensions;
        this.fieldBinding = binding;
        this.fieldOperationName = string;
        this.fieldInputName = string2;
        this.fieldOutputName = string3;
    }

    public boolean executeRequestResponseOperation(WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2, WSIFMessage wSIFMessage3) throws WSIFException {
        Trc.entry((Object)wSIFMessage, (Object)wSIFMessage2, (Object)wSIFMessage3);
        if (!wSIFMessage.getParts().hasNext()) {
            wSIFMessage = null;
        }
        try {
            Interaction interaction = this.fieldConnection.createInteraction();
            interaction.execute(this.fieldInteractionSpec, (Record)wSIFMessage, (Record)wSIFMessage2);
            interaction.close();
        }
        catch (ResourceException resourceException) {
            WSIFException wSIFException = new WSIFException(JCAResource.get("IWAA0100E"));
            wSIFException.setTargetException((Throwable)resourceException);
            Trc.exception((Throwable)resourceException);
            throw wSIFException;
        }
        catch (Throwable throwable) {
            WSIFException wSIFException = new WSIFException(JCAResource.get("IWAA0108E", throwable.getLocalizedMessage()));
            wSIFException.setTargetException(throwable);
            Trc.exception((Throwable)throwable);
            throw wSIFException;
        }
        Trc.exit((boolean)true);
        return true;
    }

    public void executeInputOnlyOperation(WSIFMessage wSIFMessage) throws WSIFException {
        Trc.entry((Object)wSIFMessage);
        if (!wSIFMessage.getParts().hasNext()) {
            wSIFMessage = null;
        }
        try {
            Interaction interaction = this.fieldConnection.createInteraction();
            interaction.execute(this.fieldInteractionSpec, (Record)wSIFMessage);
            interaction.close();
        }
        catch (ResourceException resourceException) {
            WSIFException wSIFException = new WSIFException(JCAResource.get("IWAA0100E"));
            Trc.exception((Throwable)resourceException);
            wSIFException.setTargetException((Throwable)resourceException);
            throw wSIFException;
        }
        catch (Throwable throwable) {
            WSIFException wSIFException = new WSIFException(JCAResource.get("IWAA0108E", throwable.getLocalizedMessage()));
            wSIFException.setTargetException(throwable);
            Trc.exception((Throwable)throwable);
            throw wSIFException;
        }
        Trc.exit();
    }

    public WSIFMessage createFaultMessage() {
        Trc.entry((Object)"createFaultMessage()");
        WSIFMessage wSIFMessage = this.fieldFactory.createFaultMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (wSIFMessage != null) {
            return wSIFMessage;
        }
        return new JCAStreamableMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 3);
    }

    public WSIFMessage createFaultMessage(String string) {
        Trc.entry((Object)string);
        Object object = this.fieldFactory.createFaultMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (object != null) {
            object.setName(string);
            return object;
        }
        object = new JCAStreamableMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 3);
        object.setName(string);
        return object;
    }

    public WSIFMessage createInputMessage() {
        Trc.entry((Object)"createInputMessage()");
        WSIFMessage wSIFMessage = this.fieldFactory.createInputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (wSIFMessage != null) {
            return wSIFMessage;
        }
        return new JCAStreamableMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 1);
    }

    public WSIFMessage createInputMessage(String string) {
        Trc.entry((Object)string);
        Object object = this.fieldFactory.createInputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (object != null) {
            object.setName(string);
            return object;
        }
        object = new JCAStreamableMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 1);
        object.setName(string);
        return object;
    }

    public WSIFMessage createOutputMessage() {
        Trc.entry((Object)"createOutputMessage()");
        WSIFMessage wSIFMessage = this.fieldFactory.createOutputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (wSIFMessage != null) {
            return wSIFMessage;
        }
        return new JCAStreamableMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 2);
    }

    public WSIFMessage createOutputMessage(String string) {
        Trc.entry((Object)string);
        Object object = this.fieldFactory.createOutputMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName);
        if (object != null) {
            object.setName(string);
            return object;
        }
        object = new JCAStreamableMessage(this.fieldDefinition, this.fieldBinding, this.fieldOperationName, this.fieldInputName, this.fieldOutputName, 2);
        object.setName(string);
        return object;
    }

    public InteractionSpec getInteractionSpec() {
        return this.fieldInteractionSpec;
    }

    public void setInteractionSpec(InteractionSpec interactionSpec) {
        this.fieldInteractionSpec = interactionSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(crlf + "[JCAOperation" + crlf);
        try {
            if (this.fieldConnection != null) {
                stringBuffer.append("\tConnection: " + this.fieldConnection.toString() + crlf);
            } else {
                stringBuffer.append("\tConnection: null" + crlf);
            }
            if (this.fieldInteractionSpec != null) {
                stringBuffer.append("\tInteractionSpec:       " + this.fieldInteractionSpec.toString() + crlf);
            } else {
                stringBuffer.append("\tInteractionSpec:       null" + crlf);
            }
            if (this.fieldBinding != null) {
                stringBuffer.append("\tBinding:    " + this.fieldBinding.toString() + crlf);
            } else {
                stringBuffer.append("\tBinding:    null" + crlf);
            }
            if (this.fieldOperation != null) {
                stringBuffer.append("\tOperation:    " + this.fieldOperation.toString() + crlf);
            } else {
                stringBuffer.append("\tOperation:    null" + crlf);
            }
            if (this.fieldFactory != null) {
                stringBuffer.append("\tFactory:    " + this.fieldFactory.toString() + crlf);
            } else {
                stringBuffer.append("\tFactory:    null" + crlf);
            }
            if (this.fieldOperationName != null) {
                stringBuffer.append("\tOperationName:    " + this.fieldOperationName + crlf);
            } else {
                stringBuffer.append("\tOperationName:    null" + crlf);
            }
            if (this.fieldInputName != null) {
                stringBuffer.append("\tInputName:    " + this.fieldInputName + crlf);
            } else {
                stringBuffer.append("\tInputName:    null" + crlf);
            }
            if (this.fieldOutputName != null) {
                stringBuffer.append("\tOutputName:    " + this.fieldOutputName + crlf);
            } else {
                stringBuffer.append("\tOutputName:    null" + crlf);
            }
            stringBuffer.append("]" + crlf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        return null;
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        return null;
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
    }

    public void processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
    }

    public void setContext(WSIFMessage wSIFMessage) {
    }

    public WSIFMessage getContext() {
        return null;
    }
}

