/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.MalformedTraceStringException;
import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.TraceElementState;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.util.SecurityHelper;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.Notification;
import javax.security.auth.Subject;

public class TraceServiceMBeanProxy
extends ProxyMBeanSupport {
    private static TraceComponent tc = Tr.register(TraceServiceMBeanProxy.class, "TraceService", null);
    private ServantMBeanInvoker mbeanInvoker = null;
    private static final boolean ringBufSupported = false;

    public TraceServiceMBeanProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this.mbeanInvoker = this.getInvoker();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public String getTraceSpecification() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceSpecification");
        }
        String specification = ManagerAdmin.getTraceSpecification();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTraceSpecification", specification);
        }
        return specification;
    }

    public String getTraceSpecification(String component2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceSpecification", component2);
        }
        String specification = ManagerAdmin.getTraceSpecification(component2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTraceSpecification", specification);
        }
        return specification;
    }

    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String type = notification.getType();
        Object userData = notification.getUserData();
        ServantMBeanStatus status = (ServantMBeanStatus)userData;
        String stoken = status.getServantStoken();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", status);
            Tr.debug(tc, "handleInternalNotification type", type);
        }
        if ("websphere.ws390.servant.started".equals(type) && this.getServantsAndAdjuncts().contains(stoken) || "websphere.ws390.servant.mbean.registered".equals(type) && this.getServantsAndAdjuncts().contains(stoken)) {
            SetRuntimeTraceSpecification setter = new SetRuntimeTraceSpecification(stoken);
            Thread thread = new Thread(setter);
            thread.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    public void setTraceState(String traceString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTraceState", traceString);
        }
        ManagerAdmin.setTraceState(traceString);
        Object[] params = new Object[]{traceString};
        String[] sig = new String[]{"java.lang.String"};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "setTraceState", params, sig);
        if (tc.isEventEnabled()) {
            this.proxyHelperTraceThrowables("setTraceState", results, tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTraceState");
        }
    }

    private Set getServantsAndAdjuncts() {
        HashSet returnSet = new HashSet(this.currentServants());
        int setSz = returnSet.size();
        returnSet.addAll(this.currentAdjuncts());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getServantsAndAdjuncts svntSz: " + setSz + " TotSz: ", new Integer(returnSet.size()));
        }
        return returnSet;
    }

    public void appendTraceString(String traceString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appendTraceString", traceString);
        }
        ManagerAdmin.appendTraceString(traceString);
        Object[] params = new Object[]{traceString};
        String[] sig = new String[]{"java.lang.String"};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "appendTraceString", params, sig);
        if (tc.isEventEnabled()) {
            this.proxyHelperTraceThrowables("appendTraceString", results, tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appendTraceString");
        }
    }

    public int getRingBufferSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRingBufferSize");
        }
        int size = ManagerAdmin.getRingBufferSize();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRingBufferSize", new Integer(size));
        }
        return size;
    }

    public void setRingBufferSize(int numberOfEntries) throws NotSupportedOnZOSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRingBufferSize", new Integer(numberOfEntries));
        }
        throw new NotSupportedOnZOSException("setRingBufferSize not supported");
    }

    public void dumpRingBuffer(String fileToWriteTo) throws NotSupportedOnZOSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dumpRingBuffer", fileToWriteTo);
        }
        throw new NotSupportedOnZOSException("dumpRingBuffer not supported");
    }

    public void clearRingBuffer() throws NotSupportedOnZOSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearRingBuffer");
        }
        throw new NotSupportedOnZOSException("clearRingBuffer not supported");
    }

    public String[] listAllRegisteredComponents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllRegisteredComponents");
        }
        HashSet compositeComponents = new HashSet();
        String[] components = ManagerAdmin.listAllRegisteredComponents();
        this.addArrayToSet(compositeComponents, components);
        Object[] params = new Object[]{};
        String[] sig = new String[]{};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "listAllRegisteredComponents", params, sig);
        for (int i = 0; i < results.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.elementAt(i);
            if (data.resultThrowable()) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Servant error: " + data.getStoken(), data.getResult());
                continue;
            }
            components = (String[])data.getResult();
            this.addArrayToSet(compositeComponents, components);
        }
        String[] returnComponents = this.getStringArrayFromSet(compositeComponents);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllRegisteredComponents", returnComponents);
        }
        return returnComponents;
    }

    public String[] listAllRegisteredGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllRegisteredGroups");
        }
        HashSet compositeGroups = new HashSet();
        String[] groups = ManagerAdmin.listAllRegisteredGroups();
        this.addArrayToSet(compositeGroups, groups);
        Object[] params = new Object[]{};
        String[] sig = new String[]{};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "listAllRegisteredGroups", params, sig);
        for (int i = 0; i < results.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.elementAt(i);
            if (data.resultThrowable()) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Servant error: " + data.getStoken(), data.getResult());
                continue;
            }
            groups = (String[])data.getResult();
            this.addArrayToSet(compositeGroups, groups);
        }
        String[] returnGroups = this.getStringArrayFromSet(compositeGroups);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllRegisteredGroups", returnGroups);
        }
        return returnGroups;
    }

    public String[] listComponentsInGroup(String group) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listComponentsInGroup", group);
        }
        HashSet compositeComponents = new HashSet();
        String[] components = ManagerAdmin.listComponentsInGroup(group);
        this.addArrayToSet(compositeComponents, components);
        Object[] params = new Object[]{group};
        String[] sig = new String[]{"java.lang.String"};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "listComponentsInGroup", params, sig);
        for (int i = 0; i < results.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.elementAt(i);
            if (data.resultThrowable()) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Servant error: " + data.getStoken(), data.getResult());
                continue;
            }
            components = (String[])data.getResult();
            this.addArrayToSet(compositeComponents, components);
        }
        String[] returnComponents = this.getStringArrayFromSet(compositeComponents);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listComponentsInGroup", returnComponents);
        }
        return returnComponents;
    }

    public HashMap listComponentsInGroup(String[] groups) {
        Vector<HashMap> servantMaps;
        HashMap<String, String[]> compositeGroupMap;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "listComponentsInGroup(String[])", groups);
            }
            compositeGroupMap = new HashMap<String, String[]>(groups.length);
            servantMaps = new Vector<HashMap>();
            this.mbeanInvoker.refresh();
            Object[] params = new Object[]{groups};
            String[] sig = new String[]{"[Ljava.lang.String;"};
            if (this.mbeanInvoker.hasNext()) {
                try {
                    HashMap servantGroupMap = (HashMap)this.mbeanInvoker.invokeNext("TraceService", "listComponentsInGroup", params, sig);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "servantGroupMap", servantGroupMap);
                    }
                    servantMaps.add(servantGroupMap);
                }
                catch (Throwable t) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Connector/Servant error", t);
                }
            }
        }
        for (int i = 0; i < groups.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "groups[" + i + "]", groups[i]);
            }
            String[] controllerComponents = ManagerAdmin.listComponentsInGroup(groups[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "controllerComponents", controllerComponents);
            }
            HashSet compositeComponents = new HashSet();
            this.addArrayToSet(compositeComponents, controllerComponents);
            for (int j = 0; j < servantMaps.size(); ++j) {
                HashMap servantGroupMap = (HashMap)servantMaps.elementAt(j);
                String[] servantComponents = (String[])servantGroupMap.get(groups[i]);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "servantComponents", servantComponents);
                }
                this.addArrayToSet(compositeComponents, servantComponents);
            }
            String[] groupComponents = this.getStringArrayFromSet(compositeComponents);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "groupComponents", groupComponents);
            }
            compositeGroupMap.put(groups[i], groupComponents);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listComponentsInGroup(String[])", compositeGroupMap);
        }
        return compositeGroupMap;
    }

    public TraceElementState[] getTracedComponents() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTracedComponents");
        }
        HashMap compositeElements = new HashMap();
        TraceElementState[] elements = ManagerAdmin.getTracedComponents();
        this.addElementsToMap(compositeElements, elements);
        Object[] params = new Object[]{};
        String[] sig = new String[]{};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "getTracedComponents", params, sig);
        for (int i = 0; i < results.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.elementAt(i);
            if (data.resultThrowable()) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Servant error: " + data.getStoken(), data.getResult());
                continue;
            }
            elements = (TraceElementState[])data.getResult();
            this.addElementsToMap(compositeElements, elements);
        }
        TraceElementState[] returnElements = this.getElementsFromMap(compositeElements);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTracedComponents", returnElements);
        }
        return returnElements;
    }

    public TraceElementState[] getTracedGroups() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTracedGroups");
        }
        HashMap compositeElements = new HashMap();
        TraceElementState[] elements = ManagerAdmin.getTracedGroups();
        this.addElementsToMap(compositeElements, elements);
        Object[] params = new Object[]{};
        String[] sig = new String[]{};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "getTracedGroups", params, sig);
        for (int i = 0; i < results.size(); ++i) {
            ServantMBeanInvokerData data = (ServantMBeanInvokerData)results.elementAt(i);
            if (data.resultThrowable()) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Servant error: " + data.getStoken(), data.getResult());
                continue;
            }
            elements = (TraceElementState[])data.getResult();
            this.addElementsToMap(compositeElements, elements);
        }
        TraceElementState[] returnElements = this.getElementsFromMap(compositeElements);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTracedGroups", returnElements);
        }
        return returnElements;
    }

    public void processDumpString(String dumpString) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processDumpString", dumpString);
        }
        ManagerAdmin.processDumpString(dumpString);
        Object[] params = new Object[]{dumpString};
        String[] sig = new String[]{"java.lang.String"};
        Vector results = this.mbeanInvoker.invokeSpecifiedServants(this.getServantsAndAdjuncts(), this.getObjectName(), "processDumpString", params, sig);
        if (tc.isEventEnabled()) {
            this.proxyHelperTraceThrowables("processDumpString", results, tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processDumpString");
        }
    }

    public void checkTraceString(String traceString) throws MalformedTraceStringException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkTraceString", traceString);
        }
        ManagerAdmin.checkTraceString(traceString);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkTraceString");
        }
    }

    public static String getTraceFileName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTraceFileName");
        }
        String fileName = ManagerAdmin.getTraceFileName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTraceFileName", fileName);
        }
        return fileName;
    }

    public void setTraceOutputToFile(String fileName, int rollover, int maxBackups, String traceFormat) throws RasException, NotSupportedOnZOSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTraceOutputToFile", new Object[]{fileName, new Integer(rollover), new Integer(maxBackups), traceFormat});
        }
        throw new NotSupportedOnZOSException("setTraceOutputToFile not supported");
    }

    public String getTraceRuntimeConfig() {
        return ManagerAdmin.getRuntimeConfig();
    }

    public void setTraceOutputToRingBuffer(int ringBufferSize, String traceFormat) throws RasException, NotSupportedOnZOSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTraceOutputToRingBuffer", new Object[]{new Integer(ringBufferSize), traceFormat});
        }
        throw new NotSupportedOnZOSException("setTraceOutputToRingBuffer not supported");
    }

    public String rolloverLogFileImmediate(String streamName, String fileName) throws RasException, NotSupportedOnZOSException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rolloverLogFileImmediate", new Object[]{streamName, fileName});
        }
        throw new NotSupportedOnZOSException("rolloverLogFileImmediate not supported");
    }

    private void addArrayToSet(Set set, String[] elements) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                set.add(elements[i]);
            }
        }
    }

    private String[] getStringArrayFromSet(Set set) {
        Object[] objects = set.toArray();
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = (String)objects[i];
        }
        return strings;
    }

    private void addElementsToMap(HashMap map, TraceElementState[] elements) {
        if (elements != null) {
            for (int i = 0; i < elements.length; ++i) {
                if (map.containsKey(elements[i].name)) {
                    TraceElementState mappedElement = (TraceElementState)map.get(elements[i].name);
                    mappedElement.mask |= elements[i].mask;
                    continue;
                }
                map.put(elements[i].name, elements[i]);
            }
        }
    }

    private TraceElementState[] getElementsFromMap(HashMap map) {
        Set entrySet = map.entrySet();
        Iterator iterator = entrySet.iterator();
        TraceElementState[] elements = new TraceElementState[entrySet.size()];
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            elements[i++] = (TraceElementState)mapEntry.getValue();
        }
        return elements;
    }

    private class SetRuntimeTraceSpecification
    implements Runnable {
        private String stoken = null;

        public SetRuntimeTraceSpecification(String stoken) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "SetRuntimeTraceSpecification.<init>", stoken);
            }
            this.stoken = stoken;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SetRuntimeTraceSpecification.<init>");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block14: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "SetRuntimeTraceSpecification.run");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant stoken", this.stoken);
                }
                Subject savedSubject = null;
                Subject subject = null;
                try {
                    block13: {
                        try {
                            subject = SecurityHelper.getServerSubject();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "subject", subject);
                            }
                            if (subject != null) {
                                savedSubject = SecurityHelper.pushInvocationSubject(subject);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "savedSubject", savedSubject);
                            }
                            String specification = ManagerAdmin.getTraceSpecification();
                            Object[] params = new Object[]{specification};
                            String[] sig = new String[]{"java.lang.String"};
                            ServantMBeanInvokerData data = TraceServiceMBeanProxy.this.mbeanInvoker.invokeSpecificServant(this.stoken, TraceServiceMBeanProxy.this.getObjectName(), "setTraceState", params, sig);
                            if (!tc.isEventEnabled()) break block13;
                            TraceServiceMBeanProxy.this.proxyHelperTraceThrowable("setTraceState", data, tc);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws390.management.proxy.TraceServiceMBeanProxy.run", (String)"1140", (Object)this);
                            if (tc.isEventEnabled()) {
                                Tr.debug(tc, "Error while attempting to sync servant trace spec", t);
                            }
                            Object var8_9 = null;
                            if (subject != null) {
                                SecurityHelper.popInvocationSubject(savedSubject);
                            }
                            break block14;
                        }
                    }
                    Object var8_8 = null;
                    if (subject == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (subject != null) {
                        SecurityHelper.popInvocationSubject(savedSubject);
                    }
                    throw throwable;
                }
                SecurityHelper.popInvocationSubject(savedSubject);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "SetRuntimeTraceSpecification.run");
            }
        }
    }

    private class NotSupportedOnZOSException
    extends Exception {
        private static final long serialVersionUID = 1142298553816479181L;

        public NotSupportedOnZOSException(String msg) {
            super(msg);
        }
    }
}

