/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataPackage;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.CommandNotification;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.ServantNotificationHandler;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.EObjectSerializer;
import com.ibm.ws.management.cmdframework.impl.RemoteCommandMgrImpl;
import com.ibm.ws.management.cmdframework.impl.ServerCommandMgr;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSession;
import com.ibm.ws.management.cmdframework.impl.TaskCommandSessionMgr;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import com.ibm.ws390.management.proxy.ConfigServiceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class RemoteCommandMgr
extends ProxyMBeanSupport
implements AlarmListener,
ServantNotificationHandler {
    private static TraceComponent tc = Tr.register(RemoteCommandMgr.class, "management", "com.ibm.ws.management.resources.configservice");
    private Map sessionToSR;
    private Map localSessionToSRSession;
    private Map servantSessionToLocalSession;
    private Map expiredSessions;
    private SortedSet currentServants;
    private long TIMEOUT;
    private RemoteCommandMgrImpl localMgr;
    private String waitLock;
    private int DEAD_SERVANT_WAIT;

    public RemoteCommandMgr() {
        block4: {
            this.sessionToSR = Collections.synchronizedMap(new HashMap());
            this.localSessionToSRSession = Collections.synchronizedMap(new HashMap());
            this.servantSessionToLocalSession = Collections.synchronizedMap(new HashMap());
            this.expiredSessions = Collections.synchronizedMap(new HashMap());
            this.currentServants = Collections.synchronizedSortedSet(new TreeSet());
            this.TIMEOUT = 1800000L;
            this.waitLock = "My Lock";
            this.DEAD_SERVANT_WAIT = 3000;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RemoteCommandMgr");
            }
            this.RegisterForNotifications();
            CommandDataPackage pack = CommandDataPackage.eINSTANCE;
            try {
                this.localMgr = new RemoteCommandMgrImpl();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.RemoteCommandMgr", (String)"90", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Exception caught when loading localmgr", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RemoteCommandMgr");
        }
    }

    public void RegisterForNotifications() {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RegisterForNotifications");
            }
            try {
                AdminService admin = AdminServiceFactory.getAdminService();
                String node = admin.getNodeName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node: ", node);
                }
                String proc = admin.getProcessName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Process: ", proc);
                }
                String query = "WebSphere:*,type=RemoteCommandMgr,node=" + node + ",process=" + proc;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Query: ", query);
                }
                ObjectName work = new ObjectName(query);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Work: ", work);
                }
                NotificationFilterSupport filter = new NotificationFilterSupport();
                admin.addNotificationListenerExtended(work, this, filter, null);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.RegisterForNotifications", (String)"122", (Object)this);
                if (!tc.isDebugEnabled()) break block8;
                Tr.debug(tc, "Error", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RegisterForNotifications");
        }
    }

    public ArrayList listCommandGroups() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommandGroups");
        }
        ArrayList result = this.localMgr.listCommandGroups();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommandGroups", result);
        }
        return result;
    }

    public ArrayList listCommands(String commandGroup) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommands", new Object[]{commandGroup});
        }
        ArrayList result = this.localMgr.listCommands(commandGroup);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommands", result);
        }
        return result;
    }

    public ArrayList listCommands() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommands");
        }
        ArrayList result = this.localMgr.listCommands();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommands", result);
        }
        return result;
    }

    public ArrayList listAllCommands() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllCommands");
        }
        ArrayList result = this.localMgr.listAllCommands();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllCommands", result);
        }
        return result;
    }

    public ArrayList listCommandStepsWithData(TaskCommandSession session, EObjectSerializer cmdDataEObj) throws CommandNotFoundException, CommandLoadException, ConnectorException {
        AbstractTaskCommand storedTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listCommandStepsWithData, Task command session: " + session);
        }
        ArrayList returnData = null;
        String stoken = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)cmdMgr).getTaskCommandSessionMgr();
        try {
            storedTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
        }
        catch (Exception ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.listCommandStepsWithData", (String)"250", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            throw new CommandLoadException(ioe);
        }
        String name = storedTaskCommand.getName();
        Session configSession = storedTaskCommand.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command Name: " + name + ", Config Session: " + configSession);
        }
        if (configSession != null) {
            stoken = ConfigServiceManager.getServantStoken(configSession);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stoken 1: " + stoken);
            }
            if (stoken == null) {
                stoken = this.getStoken(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken 2: " + stoken);
                }
                stoken = ConfigServiceManager.addServantStoken(configSession, stoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken 3: " + stoken);
                }
            }
        }
        returnData = (ArrayList)this.objectPlayer(session, configSession, stoken, null, "listCommandStepsWithData", name, new Object[]{null, cmdDataEObj}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listCommandStepsWithData, Task command session: " + session + ", returnedData: " + returnData);
        }
        return returnData;
    }

    public CommandResult execute(EObjectSerializer command) throws CommandNotFoundException, CommandLoadException, ConnectorException {
        CommandData cmdData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{command});
        }
        CommandResult result = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        try {
            cmdData = (CommandData)command.getEObjectValue();
        }
        catch (IOException ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.execute", (String)"163", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            throw new CommandLoadException(ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command execute is " + cmdData.getName());
        }
        String name = cmdData.getName();
        CommandProvider cmdProvider = CommandMetadataMgr.getInstance().getCommandProvider(cmdData.getName());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Command provider is " + cmdProvider);
        }
        AbstractAdminCommand clientCommand = cmdProvider.loadCommand(cmdData);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AdminCommand is ", clientCommand);
        }
        Session configSession = clientCommand.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config Session ", configSession);
        }
        String stoken = ConfigServiceManager.getServantStoken(configSession);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        if (stoken == null) {
            if (super.currentServants().size() > 0) {
                HashSet stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
                if (stokenSet.size() == 0) {
                    throw new ConnectorException("No available servant");
                }
                stoken = (String)stokenSet.iterator().next();
                stoken = ConfigServiceManager.addServantStoken(configSession, stoken);
            } else {
                throw new ConnectorException("No available servant");
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "about to invoke");
        }
        result = (CommandResult)this.objectPlayer("execute", name, new Object[]{command}, new String[]{"com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", result);
        }
        return result;
    }

    public EObjectSerializer getCommandGroupMetaInfo(String commandGrpName, Locale locale) throws CommandNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandGroupMetaInfo", new Object[]{commandGrpName, locale});
        }
        EObjectSerializer result = null;
        result = this.localMgr.getCommandGroupMetaInfo(commandGrpName, locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandGroupMetaInfo", result);
        }
        return result;
    }

    public Collection getAllCommandGrpMetaInfo(Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandGrpMetaInfo", new Object[]{locale});
        }
        Collection result = null;
        result = this.localMgr.getAllCommandGrpMetaInfo(locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllCommandGrpMetaInfo", result);
        }
        return result;
    }

    public EObjectSerializer getCommandMetaInfo(String commandName, Locale locale) throws CommandNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetaInfo", new Object[]{commandName, locale});
        }
        EObjectSerializer result = null;
        result = this.localMgr.getCommandMetaInfo(commandName, locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetaInfo", result);
        }
        return result;
    }

    public Collection getAllCommandMetaInfo(Locale locale) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAllCommandMetaInfo", new Object[]{locale});
        }
        Collection result = null;
        result = this.localMgr.getAllCommandMetaInfo(locale);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAllCommandMetaInfo", result);
        }
        return result;
    }

    public CommandResult execute(TaskCommandSession session, EObjectSerializer command) throws CommandNotFoundException, CommandLoadException, ConnectorException {
        TaskCommandData newTaskCmdData;
        AbstractTaskCommand storedTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute", new Object[]{session, command});
        }
        CommandResult result = null;
        String stoken = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)cmdMgr).getTaskCommandSessionMgr();
        try {
            storedTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
            newTaskCmdData = (TaskCommandData)command.getEObjectValue();
        }
        catch (Exception ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.execute", (String)"267", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            throw new CommandLoadException(ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting TaskCommandData", newTaskCmdData);
        }
        storedTaskCommand.resetCommandData((CommandData)newTaskCmdData);
        String name = storedTaskCommand.getName();
        Session configSession = storedTaskCommand.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config Session ", configSession);
        }
        if (configSession != null) {
            stoken = ConfigServiceManager.getServantStoken(configSession);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stoken", stoken);
            }
            if (stoken == null) {
                stoken = this.getStoken(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken 2", stoken);
                }
                stoken = ConfigServiceManager.addServantStoken(configSession, stoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken 3", stoken);
                }
            }
        }
        result = (CommandResult)this.objectPlayer(session, configSession, stoken, null, "execute", name, new Object[]{null, command}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute", new Object[]{result});
        }
        return result;
    }

    public EObjectSerializer getCurrentStep(TaskCommandSession session, EObjectSerializer cliCmdStepDataEObj, Integer operation, String stepName) throws ConnectorException {
        AbstractTaskCommand serverTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentStep", new Object[]{session, cliCmdStepDataEObj, operation, stepName});
        }
        EObjectSerializer result = null;
        String stoken = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)cmdMgr).getTaskCommandSessionMgr();
        try {
            serverTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
        }
        catch (Exception ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.getCurrentStep", (String)"333", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            return new EObjectSerializer();
        }
        Session configSession = serverTaskCommand.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config Session ", configSession);
        }
        if (configSession != null) {
            stoken = ConfigServiceManager.getServantStoken(configSession);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stoken", stoken);
            }
            if (stoken == null) {
                stoken = this.getStoken(null);
                stoken = ConfigServiceManager.addServantStoken(configSession, stoken);
            }
        }
        String savedStoken = (String)this.sessionToSR.get(session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "saved stoken", savedStoken);
        }
        TaskCommandSession servantSession = session;
        if (savedStoken == null || !savedStoken.equals(stoken)) {
            ArrayList list = this._contructSteps(serverTaskCommand.getName(), stoken);
            servantSession = (TaskCommandSession)list.get(0);
            this.localSessionToSRSession.put(session, servantSession);
            this.servantSessionToLocalSession.put(servantSession.getSessionId(), session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Put sessionId " + servantSession.getSessionId() + " for session " + session);
            }
            this.sessionToSR.put(session, stoken);
            savedStoken = stoken;
        } else {
            servantSession = (TaskCommandSession)this.localSessionToSRSession.get(session);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "servant session", servantSession);
        }
        HashSet<String> specified = new HashSet<String>();
        specified.add(savedStoken);
        Vector vec = this.getInvoker().invokeSpecifiedServants(specified, this.getObjectName(), "getCurrentStep", new Object[]{servantSession, cliCmdStepDataEObj, operation, stepName}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer", "java.lang.Integer", "java.lang.String"});
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)vec.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant_mbeanInvokerData", data);
        }
        if (data == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            if (th instanceof ConnectorException) {
                throw (ConnectorException)th;
            }
            throw new ConnectorException(th);
        }
        result = (EObjectSerializer)data.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expected Result", result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentStep", new Object[]{result});
        }
        return result;
    }

    public ArrayList getCurrentStepInList(TaskCommandSession session, EObjectSerializer cliCmdStepDataEObj, Integer operation, String stepName) throws ConnectorException {
        AbstractTaskCommand serverTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentStepInList", new Object[]{session, cliCmdStepDataEObj, operation, stepName});
        }
        ArrayList result = null;
        String stoken = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)cmdMgr).getTaskCommandSessionMgr();
        try {
            serverTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
        }
        catch (Exception ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.getCurrentStepInList", (String)"485", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            return new ArrayList();
        }
        Session configSession = serverTaskCommand.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config Session ", configSession);
        }
        if (configSession != null) {
            stoken = ConfigServiceManager.getServantStoken(configSession);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stoken", stoken);
            }
            if (stoken == null) {
                stoken = this.getStoken(null);
                stoken = ConfigServiceManager.addServantStoken(configSession, stoken);
            }
        }
        String savedStoken = (String)this.sessionToSR.get(session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "saved stoken", savedStoken);
        }
        TaskCommandSession servantSession = session;
        if (savedStoken == null || !savedStoken.equals(stoken)) {
            ArrayList list = this._contructSteps(serverTaskCommand.getName(), stoken);
            servantSession = (TaskCommandSession)list.get(0);
            this.localSessionToSRSession.put(session, servantSession);
            this.servantSessionToLocalSession.put(servantSession.getSessionId(), session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Put sessionId " + servantSession.getSessionId() + " for session " + session);
            }
            this.sessionToSR.put(session, stoken);
            savedStoken = stoken;
        } else {
            servantSession = (TaskCommandSession)this.localSessionToSRSession.get(session);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "servant session", servantSession);
        }
        HashSet<String> specified = new HashSet<String>();
        specified.add(savedStoken);
        Vector vec = this.getInvoker().invokeSpecifiedServants(specified, this.getObjectName(), "getCurrentStepInList", new Object[]{servantSession, cliCmdStepDataEObj, operation, stepName}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer", "java.lang.Integer", "java.lang.String"});
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)vec.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant_mbeanInvokerData", data);
        }
        if (data == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            if (th instanceof ConnectorException) {
                throw (ConnectorException)th;
            }
            throw new ConnectorException(th);
        }
        result = (ArrayList)data.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expected Result", result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentStepInList", new Object[]{result});
        }
        return result;
    }

    public ArrayList contructSteps(String taskCmdName) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contructSteps", taskCmdName);
        }
        Object result = null;
        String stoken = this.getStoken(null);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        ArrayList localList = this.localMgr.contructSteps(taskCmdName);
        TaskCommandSession tcs = (TaskCommandSession)localList.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Session / SR table", new Object[]{tcs, this.sessionToSR});
        }
        this.localSessionToSRSession.put(tcs, null);
        this.sessionToSR.put(tcs, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contructSteps", new Object[]{tcs, result, this.sessionToSR, this.localSessionToSRSession});
        }
        return localList;
    }

    private ArrayList _contructSteps(String taskCmdName, String stoken) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_contructSteps", new Object[]{taskCmdName, stoken});
        }
        ArrayList result = null;
        HashSet<String> specified = new HashSet<String>();
        specified.add(stoken);
        Vector vec = this.getInvoker().invokeSpecifiedServants(specified, this.getObjectName(), "contructSteps", new Object[]{taskCmdName}, new String[]{"java.lang.String"});
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)vec.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant_mbeanInvokerData", data);
        }
        if (data == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            if (th instanceof ConnectorException) {
                throw (ConnectorException)th;
            }
            throw new ConnectorException(th);
        }
        result = (ArrayList)data.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expected Result", result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_contructSteps", new Object[]{result});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStoken(TaskCommandSession session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoken", session);
        }
        String stoken = "";
        Map map = this.sessionToSR;
        synchronized (map) {
            if (session != null && this.sessionToSR.containsKey(session)) {
                stoken = (String)this.sessionToSR.get(session);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got stoken using session", new Object[]{stoken, session});
                }
                this.sessionToSR.put(session, stoken);
            } else if (session == null) {
                if (this.currentServants.size() == 0) {
                    this.currentServants.addAll(super.currentServants());
                    Set currentAdjuncts = ControlAdminServiceImpl.getInstance().currentAdjuncts();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing Adjuncts Stoken", currentAdjuncts);
                    }
                    this.currentServants.removeAll(currentAdjuncts);
                }
                stoken = (String)this.currentServants.first();
                this.currentServants.remove(stoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken", new Object[]{stoken});
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "returning null, could not find");
                }
                return null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStoken", stoken);
        }
        return stoken;
    }

    public void handleServantNotification(Notification notification) {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "RCM handleServantNotification", new Object[]{notification});
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AdminContext:", AdminContext.peek());
            }
            String type = notification.getType();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Notification Event", new Object[]{type});
            }
            try {
                Notification notif = new Notification(notification.getType(), (Object)this, notification.getSequenceNumber(), notification.getMessage());
                Object userData = notification.getUserData();
                if (userData instanceof CommandNotification) {
                    CommandNotification cmdNotification;
                    long session;
                    TaskCommandSession localSession;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "userData is CommandNotification");
                    }
                    if ((localSession = (TaskCommandSession)this.servantSessionToLocalSession.get(session = (cmdNotification = (CommandNotification)userData).getSessionID())) != null) {
                        String cName = cmdNotification.getCmdName();
                        String sName = cmdNotification.getCmdStepName();
                        String cStatus = cmdNotification.getCmdStatus();
                        String sStatus = cmdNotification.getCmdStepStatus();
                        String msg = cmdNotification.getMessage();
                        Object uData = cmdNotification.getUserData();
                        CommandResult cmdResult = cmdNotification.getResult();
                        userData = new CommandNotification(cName, sName, cStatus, sStatus, msg, localSession.getSessionId(), uData, cmdResult);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "mapped session in CommandNotification from " + session + " to " + localSession.getSessionId());
                        }
                    }
                }
                notif.setUserData(userData);
                super.sendNotification(notif);
            }
            catch (MBeanException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.proxy.AppManagementMBeanProxy.handleServantNotification", (String)"1388", (Object)this);
                if (!tc.isDebugEnabled()) break block10;
                Tr.debug(tc, "handleServantNotification exception", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RCM handleServantNotification");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String eventType = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event type", eventType);
        }
        ServantMBeanStatus status = (ServantMBeanStatus)notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", status);
        }
        if (eventType.equals("websphere.ws390.servant.terminated")) {
            String servantStoken = status.getServantStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken", servantStoken);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before Removal: ", this.sessionToSR);
            }
            Map map = this.sessionToSR;
            synchronized (map) {
                Collection values = this.sessionToSR.values();
                values.remove(servantStoken);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After Removal: ", this.sessionToSR);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    private void registerAlarm() {
        AlarmManager.createDeferrable((long)this.TIMEOUT, (AlarmListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void alarm(Object alarmContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm");
        }
        try {
            try {
                Map map = this.sessionToSR;
                synchronized (map) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Before Removal: ", this.sessionToSR);
                    }
                    Set entrySet = this.sessionToSR.entrySet();
                    Iterator iter = entrySet.iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        TaskCommandSession key = (TaskCommandSession)entry.getKey();
                        if (!key.isExpired()) continue;
                        TaskCommandSession servantSession = (TaskCommandSession)this.localSessionToSRSession.get(key);
                        if (servantSession != null) {
                            this.servantSessionToLocalSession.remove(servantSession.getSessionId());
                        }
                        this.localSessionToSRSession.remove(key);
                        iter.remove();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "removed session", key);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "removed servant session", servantSession);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "After Removal: ", this.sessionToSR);
                    }
                }
                Object var10_10 = null;
                this.registerAlarm();
            }
            catch (Throwable th) {
                FFDCFilter.processException((Throwable)th, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr", (String)"471", (Object)this);
                Object var10_11 = null;
                this.registerAlarm();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.registerAlarm();
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    private Object objectPlayer(String function, String name, Object[] args, String[] sargs) throws CommandNotFoundException, CommandLoadException, ConnectorException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectPlayer", new Object[]{function, args, sargs});
        }
        ServantMBeanInvokerData data = this.getInvoker().invokeAnyServant(this.currentServants(), this.getObjectName(), function, args, sargs);
        Object result = data.getResult();
        if (data.resultThrowable()) {
            Throwable th = (Throwable)result;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            try {
                this.unwrapException(th);
            }
            catch (InstanceNotFoundException infe) {
                FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.objectPlayer", (String)"610", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "InstanceNotFoundException, servant must be dead", infe);
                }
                throw new ConnectorException("InstanceNotFoundException during RCM objectPlayer", infe);
            }
            catch (ConnectorException ce) {
                FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.objectPlayer", (String)"613", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ConnectorException, servant might be dead?", ce);
                }
                throw new ConnectorException("Connector Exception during RCM objectPlayer", ce);
            }
            catch (Throwable t) {
                throw new ConnectorException("Throwable caught in RCM objectPlayer", t);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "objectPlayer", result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectPlayer");
        }
        return result;
    }

    private Object objectPlayer(TaskCommandSession session, Session configSession, String stoken, Set stokenSet, String function, String name, Object[] args, String[] sargs) throws CommandNotFoundException, CommandLoadException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectPlayer", new Object[]{session, stokenSet, function, args, sargs});
        }
        Object result = null;
        String savedStoken = (String)this.sessionToSR.get(session);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "saved stoken", savedStoken);
        }
        TaskCommandSession servantSession = session;
        if (savedStoken == null || !savedStoken.equals(stoken)) {
            ArrayList list = null;
            try {
                list = this._contructSteps(name, stoken);
            }
            catch (ConnectorException ce) {
                Iterator stokenIt;
                FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.objectPlayer", (String)"654", (Object)this);
                ConfigServiceManager.removeServantStoken(configSession, stoken);
                if (stokenSet == null) {
                    stokenSet = new HashSet(super.currentServants());
                    stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
                }
                stokenSet.remove(stoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "failover mode");
                }
                if ((stokenIt = stokenSet.iterator()).hasNext()) {
                    stoken = (String)stokenIt.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "new stoken chosen", stoken);
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "we are totally out of servants I give up!");
                    }
                    throw new ConnectorException("Could not find a valid servant");
                }
                this.pauseForServant();
                result = this.objectPlayer(session, configSession, stoken, stokenSet, function, name, args, sargs);
                return result;
            }
            servantSession = (TaskCommandSession)list.get(0);
            this.localSessionToSRSession.put(session, servantSession);
            this.servantSessionToLocalSession.put(servantSession.getSessionId(), session);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Put sessionId " + servantSession.getSessionId() + " for session " + session);
            }
            this.sessionToSR.put(session, stoken);
        } else {
            servantSession = (TaskCommandSession)this.localSessionToSRSession.get(session);
        }
        args[0] = servantSession;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "servant session", servantSession);
        }
        try {
            result = this.objectInvoke(function, args, sargs, stoken);
        }
        catch (InstanceNotFoundException infe) {
            Iterator stokenIt;
            FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.objectPlayer", (String)"696", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InstanceNotFoundException, servant must be dead", infe);
            }
            ConfigServiceManager.removeServantStoken(configSession, stoken);
            if (stokenSet == null) {
                stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            stokenSet.remove(stoken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failover mode");
            }
            if ((stokenIt = stokenSet.iterator()).hasNext()) {
                stoken = (String)stokenIt.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken chosen", stoken);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "we are totally out of servants I give up!");
                }
                throw new ConnectorException("Could not find a valid servant");
            }
            this.pauseForServant();
            result = this.objectPlayer(session, configSession, stoken, stokenSet, function, name, args, sargs);
        }
        catch (ConnectorException ce) {
            Iterator stokenIt;
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.objectPlayer", (String)"720", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException, servant must be dead", ce);
            }
            ConfigServiceManager.removeServantStoken(configSession, stoken);
            if (stokenSet == null) {
                stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            stokenSet.remove(stoken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failover mode");
            }
            if ((stokenIt = stokenSet.iterator()).hasNext()) {
                stoken = (String)stokenIt.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken chosen", stoken);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "we are totally out of servants I give up!");
                }
                throw new ConnectorException("Could not find a valid servant");
            }
            this.pauseForServant();
            result = this.objectPlayer(session, configSession, stoken, stokenSet, function, name, args, sargs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectPlayer", result);
        }
        return result;
    }

    private Object objectInvoke(String function, Object[] args, String[] sargs, String stoken) throws CommandNotFoundException, CommandLoadException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectInvoke", new Object[]{function, args, sargs, stoken});
        }
        Object result = null;
        HashSet<String> specified = new HashSet<String>();
        specified.add(stoken);
        Vector vec = this.getInvoker().invokeSpecifiedServants(specified, this.getObjectName(), function, args, sargs);
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)vec.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", data);
        }
        if (data == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            this.unwrapException(th);
        } else {
            result = data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expected Result", result);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectInvoke", result);
        }
        return result;
    }

    private void unwrapException(Throwable th) throws CommandNotFoundException, CommandLoadException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unwrapException", new Object[]{th});
        }
        if (th instanceof CommandLoadException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CommandLoadException - 1");
            }
            throw (CommandLoadException)th;
        }
        if (th instanceof CommandNotFoundException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "CommandNotFoundException - 1");
            }
            throw (CommandNotFoundException)th;
        }
        if (th instanceof ConnectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException");
            }
            Throwable th2 = th.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cause", th2);
            }
            if (th2 != null && th2 instanceof CommandNotFoundException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "CommandNotFoundException - 2");
                }
                throw (CommandNotFoundException)th2;
            }
            if (th2 != null && th2 instanceof CommandLoadException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "CommandLoadException - 2");
                }
                throw (CommandLoadException)th2;
            }
            if (th2 != null && th2 instanceof MBeanException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MBeanException - 1");
                }
                Throwable th3 = th2.getCause();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cause", th3);
                }
                if (th3 != null && th3 instanceof CommandNotFoundException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "CommandNotFoundException - 3");
                    }
                    throw (CommandNotFoundException)th3;
                }
                if (th3 != null && th3 instanceof CommandLoadException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "CommandLoadException - 3");
                    }
                    throw (CommandLoadException)th3;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ConnectorException - 4");
                }
                throw new ConnectorException(th3);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnectorException - 1");
            }
            throw (ConnectorException)th;
        }
        if (th instanceof InstanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant missing");
            }
            throw (InstanceNotFoundException)th;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConnectorException - 2");
        }
        throw new ConnectorException(th);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseForServant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pauseForServant - " + this.DEAD_SERVANT_WAIT + " millis");
        }
        try {
            String string = this.waitLock;
            synchronized (string) {
                this.waitLock.wait(this.DEAD_SERVANT_WAIT);
            }
        }
        catch (InterruptedException ie) {
            FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.pauseForServant", (String)"863", (Object)this);
            Tr.debug(tc, "pauseForServant - interrupted ", ie);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pauseForServant");
        }
    }

    public ArrayList processTaskParameters(TaskCommandSession session, EObjectSerializer command) throws CommandNotFoundException, CommandLoadException, ConnectorException {
        TaskCommandData newTaskCmdData;
        AbstractTaskCommand storedTaskCommand;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTaskParameters", new Object[]{session, command});
        }
        ArrayList result = null;
        String stoken = null;
        CommandMgr cmdMgr = CommandMgr.getCommandMgr();
        TaskCommandSessionMgr sessionMgr = ((ServerCommandMgr)cmdMgr).getTaskCommandSessionMgr();
        try {
            storedTaskCommand = (AbstractTaskCommand)sessionMgr.getTaskCommand(session);
            newTaskCmdData = (TaskCommandData)command.getEObjectValue();
        }
        catch (Exception ioe) {
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws390.management.proxy.RemoteCommandMgr.processTaskParameters", (String)"1108", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught", ioe);
            }
            throw new CommandLoadException(ioe);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Resetting TaskCommandData", newTaskCmdData);
        }
        storedTaskCommand.resetCommandData((CommandData)newTaskCmdData);
        String name = storedTaskCommand.getName();
        Session configSession = storedTaskCommand.getConfigSession();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Config Session ", configSession);
        }
        if (configSession != null) {
            stoken = ConfigServiceManager.getServantStoken(configSession);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stoken", stoken);
            }
            if (stoken == null) {
                stoken = this.getStoken(null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken 2", stoken);
                }
                stoken = ConfigServiceManager.addServantStoken(configSession, stoken);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken 3", stoken);
                }
            }
        }
        result = (ArrayList)this.objectPlayer(session, configSession, stoken, null, "processTaskParameters", name, new Object[]{null, command}, new String[]{"com.ibm.ws.management.cmdframework.impl.TaskCommandSession", "com.ibm.ws.management.cmdframework.impl.EObjectSerializer"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTaskParameters", new Object[]{result});
        }
        return result;
    }
}

