/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import com.ibm.ws390.management.proxy.WorkSpaceManagerMBeanProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class ConfigServiceManager
extends ProxyMBeanSupport
implements ConfigService {
    private static TraceComponent tc = Tr.register(ConfigServiceManager.class, "management", "com.ibm.ws.management.resources.configservice");
    protected static Map sessionToSR = Collections.synchronizedMap(new HashMap());
    private SortedSet currentServants = Collections.synchronizedSortedSet(new TreeSet());
    private String waitLock = "My Lock";
    private int DEAD_SERVANT_WAIT = 5000;

    public ConfigServiceManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceManager");
        }
    }

    protected static Map getSessions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessions");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessions", sessionToSR);
        }
        return sessionToSR;
    }

    public void setProperties(Session session, HashMap props) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, props});
        }
        this.voidPlayer(session, null, "setProperties", new Object[]{session, props}, new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public ValidationResult validate(Session session, ObjectName scope) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, scope});
        }
        ValidationResult result = null;
        result = (ValidationResult)this.objectPlayer(session, null, "validate", new Object[]{session, scope}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", result);
        }
        return result;
    }

    public void save(Session session, boolean overwriteOnConflict) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save", new Object[]{session, new Boolean(overwriteOnConflict)});
        }
        this.voidPlayer(session, null, "save", new Object[]{session, new Boolean(overwriteOnConflict)}, new String[]{"com.ibm.websphere.management.Session", "boolean"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", session);
        }
        this.voidPlayer(session, null, "discard", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        String key = ConfigServiceManager.getSessionKey(session);
        sessionToSR.remove(key);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", session);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        String[] result = null;
        result = (String[])this.objectPlayer(session, null, "getUnsavedChanges", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", result);
        }
        return result;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        Map result = null;
        result = (Map)this.objectPlayer(session, null, "getConflictDocuments", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", result);
        }
        return result;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        String[] result = null;
        result = (String[])this.objectPlayer("getSupportedConfigObjectTypes", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", result);
        }
        return result;
    }

    public AttributeList getAttributesMetaInfo(String configDataType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", configDataType);
        }
        AttributeList result = null;
        result = (AttributeList)this.objectPlayer("getAttributesMetaInfo", new Object[]{configDataType}, new String[]{"java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", result);
        }
        return result;
    }

    public AttributeList getRelationshipsMetaInfo(String configObjectType) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", configObjectType);
        }
        AttributeList result = null;
        result = (AttributeList)this.objectPlayer("getRelationshipsMetaInfo", new Object[]{configObjectType}, new String[]{"java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", result);
        }
        return result;
    }

    public ObjectName[] queryConfigObjects(Session session, ObjectName scope, ObjectName name, QueryExp query) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryConfigObjects", new Object[]{session, scope, name, query});
        }
        ObjectName[] result = null;
        result = (ObjectName[])this.objectPlayer(session, null, "queryConfigObjects", new Object[]{session, scope, name, query}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", result);
        }
        return result;
    }

    public ObjectName[] queryTemplates(Session session, String type) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryTemplates", new Object[]{session, type});
        }
        ObjectName[] result = null;
        result = (ObjectName[])this.objectPlayer(session, null, "queryTemplates", new Object[]{session, type}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", result);
        }
        return result;
    }

    public ObjectName[] resolve(Session session, String containmentPath) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, containmentPath});
        }
        ObjectName[] result = null;
        result = (ObjectName[])this.objectPlayer(session, null, "resolve", new Object[]{session, containmentPath}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    public ObjectName[] resolve(Session session, ObjectName scope, String containmentPath) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, containmentPath});
        }
        ObjectName[] result = null;
        result = (ObjectName[])this.objectPlayer(session, null, "resolve", new Object[]{session, scope, containmentPath}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", result);
        }
        return result;
    }

    public ObjectName createConfigDataByTemplate(Session session, ObjectName parent, String attributeName, AttributeList attrList, ObjectName template) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{session, parent, attributeName, attrList, template});
        }
        ObjectName result = null;
        result = (ObjectName)this.objectPlayer(session, null, "createConfigDataByTemplate", new Object[]{session, parent, attributeName, attrList, template}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", result);
        }
        return result;
    }

    public ObjectName createConfigData(Session session, ObjectName parent, String attributeName, String type, AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, parent, attributeName, type, attrList});
        }
        ObjectName result = null;
        result = (ObjectName)this.objectPlayer(session, null, "createConfigData", new Object[]{session, parent, attributeName, type, attrList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", result);
        }
        return result;
    }

    public void setAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, configData, attrList});
        }
        this.voidPlayer(session, null, "setAttributes", new Object[]{session, configData, attrList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void addElement(Session session, ObjectName configData, String attribute, Object element, int position) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, configData, attribute, element, new Integer(position)});
        }
        this.voidPlayer(session, null, "addElement", new Object[]{session, configData, attribute, element, new Integer(position)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    public void removeElement(Session session, ObjectName configData, String attribute, Object element) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{session, configData, attribute, element});
        }
        this.voidPlayer(session, null, "removeElement", new Object[]{session, configData, attribute, element}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    public void unsetAttributes(Session session, ObjectName configData, String[] attributes) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, configData, attributes});
        }
        this.voidPlayer(session, null, "unsetAttributes", new Object[]{session, configData, attributes}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(Session session, ObjectName configData, AttributeList attrList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, configData, attrList});
        }
        this.voidPlayer(session, null, "resetAttributes", new Object[]{session, configData, attrList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName configData, String[] attributes, boolean recursive) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)});
        }
        AttributeList result = null;
        result = (AttributeList)this.objectPlayer(session, null, "getAttributes", new Object[]{session, configData, attributes, new Boolean(recursive)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, configData, attribute});
        }
        Object result = null;
        result = this.objectPlayer(session, null, "getAttribute", new Object[]{session, configData, attribute}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", result);
        }
        return result;
    }

    public Object getAttribute(Session session, ObjectName configData, String attribute, boolean recursive) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigServiceManager.getAttribute", new Object[]{session, configData, attribute, new Boolean(recursive)});
        }
        if (recursive) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit - ConfigServiceManager.getAttribute");
            }
            return this.getAttribute(session, configData, attribute);
        }
        AttributeList attrList = this.getAttributes(session, configData, new String[]{attribute}, false);
        Object result = null;
        try {
            result = ConfigServiceHelper.getAttributeValue(attrList, attribute);
        }
        catch (AttributeNotFoundException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", (String)"39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit - ConfigServiceManager.getAttribute");
        }
        return result;
    }

    public void deleteConfigData(Session session, ObjectName configData) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, configData});
        }
        this.voidPlayer(session, null, "deleteConfigData", new Object[]{session, configData}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public AttributeList getRelationships(Session session, ObjectName configData, String[] relationshipNames) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{session, configData, relationshipNames});
        }
        AttributeList result = null;
        result = (AttributeList)this.objectPlayer(session, null, "getRelationships", new Object[]{session, configData, relationshipNames}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", result);
        }
        return result;
    }

    public ObjectName[] getRelationship(Session session, ObjectName configData, String relationship) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{session, configData, relationship});
        }
        ObjectName[] result = null;
        result = (ObjectName[])this.objectPlayer(session, null, "getRelationship", new Object[]{session, configData, relationship}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getServantStoken(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantStoken", session);
        }
        String stoken = "";
        Map map = sessionToSR;
        synchronized (map) {
            String key = ConfigServiceManager.getSessionKey(session);
            stoken = key != null && sessionToSR.containsKey(key) ? (String)sessionToSR.get(key) : null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantStoken", stoken);
        }
        return stoken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String addServantStoken(Session session, String stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServantStoken", new Object[]{session, stoken});
        }
        String key = null;
        Map map = sessionToSR;
        synchronized (map) {
            key = ConfigServiceManager.getSessionKey(session);
            if (key != null && sessionToSR.containsKey(key)) {
                stoken = (String)sessionToSR.get(key);
            } else {
                sessionToSR.put(key, stoken);
            }
        }
        WorkSpaceManagerMBeanProxy.setServantStoken(key, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServantStoken", stoken);
        }
        return stoken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeServantStoken(Session session, String stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServantStoken", new Object[]{session, stoken});
        }
        Map map = sessionToSR;
        synchronized (map) {
            String key = ConfigServiceManager.getSessionKey(session);
            if (key != null) {
                String stoken2 = (String)sessionToSR.get(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken2", stoken2);
                }
                if (stoken2 != null && stoken2.equals(stoken)) {
                    sessionToSR.remove(key);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServantStoken");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeServantStoken(String key, String stoken) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServantStoken", new Object[]{key, stoken});
        }
        Map map = sessionToSR;
        synchronized (map) {
            if (key != null) {
                String stoken2 = (String)sessionToSR.get(key);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken2", stoken2);
                }
                if (stoken2 != null && stoken2.equals(stoken)) {
                    sessionToSR.remove(key);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServantStoken");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStoken(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoken", session);
        }
        String stoken = "";
        Map map = sessionToSR;
        synchronized (map) {
            String key = ConfigServiceManager.getSessionKey(session);
            if (key != null && sessionToSR.containsKey(key)) {
                stoken = (String)sessionToSR.get(key);
            } else {
                if (this.currentServants.size() == 0) {
                    this.currentServants.addAll(super.currentServants());
                    Set currentAdjuncts = ControlAdminServiceImpl.getInstance().currentAdjuncts();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing Adjuncts Stoken", currentAdjuncts);
                    }
                    this.currentServants.removeAll(currentAdjuncts);
                }
                stoken = (String)this.currentServants.first();
                this.currentServants.remove(stoken);
                if (key != null) {
                    sessionToSR.put(key, stoken);
                    WorkSpaceManagerMBeanProxy.setServantStoken(key, stoken);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sessionToSR", sessionToSR);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStoken", stoken);
        }
        return stoken;
    }

    private static String getSessionKey(Session session) {
        String key;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionKey", session);
        }
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionKey", null);
            }
            return null;
        }
        if (session.isShareWorkspace()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shared");
            }
            key = session.getUserName();
        } else {
            key = session.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionKey", key);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String eventType = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event type", eventType);
        }
        ServantMBeanStatus status = (ServantMBeanStatus)notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", status);
        }
        if (eventType.equals("websphere.ws390.servant.terminated")) {
            String servantStoken = status.getServantStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken", servantStoken);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before Removal: ", sessionToSR);
            }
            Map map = sessionToSR;
            synchronized (map) {
                Collection values = sessionToSR.values();
                values.remove(servantStoken);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After Removal: ", sessionToSR);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    private void unwrapException(Throwable th) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unwrapException", new Object[]{th});
        }
        if (th instanceof ConfigServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConfigServiceException - 1");
            }
            throw (ConfigServiceException)th;
        }
        if (th instanceof ConnectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException");
            }
            Throwable th2 = th.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cause", th2);
            }
            if (th2 != null && th2 instanceof ConfigServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ConfigServiceException - 2");
                }
                throw (ConfigServiceException)th2;
            }
            if (th2 != null && th2 instanceof MBeanException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MBeanException - 1");
                }
                Throwable th3 = th2.getCause();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cause", th3);
                }
                if (th3 != null && th3 instanceof ConfigServiceException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "ConfigServiceException - 3");
                    }
                    throw (ConfigServiceException)th3;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnectorException - 1");
            }
            throw (ConnectorException)th;
        }
        if (th instanceof InstanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant missing");
            }
            throw (InstanceNotFoundException)th;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConnectorException - 2");
        }
        throw new ConnectorException(th);
    }

    private void voidPlayer(String function, Object[] args, String[] sargs) throws ConfigServiceException, ConnectorException {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "voidPlayer", new Object[]{function, args, sargs});
            }
            ServantMBeanInvokerData data = this.getInvoker().invokeAnyServant(this.currentServants(), this.getObjectName(), function, args, sargs);
            Object result = data.getResult();
            if (data.resultThrowable()) {
                Throwable th = (Throwable)result;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", th);
                }
                try {
                    this.unwrapException(th);
                }
                catch (InstanceNotFoundException infe) {
                    FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", (String)"755", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "InstanceNotFoundException, servant must be dead", infe);
                    }
                }
                catch (ConnectorException ce) {
                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", (String)"758", (Object)this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "ConnectorException, servant might be dead?", ce);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidPlayer");
        }
    }

    private void voidPlayer(Session session, Set stokenSet, String function, Object[] args, String[] sargs) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidPlayer", new Object[]{session, stokenSet, function, args, sargs});
        }
        String stoken = null;
        if (stokenSet == null) {
            stoken = this.getStoken(session);
        } else {
            Iterator stokenIt;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failover mode");
            }
            if ((stokenIt = stokenSet.iterator()).hasNext()) {
                stoken = (String)stokenIt.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken chosen", stoken);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "we are totally out of servants I give up!");
                }
                throw new ConnectorException("Could not find a valid servant");
            }
        }
        try {
            this.voidInvoke(function, args, sargs, stoken);
        }
        catch (InstanceNotFoundException infe) {
            FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", (String)"789", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InstanceNotFoundException, servant must be dead", infe);
            }
            ConfigServiceManager.removeServantStoken(session, stoken);
            if (stokenSet == null) {
                stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            stokenSet.remove(stoken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken Set", stokenSet);
            }
            this.pauseForServant();
            this.voidPlayer(session, stokenSet, function, args, sargs);
        }
        catch (ConnectorException ce) {
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", (String)"805", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException, servant might be dead?", ce);
            }
            ConfigServiceManager.removeServantStoken(session, stoken);
            if (stokenSet == null) {
                stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            stokenSet.remove(stoken);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken Set", stokenSet);
            }
            this.pauseForServant();
            this.voidPlayer(session, stokenSet, function, args, sargs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidPlayer");
        }
    }

    private void voidInvoke(String function, Object[] args, String[] sargs, String stoken) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidInvoke", new Object[]{function, args, sargs, stoken});
        }
        ServantMBeanInvokerData data = this.getInvoker().invokeSpecificServant(stoken, this.getObjectName(), function, args, sargs);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", data);
        }
        if (data == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            this.unwrapException(th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidInvoke");
        }
    }

    private Object objectPlayer(String function, Object[] args, String[] sargs) throws ConfigServiceException, ConnectorException {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "objectPlayer", new Object[]{function, args, sargs});
            }
            ServantMBeanInvokerData data = this.getInvoker().invokeAnyServant(this.currentServants(), this.getObjectName(), function, args, sargs);
            Object result = data.getResult();
            if (data.resultThrowable()) {
                Throwable th = (Throwable)result;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", th);
                }
                try {
                    this.unwrapException(th);
                }
                catch (InstanceNotFoundException infe) {
                    FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", (String)"875", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "InstanceNotFoundException, servant must be dead", infe);
                    }
                    break block10;
                }
                catch (ConnectorException ce) {
                    FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", (String)"878", (Object)this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ConnectorException, servant might be dead?", ce);
                    }
                    break block10;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "objectPlayer", result);
            }
            return result;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectPlayer");
        }
        throw new ConfigServiceException("No Servant available to invoke");
    }

    private Object objectPlayer(Session session, Set stokenSet, String function, Object[] args, String[] sargs) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidPlayer", new Object[]{session, stokenSet, function, args, sargs});
        }
        Object result = null;
        String stoken = null;
        if (stokenSet == null) {
            stoken = this.getStoken(session);
        } else {
            Iterator stokenIt;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failover mode");
            }
            if ((stokenIt = stokenSet.iterator()).hasNext()) {
                stoken = (String)stokenIt.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken chosen", stoken);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "we are totally out of servants I give up!");
                }
                throw new ConnectorException("Could not find a valid servant");
            }
        }
        try {
            result = this.objectInvoke(function, args, sargs, stoken);
        }
        catch (InstanceNotFoundException infe) {
            FFDCFilter.processException((Throwable)infe, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", (String)"918", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InstanceNotFoundException, servant must be dead", infe);
            }
            ConfigServiceManager.removeServantStoken(session, stoken);
            if (stokenSet == null) {
                stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            stokenSet.remove(stoken);
            this.pauseForServant();
            result = this.objectPlayer(session, stokenSet, function, args, sargs);
        }
        catch (ConnectorException ce) {
            FFDCFilter.processException((Throwable)ce, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", (String)"932", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException, servant might be dead?", ce);
            }
            ConfigServiceManager.removeServantStoken(session, stoken);
            if (stokenSet == null) {
                stokenSet = new HashSet(super.currentServants());
                stokenSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            stokenSet.remove(stoken);
            this.pauseForServant();
            result = this.objectPlayer(session, stokenSet, function, args, sargs);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidPlayer", result);
        }
        return result;
    }

    private Object objectInvoke(String function, Object[] args, String[] sargs, String stoken) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectInvoke", new Object[]{function, args, sargs, stoken});
        }
        Object result = null;
        ServantMBeanInvokerData data = this.getInvoker().invokeSpecificServant(stoken, this.getObjectName(), function, args, sargs);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", data);
        }
        if (data == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            this.unwrapException(th);
        } else {
            result = data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expected Result", result);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectInvoke", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseForServant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pauseForServant - " + this.DEAD_SERVANT_WAIT + " millis");
        }
        try {
            String string = this.waitLock;
            synchronized (string) {
                this.waitLock.wait(this.DEAD_SERVANT_WAIT);
            }
        }
        catch (InterruptedException ie) {
            FFDCFilter.processException((Throwable)ie, (String)"com.ibm.ws390.management.proxy.ConfigServiceManager.pauseForServant", (String)"989", (Object)this);
            Tr.debug(tc, "pauseForServant - interrupted");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pauseForServant");
        }
    }
}

