/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.ServantNotificationHandler;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import com.ibm.ws390.management.proxy.WorkSpaceManagerMBeanProxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class AppManagementMBeanProxy
extends ProxyMBeanSupport
implements ServantNotificationHandler,
NotificationListener {
    private static final TraceComponent tc = Tr.register(AppManagementMBeanProxy.class, null, null);
    private Map workspaces = Collections.synchronizedMap(new HashMap());
    private static final Integer WORKSPACE_EVENT_HANDBACK = new Integer(0);
    private String backupStoken = null;

    public void installApplication(String localEarPath, Hashtable properties, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installApplication", new Object[]{localEarPath, properties, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("installApplication", new Object[]{localEarPath, properties, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installApplication");
        }
    }

    public void installApplication(String localEarPath, String appName, Hashtable properties, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "installApplication", new Object[]{localEarPath, appName, properties, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("installApplication", new Object[]{localEarPath, appName, properties, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "installApplication");
        }
    }

    public void uninstallApplication(String appName, Hashtable props, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "uninstallApplication", new Object[]{appName, props, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("uninstallApplication", new Object[]{appName, props, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "uninstallApplication");
        }
    }

    public Vector getApplicationInfo(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationInfo", new Object[]{appName, prefs, workspaceID});
        }
        if (prefs == null) {
            prefs = new Hashtable();
        }
        this.setClientVersion(prefs);
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("getApplicationInfo", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        Vector vec = (Vector)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationInfo", new Object[]{vec});
        }
        return vec;
    }

    public Vector getModuleInfo(String appName, Hashtable prefs, String uniqueModuleURI, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleInfo", new Object[]{appName, prefs, uniqueModuleURI, workspaceID});
        }
        if (prefs == null) {
            prefs = new Hashtable();
        }
        this.setClientVersion(prefs);
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("getModuleInfo", new Object[]{appName, prefs, uniqueModuleURI, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String", "java.lang.String"}, stoken);
        Vector vec = (Vector)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleInfo", new Object[]{vec});
        }
        return vec;
    }

    public void setApplicationInfo(String appName, Hashtable prefs, String workspaceID, Vector tasks) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setApplicationInfo", new Object[]{appName, prefs, workspaceID, tasks});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("setApplicationInfo", new Object[]{appName, prefs, workspaceID, tasks}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String", "java.util.Vector"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setApplicationInfo");
        }
    }

    public void setModuleInfo(String appName, Hashtable prefs, String uniqueModuleURI, String workspaceID, Vector tasks) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setModuleInfo", new Object[]{appName, prefs, uniqueModuleURI, workspaceID, tasks});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("setModuleInfo", new Object[]{appName, prefs, uniqueModuleURI, workspaceID, tasks}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String", "java.lang.String", "java.util.Vector"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setModuleInfo");
        }
    }

    public void moveModule(String appName, Hashtable prefs, String uniqueModuleURI, ObjectName on, String workspaceID) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moveModule - NOOP");
        }
    }

    public void exportApplication(String appName, String pathName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "exportApplication", new Object[]{appName, pathName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("exportApplication", new Object[]{appName, pathName, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "exportApplication");
        }
    }

    public void extractDDL(String appName, String ddlPrefix, String dirName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractDDL", new Object[]{appName, ddlPrefix, dirName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("extractDDL", new Object[]{appName, ddlPrefix, dirName, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractDDL");
        }
    }

    public Vector listSystemApplications(Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSystemApplications", new Object[]{prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("listSystemApplications", new Object[]{prefs, workspaceID}, new String[]{"java.util.Hashtable", "java.lang.String"}, stoken);
        Vector vec = (Vector)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApplications", vec);
        }
        return vec;
    }

    public Vector listApplications(Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications", new Object[]{prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("listApplications", new Object[]{prefs, workspaceID}, new String[]{"java.util.Hashtable", "java.lang.String"}, stoken);
        Vector vec = (Vector)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications", vec);
        }
        return vec;
    }

    public Object listModules(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listModules", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("listModules", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listModules", result);
        }
        return result;
    }

    public Vector compareSecurityPolicy(String policyData, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "compareSecurityPolicy", new Object[]{policyData, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("compareSecurityPolicy", new Object[]{policyData, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        Vector vec = (Vector)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "compareSecurityPolicy", new Object[]{vec});
        }
        return vec;
    }

    public void installStandaloneRAR(String rarPath, Hashtable props, String workspaceID) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "installStandaloneRAR - noop - not forwarding to Servant");
        }
    }

    public boolean checkIfAppExists(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfAppExists", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("checkIfAppExists", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        Boolean res = (Boolean)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfAppExists", new Object[]{res});
        }
        return res;
    }

    public void redeployApplication(String localEarPath, String appName, Hashtable properties, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "redeployApplication", new Object[]{localEarPath, appName, properties, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("redeployApplication", new Object[]{localEarPath, appName, properties, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "redeployApplication");
        }
    }

    public void removeAllAppsFromNode(String nodeName, String cellName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromNode", new Object[]{cellName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("removeAllAppsFromNode", new Object[]{nodeName, cellName, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromNode");
        }
    }

    public void removeAllAppsFromCluster(ObjectName objectName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromCluster", new Object[]{objectName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("removeAllAppsFromCluster", new Object[]{objectName, prefs, workspaceID}, new String[]{"javax.management.ObjectName", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromCluster");
        }
    }

    public void removeAllAppsFromServer(ObjectName objectName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeAllAppsFromServer", new Object[]{objectName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("removeAllAppsFromServer", new Object[]{objectName, prefs, workspaceID}, new String[]{"javax.management.ObjectName", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeAllAppsFromServer");
        }
    }

    public void changeServerToCluster(ObjectName serverName, ObjectName clusterName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeServerToCluster", new Object[]{serverName, clusterName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("changeServerToCluster", new Object[]{serverName, clusterName, prefs, workspaceID}, new String[]{"javax.management.ObjectName", "javax.management.ObjectName", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "changeServerToCluster");
        }
    }

    public void clusterMemberAdded(ObjectName memberName, ObjectName clusterName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clusterMemberAdded", new Object[]{memberName, clusterName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("clusterMemberAdded", new Object[]{memberName, clusterName, prefs, workspaceID}, new String[]{"javax.management.ObjectName", "javax.management.ObjectName", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clusterMemberAdded");
        }
    }

    public void updateAccessIDs(String appName, Boolean bAll, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateAccessIDs", new Object[]{appName, bAll, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("updateAccessIDs", new Object[]{appName, bAll, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.Boolean", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateAccessIDs");
        }
    }

    public void deleteUserAndGroupEntries(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserAndGroupEntries", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("deleteUserAndGroupEntries", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUserAndGroupEntries");
        }
    }

    public String startApplication(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplication", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("startApplication", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        String res = (String)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startApplication", new Object[]{res});
        }
        return res;
    }

    public String startApplication(String appName, String target, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startApplication", new Object[]{appName, target, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("startApplication", new Object[]{appName, target, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        String res = (String)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startApplication", new Object[]{res});
        }
        return res;
    }

    public String stopApplication(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopApplication", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("stopApplication", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        String res = (String)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopApplication", new Object[]{res});
        }
        return res;
    }

    public String stopApplication(String appName, String target, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stopApplication", new Object[]{appName, target, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("stopApplication", new Object[]{appName, target, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        String res = (String)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stopApplication", new Object[]{res});
        }
        return res;
    }

    public void publishWSDL(String appName, String pathName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publishWSDL", new Object[]{appName, pathName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("publishWSDL", new Object[]{appName, pathName, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publishWSDL");
        }
    }

    public Hashtable searchJNDIReferences(List sList, String nodes, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchJNDIReferences", new Object[]{sList, nodes, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("searchJNDIReferences", new Object[]{sList, nodes, prefs, workspaceID}, new String[]{"java.util.List", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        Hashtable res = (Hashtable)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchJNDIReferences", new Object[]{res});
        }
        return res;
    }

    public void updateApplication(String appName, String contentURI, String pathToContents, String operation, Hashtable properties, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateApplication", new Object[]{appName, contentURI, pathToContents, operation, properties, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("updateApplication", new Object[]{appName, contentURI, pathToContents, operation, properties, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateApplication");
        }
    }

    public List listURIs(String appName, String moduleURI, Hashtable prefs, String sessionID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listURIs", new Object[]{appName, prefs, sessionID});
        }
        String stoken = this.getStoken(sessionID);
        List result = (List)this.objectInvoke("listURIs", new Object[]{appName, moduleURI, prefs, sessionID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listURIs", result);
        }
        return result;
    }

    public void updateCluster(String[] appNames, Integer timeout, Hashtable props, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "updateCluster", new Object[]{appNames, timeout, props, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.voidInvoke("updateCluster", new Object[]{appNames, timeout, props, workspaceID}, new String[]{"[Ljava.lang.String;", "java.lang.Integer", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "updateCluster");
        }
    }

    public List searchResources(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "searchResources", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("searchResources", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        List res = (List)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "searchResources", new Object[]{res});
        }
        return res;
    }

    public List convertRefToConfigID(String appName, List resources, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "convertRefToConfigID", new Object[]{appName, resources, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("convertRefToConfigID", new Object[]{appName, resources, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.List", "java.util.Hashtable", "java.lang.String"}, stoken);
        List res = (List)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "convertRefToConfigID", new Object[]{res});
        }
        return res;
    }

    public byte[] getApplicationContents(String appName, String uri, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationContents", new Object[]{appName, uri, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("getApplicationContents", new Object[]{appName, uri, prefs, workspaceID}, new String[]{"java.lang.String", "java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        byte[] res = (byte[])result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationContents", new Object[]{res});
        }
        return res;
    }

    public void getDistributionStatus(String appName, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDistributionStatus", new Object[]{appName, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        this.objectInvoke("getDistributionStatus", new Object[]{appName, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDistributionStatus");
        }
    }

    public Vector listApplications(String scope, Hashtable prefs, String workspaceID) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listApplications", new Object[]{scope, prefs, workspaceID});
        }
        String stoken = this.getStoken(workspaceID);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stoken", stoken);
        }
        Object result = this.objectInvoke("listApplications", new Object[]{scope, prefs, workspaceID}, new String[]{"java.lang.String", "java.util.Hashtable", "java.lang.String"}, stoken);
        Vector vec = (Vector)result;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listApplications", vec);
        }
        return vec;
    }

    private String getStoken(String workspaceID) throws AdminException {
        String stoken;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoken", workspaceID);
        }
        if ((stoken = (String)WorkSpaceManagerMBeanProxy.getWorkSpaces().get(workspaceID)) == null) {
            if (this.backupStoken == null) {
                if (this.currentServants().size() == 0) {
                    throw new AdminException("No Servants Available");
                }
                Iterator stokenIt = this.currentServants().iterator();
                if (stokenIt.hasNext()) {
                    this.backupStoken = (String)stokenIt.next();
                    Set currentAdjuncts = ControlAdminServiceImpl.getInstance().currentAdjuncts();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing Adjuncts Stoken", currentAdjuncts);
                    }
                    if (currentAdjuncts.contains(this.backupStoken) && stokenIt.hasNext()) {
                        this.backupStoken = (String)stokenIt.next();
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "chosen stoken", this.backupStoken);
            }
            stoken = this.backupStoken;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStoken", stoken);
        }
        return stoken;
    }

    public void handleServantNotification(Notification notification) {
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleServantNotification", new Object[]{notification});
            }
            try {
                super.sendNotification(notification);
            }
            catch (MBeanException ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.proxy.AppManagementMBeanProxy.handleServantNotification", (String)"1388", (Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "handleServantNotification exception", ex);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServantNotification");
        }
    }

    private void voidInvoke(String function, Object[] args, String[] sargs, String stoken) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidInvoke", new Object[]{function, args, sargs, stoken});
        }
        HashSet<String> specified = new HashSet<String>();
        specified.add(stoken);
        Vector vec = this.getInvoker().invokeSpecifiedServants(specified, this.getObjectName(), function, args, sargs);
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)vec.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", data);
        }
        if (data == null) {
            throw new AdminException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidInvoke");
        }
    }

    private Object objectInvoke(String function, Object[] args, String[] sargs, String stoken) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectInvoke", new Object[]{function, args, sargs, stoken});
        }
        HashSet<String> specified = new HashSet<String>();
        specified.add(stoken);
        Vector vec = this.getInvoker().invokeSpecifiedServants(specified, this.getObjectName(), function, args, sargs);
        ServantMBeanInvokerData data = (ServantMBeanInvokerData)vec.get(0);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", data);
        }
        if (data == null) {
            throw new AdminException("null ServantMBeanInvokerData returned from Servant");
        }
        if (data.resultThrowable()) {
            Throwable th = (Throwable)data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", th);
            }
            if (th instanceof AdminException) {
                throw (AdminException)th;
            }
            throw new AdminException(th);
        }
        Object result = data.getResult();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Expected Result", result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectInvoke", result);
        }
        return result;
    }

    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String eventType = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event type", eventType);
        }
        ServantMBeanStatus status = (ServantMBeanStatus)notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", status);
        }
        if (eventType.equals("websphere.ws390.servant.terminated")) {
            String servantStoken = status.getServantStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken", servantStoken);
            }
            if (servantStoken.equals(this.backupStoken)) {
                this.backupStoken = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    public void setClientVersion(Hashtable prefs) {
        JMXVersionValidation versionValidation;
        String version;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setClientVersion");
        }
        if (AdminHelper.getPlatformHelper().isZOS() && AdminHelper.getPlatformHelper().isControlJvm() && (version = (versionValidation = new JMXVersionValidation()).getClientVersion()) != null) {
            prefs.put("REQUEST_CLIENT_VERSION", version);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Set REQUEST_CLIENT_VERSION to " + version);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setClientVersion");
        }
    }
}

