/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.connector.corba;

import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws390.management.connector.corba.CorbaConnectorPackage.ServerExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JavaObjectSerializer {
    private JavaObjectSerializer() {
    }

    public static byte[] getByteArray(Object object) throws IOException {
        byte[] byteArray = new byte[]{};
        if (object != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(bos);
            objectOut.writeObject(object);
            byteArray = bos.toByteArray();
        }
        return byteArray;
    }

    public static Object getObject(byte[] bytes) throws IOException, ClassNotFoundException {
        Object object = null;
        if (bytes != null && bytes.length > 0) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            WsObjectInputStream objectIn = new WsObjectInputStream((InputStream)bis);
            object = objectIn.readObject();
        }
        return object;
    }

    public static ServerExceptionWrapper getExceptionWrapper(Throwable throwable) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream objectOut = new ObjectOutputStream(bos);
        objectOut.writeObject(throwable);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        ServerExceptionWrapper wrapper = new ServerExceptionWrapper(bos.toByteArray(), sw.toString());
        return wrapper;
    }

    public static Throwable getException(ServerExceptionWrapper wrapper) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(wrapper.exceptionData);
        WsObjectInputStream objectIn = new WsObjectInputStream((InputStream)bis);
        Throwable t = (Throwable)objectIn.readObject();
        return t;
    }

    public static String getStackTrace(ServerExceptionWrapper wrapper) {
        return wrapper.stacktrace;
    }
}

