/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.connector.corba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteReceiver;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws390.management.NotAControllerException;
import com.ibm.ws390.management.connector.corba.CorbaConnector;
import com.ibm.ws390.management.connector.corba.CorbaConnectorImpl;
import com.ibm.ws390.management.connector.corba.CorbaConnectorPackage.ServerExceptionWrapper;
import com.ibm.ws390.management.connector.corba.JavaObjectSerializer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class CorbaConnectorClient
implements AdminServiceProxy {
    private static TraceComponent tc = Tr.register(CorbaConnectorClient.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private RMINotificationListener rmiListener = null;
    private Properties proxyProps = null;
    public static final String CONNECTOR_TYPE_CORBA = "CORBA";
    public static final String CONNECTOR_SERVANT = "servant";
    public static final String CONNECTOR_IOR = "ior";
    private String servantStoken = null;
    private String iorString = null;
    private CorbaConnector connector = null;

    public CorbaConnectorClient(Properties props) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", props);
        }
        this.servantStoken = props.getProperty(CONNECTOR_SERVANT);
        if (this.servantStoken == null) {
            this.iorString = props.getProperty(CONNECTOR_IOR);
            if (this.iorString != null) {
                this.iorString.trim();
            }
            if (this.iorString == null || this.iorString.length() == 0) {
                throw new ConnectorException("Servant stoken nor IOR specified");
            }
        } else {
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                NotAControllerException ex = new NotAControllerException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Throwing NotAControllerException", ex);
                }
                throw ex;
            }
            this.servantStoken = this.servantStoken.trim();
            if (this.servantStoken.length() == 0) {
                throw new ConnectorException("Servant stoken nor IOR specified");
            }
        }
        this.proxyProps = new Properties();
        this.proxyProps.setProperty("type", CONNECTOR_TYPE_CORBA);
        if (this.servantStoken == null) {
            this.proxyProps.setProperty(CONNECTOR_IOR, this.iorString);
        } else {
            this.proxyProps.setProperty(CONNECTOR_SERVANT, this.servantStoken);
        }
        this.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public CorbaConnector getCorbaConnector() {
        return this.connector;
    }

    public String getType() {
        return CONNECTOR_TYPE_CORBA;
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public void reconnect() throws ConnectorNotAvailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this.connector = null;
        if (this.servantStoken == null) {
            this.connector = AdminServiceImpl.getPlatformUtils().getConnectorStub(this.iorString);
        } else {
            Iterator aggregator;
            char[] tokenChars = this.servantStoken.toUpperCase().toCharArray();
            byte[] binaryStoken = new byte[tokenChars.length / 2];
            for (int i = 0; i < binaryStoken.length; ++i) {
                binaryStoken[i] = tokenChars[i * 2] >= '0' && tokenChars[i * 2] <= '9' ? (byte)((tokenChars[i * 2] - 48) * 16) : (byte)((tokenChars[i * 2] - 65 + 10) * 16);
                if (tokenChars[i * 2 + 1] >= '0' && tokenChars[i * 2 + 1] <= '9') {
                    int n = i;
                    binaryStoken[n] = (byte)(binaryStoken[n] + (tokenChars[i * 2 + 1] - 48));
                    continue;
                }
                int n = i;
                binaryStoken[n] = (byte)(binaryStoken[n] + (tokenChars[i * 2 + 1] - 65 + 10));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "binary stoken", binaryStoken);
            }
            if ((aggregator = AdminServiceImpl.getPlatformUtils().getSRAggregator((Object)new CorbaConnectorImpl(), false, binaryStoken)).hasNext()) {
                this.connector = (CorbaConnector)aggregator.next();
            }
        }
        if (this.connector == null) {
            ConnectorNotAvailableException ex = new ConnectorNotAvailableException("Nonexistant stoken/IOR");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "throwing exception", ex);
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy proxy) {
        PushRemoteReceiver rr;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "openRemoteNotificationChannel", proxy);
            }
            rr = new PushRemoteReceiver(proxy);
            try {
                this.rmiListener = (RMINotificationListener)PortableRemoteObject.toStub((Remote)new RMINotificationListenerService(rr));
                ((Stub)this.rmiListener).connect(ORB.init((String[])new String[0], null));
            }
            catch (RemoteException exc) {
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.openRemoteNotificationChannel", (String)"322", (java.lang.Object)this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error creating RMI stub", exc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openRemoteNotificationChannel", rr);
        }
        return rr;
    }

    public Session isAlive(int timeout) throws ConnectorException {
        return this.isAlive();
    }

    public Session isAlive() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlive");
        }
        Session session = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking isAlive");
            }
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            byte[] sessionBytes = this.connector.isAlive(propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (sessionBytes != null && sessionBytes.length > 0) {
                session = (Session)JavaObjectSerializer.getObject(sessionBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isAlive", (String)"360", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isAlive", (String)"366", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlive", session);
        }
        return session;
    }

    public ObjectInstance createMBean(String className, ObjectName name) throws ConnectorException, InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBean", new java.lang.Object[]{className, name});
        }
        ObjectInstance returnObjectInstance = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            byte[] returnObjectBytes = this.connector.createMBean(className, objectNameBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnObjectBytes != null && returnObjectBytes.length > 0) {
                returnObjectInstance = (ObjectInstance)JavaObjectSerializer.getObject(returnObjectBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.createMBean", (String)"426", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)ex;
            }
            if (ex instanceof MBeanException) {
                throw (MBeanException)ex;
            }
            if (ex instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)ex;
            }
            if (ex instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.createMBean", (String)"443", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", returnObjectInstance);
        }
        return returnObjectInstance;
    }

    public Set queryNames(ObjectName name, QueryExp query) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames", name);
        }
        Set set = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] queryBytes = JavaObjectSerializer.getByteArray(query);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] setBytes = this.connector.queryNames(objectNameBytes, queryBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (setBytes != null && setBytes.length > 0) {
                set = (Set)JavaObjectSerializer.getObject(setBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryNames", (String)"498", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryNames", (String)"504", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames", set);
        }
        return set;
    }

    public java.lang.Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, ConnectorException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            java.lang.Object[] params = new java.lang.Object[]{name, attribute};
            Tr.entry(tc, "getAttribute", params);
        }
        java.lang.Object returnObject = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] returnObjectBytes = this.connector.getAttribute(objectNameBytes, attribute, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnObjectBytes != null && returnObjectBytes.length > 0) {
                returnObject = JavaObjectSerializer.getObject(returnObjectBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttribute", (String)"562", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)ex;
            }
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof MBeanException) {
                throw (MBeanException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttribute", (String)"577", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", returnObject);
        }
        return returnObject;
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws ConnectorException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", name);
        }
        AttributeList attrList = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] attributeBytes = JavaObjectSerializer.getByteArray(attributes);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] attrListBytes = this.connector.getAttributes(objectNameBytes, attributeBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (attrListBytes != null && attrListBytes.length > 0) {
                attrList = (AttributeList)JavaObjectSerializer.getObject(attrListBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttributes", (String)"632", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttributes", (String)"643", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attrList);
        }
        return attrList;
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws AttributeNotFoundException, ConnectorException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute", name);
        }
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] attributeBytes = JavaObjectSerializer.getByteArray(attribute);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.setAttribute(objectNameBytes, attributeBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttribute", (String)"694", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)ex;
            }
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)ex;
            }
            if (ex instanceof MBeanException) {
                throw (MBeanException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttribute", (String)"711", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws ConnectorException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", name);
        }
        AttributeList returnAttrList = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] attributeBytes = JavaObjectSerializer.getByteArray(attributes);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] returnAttrListBytes = this.connector.setAttributes(objectNameBytes, attributeBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnAttrListBytes != null && returnAttrListBytes.length > 0) {
                returnAttrList = (AttributeList)JavaObjectSerializer.getObject(returnAttrListBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttributes", (String)"764", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttributes", (String)"775", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", returnAttrList);
        }
        return returnAttrList;
    }

    public java.lang.Object invoke(ObjectName name, String operationName, java.lang.Object[] params, String[] signature) throws ConnectorException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", name);
        }
        java.lang.Object returnObject = null;
        try {
            String[] sig;
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] paramBytes = new byte[]{};
            if (params != null && params.length > 0) {
                paramBytes = JavaObjectSerializer.getByteArray(params);
            }
            if ((sig = signature) == null) {
                sig = new String[]{};
            }
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] returnBytes = this.connector.invoke(objectNameBytes, operationName, paramBytes, sig, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnBytes != null && returnBytes.length > 0) {
                returnObject = JavaObjectSerializer.getObject(returnBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.invoke", (String)"843", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof MBeanException) {
                throw (MBeanException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.invoke", (String)"856", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", returnObject);
        }
        return returnObject;
    }

    public String getDefaultDomain() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        String defaultDomainName = null;
        try {
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            defaultDomainName = this.connector.getDefaultDomain(propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getDefaultDomain", (String)"894", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain", defaultDomainName);
        }
        return defaultDomainName;
    }

    public String getDomainName() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainName");
        }
        String domainName = null;
        try {
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            domainName = this.connector.getDomainName(propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getDomainName", (String)"930", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainName", domainName);
        }
        return domainName;
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        Integer beanCount = null;
        try {
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] beanCountBytes = this.connector.getMBeanCount(propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (beanCountBytes != null && beanCountBytes.length > 0) {
                beanCount = (Integer)JavaObjectSerializer.getObject(beanCountBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanCount", (String)"969", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanCount", (String)"975", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount", beanCount);
        }
        return beanCount;
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws ConnectorException, IntrospectionException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanInfo", name);
        }
        MBeanInfo mbeanInfo = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] mbeanInfoBytes = this.connector.getMBeanInfo(objectNameBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (mbeanInfoBytes != null && mbeanInfoBytes.length > 0) {
                mbeanInfo = (MBeanInfo)JavaObjectSerializer.getObject(mbeanInfoBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanInfo", (String)"1027", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof IntrospectionException) {
                throw (IntrospectionException)ex;
            }
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            if (ex instanceof ReflectionException) {
                throw (ReflectionException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanInfo", (String)"1040", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanInfo", mbeanInfo);
        }
        return mbeanInfo;
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerMBean");
        }
        ObjectName name = null;
        try {
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] nameBytes = this.connector.getServerMBean(propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (nameBytes != null && nameBytes.length > 0) {
                name = (ObjectName)JavaObjectSerializer.getObject(nameBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getServerMBean", (String)"1081", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getServerMBean", (String)"1087", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerMBean", name);
        }
        return name;
    }

    public boolean isRegistered(ObjectName name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered", name);
        }
        boolean registered = false;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            registered = this.connector.isRegistered(objectNameBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isRegistered", (String)"1129", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isRegistered", (String)"1135", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered", new Boolean(registered));
        }
        return registered;
    }

    public boolean isInstanceOf(ObjectName name, String className) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf", name);
        }
        boolean instance = false;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            instance = this.connector.isInstanceOf(objectNameBytes, className, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isInstanceOf", (String)"1181", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isInstanceOf", (String)"1190", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf", new Boolean(instance));
        }
        return instance;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter filter, PushNotificationListener listener) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", listener);
        }
        ListenerIdentifier listenerId = null;
        try {
            byte[] filterBytes = JavaObjectSerializer.getByteArray(filter);
            byte[] listenerBytes = JavaObjectSerializer.getByteArray(listener);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] listenerIdBytes = this.connector.addRMINotificationListener(filterBytes, listenerBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (listenerIdBytes != null && listenerIdBytes.length > 0) {
                listenerId = (ListenerIdentifier)JavaObjectSerializer.getObject(listenerIdBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", (String)"1238", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", (String)"1244", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", listenerId);
        }
        return listenerId;
    }

    public void removeNotificationListener(ListenerIdentifier listenerId) throws ConnectorException, ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", listenerId);
        }
        try {
            byte[] listenerIdBytes = JavaObjectSerializer.getByteArray(listenerId);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.removeNotificationListener(listenerIdBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", (String)"1287", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof ReceiverNotFoundException) {
                throw (ReceiverNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", (String)"1296", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void resetFilter(ListenerIdentifier listenerId, ConsolidatedFilter filter) throws ConnectorException, ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", listenerId);
        }
        try {
            byte[] listenerIdBytes = JavaObjectSerializer.getByteArray(listenerId);
            byte[] filterBytes = JavaObjectSerializer.getByteArray(filter);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.resetFilter(listenerIdBytes, filterBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.resetFilter", (String)"1340", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof ReceiverNotFoundException) {
                throw (ReceiverNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.resetFilter", (String)"1349", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerId, Integer batchSize) throws ConnectorException, ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", listenerId);
        }
        Notification[] notifications = null;
        try {
            byte[] listenerIdBytes = JavaObjectSerializer.getByteArray(listenerId);
            byte[] batchSizeBytes = JavaObjectSerializer.getByteArray(batchSize);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] notificationBytes = this.connector.pullNotifications(listenerIdBytes, batchSizeBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (notificationBytes != null && notificationBytes.length > 0) {
                notifications = (Notification[])JavaObjectSerializer.getObject(notificationBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.pullNotifications", (String)"1399", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof ReceiverNotFoundException) {
                throw (ReceiverNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.pullNotifications", (String)"1408", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullNotifications", notifications);
        }
        return notifications;
    }

    private Exception getRemoteException(ServerExceptionWrapper tWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteException", (java.lang.Object)tWrapper);
        }
        if (tc.isDebugEnabled()) {
            String stackTrace = JavaObjectSerializer.getStackTrace(tWrapper);
            Tr.debug(tc, "Remote exception or error", stackTrace);
        }
        Exception exception = null;
        try {
            Throwable t = JavaObjectSerializer.getException(tWrapper);
            exception = t instanceof AttributeNotFoundException || t instanceof InstanceNotFoundException || t instanceof InvalidAttributeValueException || t instanceof MBeanException || t instanceof ReceiverNotFoundException || t instanceof ReflectionException ? (Exception)t : new ConnectorException("Remote exception received", t);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getRemoteException", (String)"1469", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nested connector error", ex);
            }
            exception = new ConnectorException("Controller local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteException", exception);
        }
        return exception;
    }

    public Set queryMBeans(ObjectName name, QueryExp query) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans", name);
        }
        Set set = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] queryBytes = JavaObjectSerializer.getByteArray(query);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] setBytes = this.connector.queryMBeans(objectNameBytes, queryBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (setBytes != null && setBytes.length > 0) {
                set = (Set)JavaObjectSerializer.getObject(setBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryMBeans", (String)"538", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryMBeans", (String)"544", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans", set);
        }
        return set;
    }

    public ClassLoader getClassLoaderFor(ObjectName name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor", name);
        }
        ClassLoader returnObject = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] returnObjectBytes = this.connector.getClassLoaderFor(objectNameBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnObjectBytes != null && returnObjectBytes.length > 0) {
                returnObject = (ClassLoader)JavaObjectSerializer.getObject(returnObjectBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoaderFor", (String)"1550", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoaderFor", (String)"1557", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor", returnObject);
        }
        return returnObject;
    }

    public ClassLoader getClassLoader(ObjectName name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader", name);
        }
        ClassLoader returnObject = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] returnObjectBytes = this.connector.getClassLoader(objectNameBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnObjectBytes != null && returnObjectBytes.length > 0) {
                returnObject = (ClassLoader)JavaObjectSerializer.getObject(returnObjectBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoader", (String)"1597", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoader", (String)"1604", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader", returnObject);
        }
        return returnObject;
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", name);
        }
        ObjectInstance returnObjectInstance = null;
        try {
            byte[] objectNameBytes = JavaObjectSerializer.getByteArray(name);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] returnObjectBytes = this.connector.getObjectInstance(objectNameBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnObjectBytes != null && returnObjectBytes.length > 0) {
                returnObjectInstance = (ObjectInstance)JavaObjectSerializer.getObject(returnObjectBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getObjectInstance", (String)"1545", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getObjectInstance", (String)"1190", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance", returnObjectInstance);
        }
        return returnObjectInstance;
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, java.lang.Object handback) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new java.lang.Object[]{name, listener});
        }
        try {
            byte[] nameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] listenerBytes = JavaObjectSerializer.getByteArray(listener);
            byte[] filterBytes = JavaObjectSerializer.getByteArray(filter);
            byte[] handbackBytes = JavaObjectSerializer.getByteArray(handback);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.addNotificationListener(nameBytes, listenerBytes, filterBytes, handbackBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", (String)"1587", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", (String)"1593", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener2", new java.lang.Object[]{name, listener});
        }
        try {
            byte[] nameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] listenerBytes = JavaObjectSerializer.getByteArray(listener);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.removeNotificationListener_2(nameBytes, listenerBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", (String)"1623", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw new ConnectorException("Local exception", ex);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", (String)"11632", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener2");
        }
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, java.lang.Object handback) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener4", new java.lang.Object[]{name, listener, filter, handback});
        }
        try {
            byte[] nameBytes = JavaObjectSerializer.getByteArray(name);
            byte[] listenerBytes = JavaObjectSerializer.getByteArray(listener);
            byte[] filterBytes = JavaObjectSerializer.getByteArray(filter);
            byte[] handbackBytes = JavaObjectSerializer.getByteArray(handback);
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.removeNotificationListener_4(nameBytes, listenerBytes, filterBytes, handbackBytes, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", (String)"1623", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            throw new ConnectorException("Local exception", ex);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", (String)"1632", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", ex);
            }
            throw new ConnectorException("Local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener4");
        }
    }
}

