/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws390.management.NotAControllerException;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import com.ibm.ws390.management.connector.corba.CorbaConnector;
import com.ibm.ws390.management.connector.corba.CorbaConnectorImpl;
import com.ibm.ws390.management.connector.corba.CorbaConnectorPackage.ServerExceptionWrapper;
import com.ibm.ws390.management.connector.corba.JavaObjectSerializer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;
import org.omg.CORBA.Object;

public class ServantMBeanInvoker {
    private Iterator aggregator = null;
    private Random randomNumber = new Random();
    private static TraceComponent tc = Tr.register(ServantMBeanInvoker.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private ControlAdminServiceImpl controlAdmin = ControlAdminServiceImpl.getInstance();

    public ServantMBeanInvoker() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (!AdminHelper.getPlatformHelper().isControlJvm()) {
            NotAControllerException ex = new NotAControllerException();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Throwing NotAControllerException", ex);
            }
            throw ex;
        }
        this.aggregator = AdminServiceImpl.getPlatformUtils().getSRAggregator((Object)new CorbaConnectorImpl(), true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public void refresh() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        AdminServiceImpl.getPlatformUtils().refreshSRAggregator(this.aggregator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    public boolean hasNext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNext");
        }
        boolean hasNext = this.aggregator.hasNext();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNext", new Boolean(hasNext));
        }
        return hasNext;
    }

    public java.lang.Object invokeNext(String mbeanType, String operationName, java.lang.Object[] params, String[] signature) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeNext", mbeanType);
        }
        CorbaConnector connector2 = (CorbaConnector)this.aggregator.next();
        java.lang.Object returnObject = null;
        try {
            String[] sig;
            byte[] paramBytes = new byte[]{};
            if (params != null && params.length > 0) {
                paramBytes = JavaObjectSerializer.getByteArray(params);
            }
            if ((sig = signature) == null) {
                sig = new String[]{};
            }
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector", mbeanType);
            }
            byte[] returnBytes = connector2.invokeType(mbeanType, operationName, paramBytes, sig, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnBytes != null && returnBytes.length > 0) {
                returnObject = JavaObjectSerializer.getObject(returnBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeNext", (String)"286", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeNext", (String)"296", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Controller local exception", ex);
            }
            throw new ConnectorException("Controller local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeNext", returnObject);
        }
        return returnObject;
    }

    public java.lang.Object invokeSpecific(String stoken, String mbeanType, String operationName, java.lang.Object[] params, String[] signature) throws InstanceNotFoundException, ConnectorException {
        Hashtable connectors;
        CorbaConnector connector2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeSpecific", new java.lang.Object[]{stoken, mbeanType});
        }
        if ((connector2 = (CorbaConnector)(connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator)).get(stoken)) == null) {
            throw new InstanceNotFoundException(stoken);
        }
        java.lang.Object returnObject = null;
        try {
            String[] sig;
            byte[] paramBytes = new byte[]{};
            if (params != null && params.length > 0) {
                paramBytes = JavaObjectSerializer.getByteArray(params);
            }
            if ((sig = signature) == null) {
                sig = new String[]{};
            }
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector", mbeanType);
            }
            byte[] returnBytes = connector2.invokeType(mbeanType, operationName, paramBytes, sig, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnBytes != null && returnBytes.length > 0) {
                returnObject = JavaObjectSerializer.getObject(returnBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeSpecific", (String)"394", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeSpecific", (String)"404", (java.lang.Object)this);
            ex.printStackTrace();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Controller local exception", ex);
            }
            throw new ConnectorException("Controller local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeSpecific", returnObject);
        }
        return returnObject;
    }

    public ServantMBeanInvokerData invokeSpecificServant(String stoken, ObjectName mbeanObjectName, String operationName, java.lang.Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeSpecificServant", new java.lang.Object[]{stoken, mbeanObjectName, operationName, params, signature});
        }
        HashSet<String> servants = new HashSet<String>(2);
        servants.add(stoken);
        ServantMBeanInvokerData data = this.invokeAnyServant(servants, mbeanObjectName, operationName, params, signature);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeSpecificServant", data);
        }
        return data;
    }

    public java.lang.Object invokeNext(String mbeanType, String mbeanName, String operationName, java.lang.Object[] params, String[] signature) throws InstanceNotFoundException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeNext", new java.lang.Object[]{mbeanType, mbeanName});
        }
        CorbaConnector connector2 = (CorbaConnector)this.aggregator.next();
        java.lang.Object returnObject = null;
        try {
            String[] sig;
            byte[] paramBytes = new byte[]{};
            if (params != null && params.length > 0) {
                paramBytes = JavaObjectSerializer.getByteArray(params);
            }
            if ((sig = signature) == null) {
                sig = new String[]{};
            }
            String profileKey = AdminContext.peek();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using profile Key: " + profileKey);
            }
            Properties props = new Properties();
            if (profileKey != null) {
                props.setProperty("profile.key", profileKey);
            }
            byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector", mbeanType);
            }
            byte[] returnBytes = connector2.invokeTypeName(mbeanType, mbeanName, operationName, paramBytes, sig, propertiesBytes);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (returnBytes != null && returnBytes.length > 0) {
                returnObject = JavaObjectSerializer.getObject(returnBytes);
            }
        }
        catch (ServerExceptionWrapper tWrapper) {
            FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeNext", (String)"550", (java.lang.Object)this);
            Exception ex = this.getRemoteException(tWrapper);
            if (ex instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)ex;
            }
            throw (ConnectorException)ex;
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeNext", (String)"560", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Controller local exception", ex);
            }
            throw new ConnectorException("Controller local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeNext", returnObject);
        }
        return returnObject;
    }

    public Vector invokeSpecifiedServants(HashSet specifiedServants, ObjectName mbeanObjectName, String mbeanType, String mbeanName, String operationName, java.lang.Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeSpecifiedServants", new java.lang.Object[]{specifiedServants, mbeanObjectName, mbeanType, mbeanName, operationName, params});
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        Iterator iterator = specifiedServants.iterator();
        Vector<ServantMBeanInvokerData> results = new Vector<ServantMBeanInvokerData>(specifiedServants.size());
        while (iterator.hasNext()) {
            String currentServantStoken = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            ServantMBeanInvokerData data = this.invokeServantMBean(currentServantStoken, currentConnector, mbeanObjectName, mbeanType, mbeanName, operationName, params, signature);
            results.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeSpecifiedServants", results);
        }
        return results;
    }

    public Vector invokeSpecifiedServants(Set specifiedServants, ObjectName mbeanObjectName, String operationName, java.lang.Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeSpecifiedServants", new java.lang.Object[]{specifiedServants, mbeanObjectName, operationName, params, signature});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "params", params);
            Tr.debug(tc, "signature", signature);
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        Vector servantStokens = this.getServantStokenVector(specifiedServants);
        Vector<ServantMBeanInvokerData> results = new Vector<ServantMBeanInvokerData>(specifiedServants.size());
        for (int i = 0; i < servantStokens.size(); ++i) {
            String currentServantStoken = (String)servantStokens.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            ServantMBeanInvokerData data = this.invokeServantMBean(currentServantStoken, currentConnector, mbeanObjectName, operationName, params, signature);
            results.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeSpecifiedServants", results);
        }
        return results;
    }

    public ServantMBeanInvokerData invokeAnyServant(Set specifiedServants, ObjectName mbeanObjectName, String operationName, java.lang.Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeAnyServant", new java.lang.Object[]{specifiedServants, mbeanObjectName, operationName, params, signature});
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "params", params);
            Tr.debug(tc, "signature", signature);
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        boolean random = Boolean.getBoolean("com.ibm.websphere.management.jmx.random");
        Vector servantStokens = null;
        if (random) {
            servantStokens = this.buildRandomServantStokenVector(specifiedServants);
            this.putAdjunctsLast(servantStokens);
        } else {
            servantStokens = this.getServantStokenVector(specifiedServants);
            this.putAdjunctsLast(servantStokens);
        }
        ServantMBeanInvokerData data = null;
        boolean goodResult = false;
        for (int i = 0; i < servantStokens.size() && !goodResult; ++i) {
            String currentServantStoken = (String)servantStokens.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            data = this.invokeServantMBean(currentServantStoken, currentConnector, mbeanObjectName, operationName, params, signature);
            java.lang.Object result = data.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "result", result);
            }
            if (result == null) {
                goodResult = true;
                continue;
            }
            if (result instanceof Throwable) {
                Throwable throwable = (Throwable)result;
                while (!goodResult && throwable != null) {
                    if (throwable instanceof MBeanException || throwable instanceof RuntimeMBeanException) {
                        goodResult = true;
                        continue;
                    }
                    throwable = throwable.getCause();
                }
                continue;
            }
            goodResult = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeAnyServant", data);
        }
        return data;
    }

    private ServantMBeanInvokerData invokeServantMBean(String servantStoken, CorbaConnector connector2, ObjectName mbeanObjectName, String mbeanType, String mbeanName, String operationName, java.lang.Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeServantMBean", new java.lang.Object[]{servantStoken, connector2});
        }
        java.lang.Object result = null;
        if (connector2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No connector for servant", servantStoken);
            }
            result = new InstanceNotFoundException("Non-existant servant" + servantStoken);
        } else {
            try {
                String[] sig;
                byte[] paramBytes = new byte[]{};
                if (params != null && params.length > 0) {
                    paramBytes = JavaObjectSerializer.getByteArray(params);
                }
                if ((sig = signature) == null) {
                    sig = new String[]{};
                }
                String profileKey = AdminContext.peek();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using profile Key: " + profileKey);
                }
                Properties props = new Properties();
                if (profileKey != null) {
                    props.setProperty("profile.key", profileKey);
                }
                byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking JMX connector", new java.lang.Object[]{servantStoken, mbeanType, mbeanName, operationName});
                }
                byte[] returnBytes = connector2.invokeTypeName(mbeanType, mbeanName, operationName, paramBytes, sig, propertiesBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from JMX connector", servantStoken);
                }
                if (returnBytes != null && returnBytes.length > 0) {
                    result = JavaObjectSerializer.getObject(returnBytes);
                }
            }
            catch (ServerExceptionWrapper tWrapper) {
                FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeServantMBean", (String)"951", (java.lang.Object)this);
                result = this.getRemoteException(tWrapper);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeServantMBean", (String)"957", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller local exception", ex);
                }
                result = new ConnectorException("Controller local exception", ex);
            }
        }
        ServantMBeanInvokerData data = new ServantMBeanInvokerData(servantStoken, result, mbeanObjectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeServantMBean", data);
        }
        return data;
    }

    private ServantMBeanInvokerData invokeServantMBean(String servantStoken, CorbaConnector connector2, ObjectName mbeanObjectName, String operationName, java.lang.Object[] params, String[] signature) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invokeServantMBean", new java.lang.Object[]{servantStoken, connector2});
        }
        java.lang.Object result = null;
        if (connector2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No connector for servant", servantStoken);
            }
            result = new InstanceNotFoundException("Non-existant servant" + servantStoken);
        } else if (mbeanObjectName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean ObjectName is null");
            }
            result = new IllegalArgumentException("MBean object name is null");
        } else {
            try {
                String[] sig;
                byte[] objectNameBytes = JavaObjectSerializer.getByteArray(mbeanObjectName);
                byte[] paramBytes = new byte[]{};
                if (params != null && params.length > 0) {
                    paramBytes = JavaObjectSerializer.getByteArray(params);
                }
                if ((sig = signature) == null) {
                    sig = new String[]{};
                }
                String profileKey = AdminContext.peek();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using profile Key: " + profileKey);
                }
                Properties props = new Properties();
                if (profileKey != null) {
                    props.setProperty("profile.key", profileKey);
                }
                byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking JMX connector", new java.lang.Object[]{servantStoken, mbeanObjectName, operationName});
                }
                byte[] returnBytes = connector2.invoke(objectNameBytes, operationName, paramBytes, sig, propertiesBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from JMX connector", servantStoken);
                }
                if (returnBytes != null && returnBytes.length > 0) {
                    result = JavaObjectSerializer.getObject(returnBytes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returned result", result);
                }
            }
            catch (ServerExceptionWrapper tWrapper) {
                FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeServantMBean", (String)"1067", (java.lang.Object)this);
                result = this.getRemoteException(tWrapper);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.invokeServantMBean", (String)"1073", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller local exception", ex);
                }
                result = new ConnectorException("Controller local exception", ex);
            }
        }
        ServantMBeanInvokerData data = new ServantMBeanInvokerData(servantStoken, result, mbeanObjectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invokeServantMBean", data);
        }
        return data;
    }

    public Vector getSpecifiedServantsMBeanAttribute(HashSet specifiedServants, ObjectName mbeanObjectName, String mbeanType, String mbeanName, String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecifiedServantsMBeanAttribute", new java.lang.Object[]{specifiedServants, mbeanObjectName, mbeanType, mbeanName, attributeName});
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        Iterator iterator = specifiedServants.iterator();
        Vector<ServantMBeanInvokerData> results = new Vector<ServantMBeanInvokerData>(specifiedServants.size());
        while (iterator.hasNext()) {
            String currentServantStoken = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            ServantMBeanInvokerData data = this.getServantMBeanAttribute(currentServantStoken, currentConnector, mbeanObjectName, mbeanType, mbeanName, attributeName);
            results.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpecifiedServantsMBeanAttribute", results);
        }
        return results;
    }

    public Vector getSpecifiedServantsMBeanAttribute(Set specifiedServants, ObjectName mbeanObjectName, String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSpecifiedServantsMBeanAttribute", new java.lang.Object[]{specifiedServants, mbeanObjectName, attributeName});
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        Vector servantStokens = this.getServantStokenVector(specifiedServants);
        Vector<ServantMBeanInvokerData> results = new Vector<ServantMBeanInvokerData>(specifiedServants.size());
        for (int i = 0; i < servantStokens.size(); ++i) {
            String currentServantStoken = (String)servantStokens.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            ServantMBeanInvokerData data = this.getServantMBeanAttribute(currentServantStoken, currentConnector, mbeanObjectName, attributeName);
            results.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSpecifiedServantsMBeanAttribute", results);
        }
        return results;
    }

    public ServantMBeanInvokerData getAnyServantMBeanAttribute(Set specifiedServants, ObjectName mbeanObjectName, String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAnyServantMBeanAttribute", new java.lang.Object[]{specifiedServants, mbeanObjectName, attributeName});
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        boolean random = Boolean.getBoolean("com.ibm.websphere.management.jmx.random");
        Vector servantStokens = null;
        if (random) {
            servantStokens = this.buildRandomServantStokenVector(specifiedServants);
            this.putAdjunctsLast(servantStokens);
        } else {
            servantStokens = this.getServantStokenVector(specifiedServants);
            this.putAdjunctsLast(servantStokens);
        }
        ServantMBeanInvokerData data = null;
        boolean goodResult = false;
        for (int i = 0; i < servantStokens.size() && !goodResult; ++i) {
            CorbaConnector currentConnector;
            String currentServantStoken = (String)servantStokens.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            if ((data = this.getServantMBeanAttribute(currentServantStoken, currentConnector = (CorbaConnector)connectors.get(currentServantStoken), mbeanObjectName, attributeName)).resultThrowable()) continue;
            goodResult = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAnyServantMBeanAttribute", data);
        }
        return data;
    }

    private ServantMBeanInvokerData getServantMBeanAttribute(String servantStoken, CorbaConnector connector2, ObjectName mbeanObjectName, String mbeanType, String mbeanName, String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantMBeanAttribute", new java.lang.Object[]{servantStoken, connector2});
        }
        java.lang.Object result = null;
        if (connector2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No connector for servant", servantStoken);
            }
            result = new InstanceNotFoundException("Non-existant servant" + servantStoken);
        } else {
            try {
                String profileKey = AdminContext.peek();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using profile Key: " + profileKey);
                }
                Properties props = new Properties();
                if (profileKey != null) {
                    props.setProperty("profile.key", profileKey);
                }
                byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking JMX connector", new java.lang.Object[]{servantStoken, mbeanName, attributeName});
                }
                byte[] returnBytes = connector2.getAttributeTypeName(mbeanType, mbeanName, attributeName, propertiesBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from JMX connector", servantStoken);
                }
                if (returnBytes != null && returnBytes.length > 0) {
                    result = JavaObjectSerializer.getObject(returnBytes);
                }
            }
            catch (ServerExceptionWrapper tWrapper) {
                FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.getServantMBeanAttribute", (String)"1374", (java.lang.Object)this);
                result = this.getRemoteException(tWrapper);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.getServantMBeanAttribute", (String)"1380", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller local exception", ex);
                }
                result = new ConnectorException("Controller local exception", ex);
            }
        }
        ServantMBeanInvokerData data = new ServantMBeanInvokerData(servantStoken, result, mbeanObjectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantMBeanAttribute", data);
        }
        return data;
    }

    private ServantMBeanInvokerData getServantMBeanAttribute(String servantStoken, CorbaConnector connector2, ObjectName mbeanObjectName, String attributeName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantMBeanAttribute", new java.lang.Object[]{servantStoken, connector2});
        }
        java.lang.Object result = null;
        if (connector2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No connector for servant", servantStoken);
            }
            result = new InstanceNotFoundException("Non-existant servant" + servantStoken);
        } else if (mbeanObjectName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean ObjectName is null");
            }
            result = new IllegalArgumentException("MBean object name is null");
        } else {
            try {
                byte[] objectNameBytes = JavaObjectSerializer.getByteArray(mbeanObjectName);
                String profileKey = AdminContext.peek();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using profile Key: " + profileKey);
                }
                Properties props = new Properties();
                if (profileKey != null) {
                    props.setProperty("profile.key", profileKey);
                }
                byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking JMX connector", new java.lang.Object[]{servantStoken, mbeanObjectName, attributeName});
                }
                byte[] returnBytes = connector2.getAttribute(objectNameBytes, attributeName, propertiesBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from JMX connector", servantStoken);
                }
                if (returnBytes != null && returnBytes.length > 0) {
                    result = JavaObjectSerializer.getObject(returnBytes);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Returned attribute value", result);
                }
            }
            catch (ServerExceptionWrapper tWrapper) {
                FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.getServantMBeanAttribute", (String)"1480", (java.lang.Object)this);
                result = this.getRemoteException(tWrapper);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.getServantMBeanAttribute", (String)"1486", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller local exception", ex);
                }
                result = new ConnectorException("Controller local exception", ex);
            }
        }
        ServantMBeanInvokerData data = new ServantMBeanInvokerData(servantStoken, result, mbeanObjectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantMBeanAttribute", data);
        }
        return data;
    }

    public Vector setSpecifiedServantsMBeanAttribute(HashSet specifiedServants, ObjectName mbeanObjectName, String mbeanType, String mbeanName, String attributeName, java.lang.Object attributeValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSpecifiedServantsMBeanAttribute", new java.lang.Object[]{specifiedServants, mbeanObjectName, mbeanType, mbeanName, attributeName, attributeValue});
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        Iterator iterator = specifiedServants.iterator();
        Vector<ServantMBeanInvokerData> results = new Vector<ServantMBeanInvokerData>(specifiedServants.size());
        while (iterator.hasNext()) {
            String currentServantStoken = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            ServantMBeanInvokerData data = this.setServantMBeanAttribute(currentServantStoken, currentConnector, mbeanObjectName, mbeanType, mbeanName, attributeName, attributeValue);
            results.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSpecifiedServantsMBeanAttribute", results);
        }
        return results;
    }

    public Vector setSpecifiedServantsMBeanAttribute(Set specifiedServants, ObjectName mbeanObjectName, String attributeName, java.lang.Object attributeValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSpecifiedServantsMBeanAttribute", new java.lang.Object[]{specifiedServants, mbeanObjectName, attributeName, attributeValue});
        }
        Hashtable connectors = AdminServiceImpl.getPlatformUtils().getConnectorStubs(this.aggregator);
        Vector servantStokens = this.getServantStokenVector(specifiedServants);
        Vector<ServantMBeanInvokerData> results = new Vector<ServantMBeanInvokerData>(specifiedServants.size());
        for (int i = 0; i < servantStokens.size(); ++i) {
            String currentServantStoken = (String)servantStokens.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentServantStoken", currentServantStoken);
            }
            CorbaConnector currentConnector = (CorbaConnector)connectors.get(currentServantStoken);
            ServantMBeanInvokerData data = this.setServantMBeanAttribute(currentServantStoken, currentConnector, mbeanObjectName, attributeName, attributeValue);
            results.add(data);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSpecifiedServantsMBeanAttribute", results);
        }
        return results;
    }

    private ServantMBeanInvokerData setServantMBeanAttribute(String servantStoken, CorbaConnector connector2, ObjectName mbeanObjectName, String mbeanType, String mbeanName, String attributeName, java.lang.Object attributeValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServantMBeanAttribute", new java.lang.Object[]{servantStoken, connector2});
        }
        Exception result = null;
        if (connector2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No connector for servant", servantStoken);
            }
            result = new InstanceNotFoundException("Non-existant servant" + servantStoken);
        } else {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking JMX connector", new java.lang.Object[]{servantStoken, mbeanName, attributeName});
                }
                String profileKey = AdminContext.peek();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using profile Key: " + profileKey);
                }
                Properties props = new Properties();
                if (profileKey != null) {
                    props.setProperty("profile.key", profileKey);
                }
                byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
                byte[] attributeBytes = new byte[]{};
                if (attributeValue != null) {
                    attributeBytes = JavaObjectSerializer.getByteArray(attributeValue);
                }
                connector2.setAttributeTypeName(mbeanType, mbeanName, attributeBytes, propertiesBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from JMX connector", servantStoken);
                }
            }
            catch (ServerExceptionWrapper tWrapper) {
                FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.setServantMBeanAttribute", (String)"1719", (java.lang.Object)this);
                result = this.getRemoteException(tWrapper);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.setServantMBeanAttribute", (String)"1725", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller local exception", ex);
                }
                result = new ConnectorException("Controller local exception", ex);
            }
        }
        ServantMBeanInvokerData data = new ServantMBeanInvokerData(servantStoken, result, mbeanObjectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServantMBeanAttribute", data);
        }
        return data;
    }

    private ServantMBeanInvokerData setServantMBeanAttribute(String servantStoken, CorbaConnector connector2, ObjectName mbeanObjectName, String attributeName, java.lang.Object attributeValue) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServantMBeanAttribute", new java.lang.Object[]{servantStoken, connector2});
        }
        Exception result = null;
        if (connector2 == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No connector for servant", servantStoken);
            }
            result = new InstanceNotFoundException("Non-existant servant" + servantStoken);
        } else if (mbeanObjectName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean ObjectName is null");
            }
            result = new IllegalArgumentException("MBean object name is null");
        } else {
            try {
                byte[] objectNameBytes = JavaObjectSerializer.getByteArray(mbeanObjectName);
                Attribute attribute = new Attribute(attributeName, attributeValue);
                byte[] attributeBytes = JavaObjectSerializer.getByteArray(attribute);
                String profileKey = AdminContext.peek();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using profile Key: " + profileKey);
                }
                Properties props = new Properties();
                if (profileKey != null) {
                    props.setProperty("profile.key", profileKey);
                }
                byte[] propertiesBytes = JavaObjectSerializer.getByteArray(props);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Invoking JMX connector", new java.lang.Object[]{servantStoken, mbeanObjectName, attributeName});
                }
                connector2.setAttribute(objectNameBytes, attributeBytes, propertiesBytes);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from JMX connector", servantStoken);
                }
            }
            catch (ServerExceptionWrapper tWrapper) {
                FFDCFilter.processException((Throwable)tWrapper, (String)"com.ibm.ws390.management.ServantMBeanInvoker.setServantMBeanAttribute", (String)"1827", (java.lang.Object)this);
                result = this.getRemoteException(tWrapper);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.setServantMBeanAttribute", (String)"1833", (java.lang.Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Controller local exception", ex);
                }
                result = new ConnectorException("Controller local exception", ex);
            }
        }
        ServantMBeanInvokerData data = new ServantMBeanInvokerData(servantStoken, result, mbeanObjectName);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServantMBeanAttribute", data);
        }
        return data;
    }

    private Vector getServantStokenVector(Set specifiedServants) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantStokenVector", specifiedServants);
        }
        if (this.controlAdmin == null) {
            this.controlAdmin = ControlAdminServiceImpl.getInstance();
        }
        Set activeServantStokens = this.controlAdmin.currentServants();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activeServantStokens", activeServantStokens);
        }
        Vector<String> invokerServantStokens = new Vector<String>();
        String currentServantStoken2 = null;
        for (String currentServantStoken2 : specifiedServants) {
            if (!activeServantStokens.contains(currentServantStoken2)) continue;
            invokerServantStokens.add(currentServantStoken2);
        }
        if (invokerServantStokens.size() == 0 && currentServantStoken2 != null) {
            invokerServantStokens.add(currentServantStoken2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantStokenVector", invokerServantStokens);
        }
        return invokerServantStokens;
    }

    private void putAdjunctsLast(Vector invokerServantStokens) {
        int i;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "putAdjunctsLast", invokerServantStokens);
        }
        if (this.controlAdmin == null) {
            this.controlAdmin = ControlAdminServiceImpl.getInstance();
        }
        Set activeAdjunctStokens = this.controlAdmin.currentAdjuncts();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activeAdjunctStokens", activeAdjunctStokens);
        }
        Vector<String> invokerAdjunctStokens = new Vector<String>(invokerServantStokens.size());
        for (i = 0; i < invokerServantStokens.size(); ++i) {
            String currentServantStoken = (String)invokerServantStokens.elementAt(i);
            if (!activeAdjunctStokens.contains(currentServantStoken)) continue;
            invokerAdjunctStokens.add(currentServantStoken);
            invokerServantStokens.removeElementAt(i);
            --i;
        }
        for (i = 0; i < invokerAdjunctStokens.size(); ++i) {
            invokerServantStokens.add(invokerAdjunctStokens.elementAt(i));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "adjuncts are last", invokerServantStokens);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "putAdjunctsLast");
        }
    }

    private Vector buildRandomServantStokenVector(Set specifiedServants) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildRandomServantStokenVector", specifiedServants);
        }
        Set activeServantStokens = this.controlAdmin.currentServants();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "activeServantStokens", activeServantStokens);
        }
        Vector<String> invokerServantStokens = new Vector<String>();
        ArrayList sourceStokenList = new ArrayList(specifiedServants);
        String currentServantStoken = null;
        while (sourceStokenList.size() > 0) {
            int entry = this.randomNumber.nextInt(sourceStokenList.size());
            currentServantStoken = (String)sourceStokenList.get(entry);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "entry / stoken", new java.lang.Object[]{new Integer(entry), currentServantStoken});
            }
            if (activeServantStokens.contains(currentServantStoken)) {
                invokerServantStokens.add(currentServantStoken);
            }
            sourceStokenList.remove(entry);
        }
        if (invokerServantStokens.size() == 0 && currentServantStoken != null) {
            invokerServantStokens.add(currentServantStoken);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildRandomServantStokenVector");
        }
        return invokerServantStokens;
    }

    private Exception getRemoteException(ServerExceptionWrapper tWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteException", (java.lang.Object)tWrapper);
        }
        if (tc.isDebugEnabled()) {
            String stackTrace = JavaObjectSerializer.getStackTrace(tWrapper);
            Tr.debug(tc, "Servant exception or error", stackTrace);
        }
        Exception exception = null;
        try {
            Throwable t = JavaObjectSerializer.getException(tWrapper);
            exception = t instanceof InstanceNotFoundException ? (Exception)t : new ConnectorException("Servant remote exception received", t);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws390.management.ServantMBeanInvoker.getRemoteException", (String)"2007", (java.lang.Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nested connector error", ex);
            }
            exception = new ConnectorException("Controller local exception", ex);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteException", exception);
        }
        return exception;
    }
}

