/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.xmlsoap.ext;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.FaultDesc;
import com.ibm.ws.webservices.engine.encoding.SerializationContext;
import com.ibm.ws.webservices.engine.encoding.SerializationWriter;
import com.ibm.ws.webservices.engine.encoding.SerializerFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMappingImpl;
import com.ibm.ws.webservices.engine.encoding.ser.CustomSerializerFactory;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import com.ibm.ws.webservices.engine.xmlsoap.AlternateContentBase;
import com.ibm.ws.webservices.engine.xmlsoap.Detail;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPConstants;
import com.ibm.ws.webservices.engine.xmlsoap.SOAPElement;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public final class WebServicesFaultAlternateContent
extends AlternateContentBase {
    protected static Log log = LogFactory.getLog((String)WebServicesFaultAlternateContent.class.getName());

    public static WebServicesFaultAlternateContent create(WebServicesFault webServicesFault) {
        return new WebServicesFaultAlternateContent(webServicesFault, AlternateContentBase.CONTENT_ONLY);
    }

    WebServicesFaultAlternateContent(WebServicesFault webServicesFault, short s) {
        super((Object)webServicesFault, s);
    }

    protected void serialize(SerializationContext serializationContext, boolean bl) throws Exception {
        String string;
        Serializable serializable;
        Object object;
        String string2;
        QName qName;
        MappingScope mappingScope;
        if (this.owner.getSOAPFactory().getSOAPConstants().getSOAPProtocol().equals("SOAP 1.2 Protocol")) {
            this.serializeSOAP12(serializationContext, bl);
            return;
        }
        MappingScope mappingScope2 = null;
        if (bl) {
            mappingScope2 = this._getMappingScopeForAncestorsNotWritten(serializationContext);
        }
        if ((mappingScope = this._getMappingScope(this.owner)).size() > 0) {
            if (mappingScope2 == null) {
                mappingScope2 = new MappingScope();
            }
            qName = null;
            string2 = null;
            object = null;
            serializable = new StringBuffer();
            for (int i = 0; i < mappingScope.size(); ++i) {
                qName = mappingScope.get(i);
                if (qName == null) continue;
                string2 = qName.getNamespaceURI();
                object = qName.getPrefix();
                if (((String)object).length() <= 0) continue;
                mappingScope2.addMapping(string2, (String)object);
                ((StringBuffer)serializable).append((String)object + " " + string2);
                ((StringBuffer)serializable).append("\n");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("MappingScope of Fault: \n" + serializable));
            }
        }
        qName = this.owner.getQName();
        string2 = this.owner.getPrefix();
        if (log.isDebugEnabled()) {
            log.debug((Object)("owner QName and prefix: " + qName + " " + string2));
        }
        if ((object = mappingScope.getMappingForPrefix(string2, false)) == null || object != null && !qName.getNamespaceURI().equals(object.getNamespaceURI())) {
            if (mappingScope2 == null) {
                mappingScope2 = new MappingScope();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Will add owner namespace and prefix to MappingScope");
            }
            mappingScope2.addMapping(qName.getNamespaceURI(), string2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Serializing these namespaces: " + mappingScope2));
        }
        serializationContext.getSerializationWriter().startElement(this.owner.getQName(), this.owner.getPrefix(), this.owner.getSAXAttributes(), mappingScope2);
        serializable = (WebServicesFault)this.content;
        if (((WebServicesFault)serializable).getFaultCode() != null) {
            QName qName2 = ((WebServicesFault)serializable).getFaultCode();
            string = qName2.getNamespaceURI().length() == 0 ? qName2.getLocalPart() : serializationContext.getSerializationWriter().qName2String(qName2);
            serializationContext.getSerializationWriter().simpleElement(Constants.QNAME_FAULTCODE, null, string);
        }
        if (((WebServicesFault)serializable).getFaultString() != null) {
            serializationContext.getSerializationWriter().simpleElement(Constants.QNAME_FAULTSTRING, null, ((WebServicesFault)serializable).getFaultString());
        }
        if (((WebServicesFault)serializable).getFaultActor() != null) {
            serializationContext.getSerializationWriter().simpleElement(Constants.QNAME_FAULTACTOR, null, ((WebServicesFault)serializable).getFaultActor());
        }
        if (((WebServicesFault)serializable).getFaultDetails() != null || ((WebServicesFault)serializable).getUserException() != null) {
            Exception exception;
            MessageContext messageContext = serializationContext.getMessageContext();
            string = messageContext != null ? messageContext.getEncodingStyle() : null;
            AttributesImpl attributesImpl = null;
            if (string != null) {
                attributesImpl = new AttributesImpl();
                attributesImpl.addAttribute(this.owner.getQName().getNamespaceURI(), "encodingStyle", "encodingStyle", "CDATA", string);
            }
            MappingScope mappingScope3 = null;
            if (((WebServicesFault)serializable).getUserException() instanceof SOAPFaultException && ((SOAPFaultException)(exception = (SOAPFaultException)((WebServicesFault)serializable).getUserException())).getDetail() != null) {
                mappingScope3 = this._getMappingScope((SOAPElement)((Detail)((SOAPFaultException)exception).getDetail()));
            }
            if (mappingScope3 != null) {
                log.debug((Object)("Will serialize detail element with this MappingScope: " + mappingScope3));
            }
            serializationContext.getSerializationWriter().startElement(Constants.QNAME_FAULTDETAILS, (Attributes)attributesImpl, mappingScope3);
            try {
                Object object2;
                exception = ((WebServicesFault)serializable).getUserException();
                if (exception != null && !(exception instanceof SOAPFaultException)) {
                    object2 = null;
                    if (serializationContext.getMessageContext() != null && serializationContext.getMessageContext().getOperation() != null) {
                        object2 = serializationContext.getMessageContext().getOperation().getFaultByClass(exception.getClass());
                    }
                    if (object2 != null && ((FaultDesc)object2).getPartQName() != null) {
                        Object object3 = null;
                        SerializerFactory serializerFactory = (SerializerFactory)serializationContext.getTypeMapping().getSerializer(exception.getClass());
                        object3 = serializerFactory instanceof CustomSerializerFactory ? exception : JavaUtils.getDetail(exception);
                        QName qName3 = null;
                        Boolean bl2 = null;
                        if (object3 == exception) {
                            Class<?> clazz = object3.getClass();
                            qName3 = ((FaultDesc)object2).getPartXmlType();
                            QName qName4 = ((TypeMappingImpl)serializationContext.getTypeMapping()).getXMLType(clazz, qName3);
                            if (qName3 != null && !qName3.equals(qName4)) {
                                bl2 = Boolean.TRUE;
                            }
                        }
                        serializationContext.serialize(((FaultDesc)object2).getPartQName(), null, object3, qName3, false, bl2);
                    }
                }
                if ((object2 = ((WebServicesFault)serializable).getFaultDetails()) != null) {
                    for (int i = 0; i < ((Element[])object2).length; ++i) {
                        serializationContext.getSerializationWriter().writeDOMElement(object2[i]);
                    }
                }
            }
            catch (Exception exception2) {
                FFDCFilter.processException((Throwable)exception2, (String)"com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent.serialize", (String)"142", (Object)((Object)this));
            }
            serializationContext.getSerializationWriter().endElement();
        }
        serializationContext.getSerializationWriter().endElement();
        serializationContext.outputMultiRefs();
    }

    private void serializeSOAP12(SerializationContext serializationContext, boolean bl) throws Exception {
        Object object;
        Object object2;
        String string;
        Object object3;
        MappingScope mappingScope = null;
        if (bl) {
            mappingScope = this._getMappingScopeForAncestorsNotWritten(serializationContext);
        }
        SerializationWriter serializationWriter = serializationContext.getSerializationWriter();
        serializationWriter.startElement(this.owner.getQName(), this.owner.getPrefix(), this.owner.getSAXAttributes(), mappingScope);
        WebServicesFault webServicesFault = (WebServicesFault)this.content;
        SOAPConstants sOAPConstants = this.owner.getSOAPFactory().getSOAPConstants();
        QName qName = sOAPConstants.getFaultCodeQName();
        QName qName2 = sOAPConstants.getFaultCodeValueQName();
        QName qName3 = sOAPConstants.getFaultSubcodeQName();
        QName qName4 = sOAPConstants.getFaultStringOrReasonQName();
        QName qName5 = sOAPConstants.getFaultReasonTextQName();
        QName qName6 = sOAPConstants.getFaultNodeQName();
        QName qName7 = sOAPConstants.getFaultActorOrRoleQName();
        QName qName8 = sOAPConstants.getFaultDetailQName();
        QName qName9 = sOAPConstants.getXMLLangAttributeQName();
        String string2 = this.owner.getPrefix();
        if (webServicesFault.getFaultCode() != null) {
            serializationWriter.startElement(qName, null);
            object3 = webServicesFault.getFaultCode();
            string = ((QName)object3).getNamespaceURI().length() == 0 ? ((QName)object3).getLocalPart() : serializationWriter.qName2String((QName)object3);
            serializationWriter.simpleElement(qName2, string2, null, string);
            object2 = webServicesFault.getSOAP12_Subcodes();
            if (object2 != null) {
                int n;
                for (n = 0; n < object2.size(); ++n) {
                    serializationWriter.startElement(qName3, null);
                    QName qName10 = (QName)object2.get(n);
                    object = qName10.getNamespaceURI().length() == 0 ? qName10.getLocalPart() : serializationWriter.qName2String(qName10);
                    serializationWriter.simpleElement(qName2, string2, null, (String)object);
                }
                for (n = 0; n < object2.size(); ++n) {
                    serializationWriter.endElement();
                }
            }
            serializationWriter.endElement();
        }
        if (webServicesFault.getFaultString() != null) {
            serializationWriter.startElement(qName4, null);
            object3 = webServicesFault.getFaultString();
            string = webServicesFault.getSOAP12_ReasonLanguage();
            if (string == null) {
                object2 = Locale.getDefault();
                string = ((Locale)object2).getLanguage();
            }
            object2 = null;
            if (string != null) {
                object2 = new AttributesImpl();
                ((AttributesImpl)object2).addAttribute(qName9.getNamespaceURI(), qName9.getLocalPart(), "xml:" + qName9.getLocalPart(), "CDATA", string);
            }
            serializationWriter.simpleElement(qName5, string2, (Attributes)object2, (String)object3);
            List list = webServicesFault.getSOAP12_AdditionalReasons();
            if (list != null) {
                for (int i = 0; i < list.size(); i += 2) {
                    string = (String)list.get(i);
                    object3 = (String)list.get(i + 1);
                    if (string != null) {
                        object2 = new AttributesImpl();
                        ((AttributesImpl)object2).addAttribute(qName9.getNamespaceURI(), qName9.getLocalPart(), "xml:" + qName9.getLocalPart(), "CDATA", string);
                    }
                    serializationWriter.simpleElement(qName5, string2, (Attributes)object2, (String)object3);
                }
            }
            serializationWriter.endElement();
        }
        if (webServicesFault.getSOAP12_Node() != null) {
            serializationWriter.simpleElement(qName6, string2, null, webServicesFault.getSOAP12_Node());
        }
        if (webServicesFault.getFaultActor() != null) {
            serializationWriter.simpleElement(qName7, string2, null, webServicesFault.getFaultActor());
        }
        if (webServicesFault.getFaultDetails() != null || webServicesFault.getUserException() != null) {
            object3 = serializationContext.getMessageContext();
            string = object3 != null ? ((MessageContext)object3).getEncodingStyle() : null;
            object2 = null;
            if (string != null) {
                object2 = new AttributesImpl();
                ((AttributesImpl)object2).addAttribute(this.owner.getQName().getNamespaceURI(), "encodingStyle", "encodingStyle", "CDATA", string);
            }
            serializationWriter.startElement(qName8, (Attributes)object2);
            try {
                Element[] elementArray;
                FaultDesc faultDesc;
                Exception exception = webServicesFault.getUserException();
                if (exception != null && !(exception instanceof SOAPFaultException) && (faultDesc = serializationContext.getMessageContext().getOperation().getFaultByClass(exception.getClass())) != null && faultDesc.getPartQName() != null) {
                    object = null;
                    SerializerFactory serializerFactory = (SerializerFactory)serializationContext.getTypeMapping().getSerializer(exception.getClass());
                    object = serializerFactory instanceof CustomSerializerFactory ? exception : JavaUtils.getDetail(exception);
                    QName qName11 = null;
                    Boolean bl2 = null;
                    if (object == exception) {
                        Class<?> clazz = object.getClass();
                        qName11 = faultDesc.getPartXmlType();
                        QName qName12 = ((TypeMappingImpl)serializationContext.getTypeMapping()).getXMLType(clazz, qName11);
                        if (qName11 != null && !qName11.equals(qName12)) {
                            bl2 = Boolean.TRUE;
                        }
                    }
                    serializationContext.serialize(faultDesc.getPartQName(), null, object, qName11, false, bl2);
                }
                if ((elementArray = webServicesFault.getFaultDetails()) != null) {
                    for (int i = 0; i < elementArray.length; ++i) {
                        serializationContext.getSerializationWriter().writeDOMElement(elementArray[i]);
                    }
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.engine.xmlsoap.ext.WebServicesFaultAlternateContent.serialize", (String)"142", (Object)((Object)this));
            }
            serializationWriter.endElement();
        }
        serializationWriter.endElement();
        serializationContext.outputMultiRefs();
    }
}

