/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.Mapping;
import com.ibm.ws.webservices.engine.utils.MappingTable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Stack;

public final class MappingScope
implements Serializable {
    private Mapping singleMapping = null;
    private ArrayList mappings = null;
    private MappingScope parent = null;
    private boolean readOnly = false;
    private Object owner = null;

    public Object clone() {
        MappingScope mappingScope = new MappingScope();
        if (this.mappings != null) {
            mappingScope.mappings = (ArrayList)this.mappings.clone();
        }
        mappingScope.singleMapping = this.singleMapping;
        mappingScope.setParent(this.parent);
        return mappingScope;
    }

    public String getOrCreatePrefix(String string, String string2, boolean bl) {
        if (string.length() != 0) {
            if (string2 != null && string2.length() == 0 && bl) {
                string2 = null;
            }
            Mapping mapping = this.getOrCreateMappingForNamespaceURI(string, false, bl, string2);
            return mapping.getPrefix();
        }
        if (bl) {
            return "";
        }
        if (this.getMappingForPrefix("", false) != null) {
            this.addMapping("", "");
        }
        return "";
    }

    public Mapping getMappingForPrefix(String string, boolean bl) {
        MappingScope mappingScope = this;
        while (mappingScope != null) {
            if (mappingScope.singleMapping != null && mappingScope.singleMapping.getPrefix().equals(string)) {
                return mappingScope.singleMapping;
            }
            if (mappingScope.mappings != null) {
                for (int i = 0; i < mappingScope.mappings.size(); ++i) {
                    Mapping mapping = (Mapping)mappingScope.mappings.get(i);
                    if (!mapping.getPrefix().equals(string)) continue;
                    return mapping;
                }
            }
            mappingScope = bl ? null : mappingScope.parent;
        }
        return null;
    }

    public void setParent(MappingScope mappingScope) {
        if (mappingScope == this.parent) {
            return;
        }
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage((String)"readOnlyMS00"));
        }
        MappingScope mappingScope2 = mappingScope;
        while (mappingScope2 != null) {
            if (mappingScope2 == this) {
                throw new RuntimeException(Messages.getMessage((String)"loopyMS00"));
            }
            mappingScope2 = mappingScope2.parent;
        }
        this.parent = mappingScope;
    }

    public MappingScope getParent() {
        return this.parent;
    }

    public void addMapping(String string, String string2) {
        Mapping mapping = MappingTable.createMapping((String)string, (String)string2);
        this.addMapping(mapping);
    }

    private void addMapping(Mapping mapping) {
        if (mapping == this.getMappingForPrefix(mapping.getPrefix(), true)) {
            return;
        }
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage((String)"readOnlyMS00"));
        }
        this.removeMappingForPrefix(mapping.getPrefix());
        if (this.singleMapping == null) {
            this.singleMapping = mapping;
        } else {
            if (this.mappings == null) {
                this.mappings = new ArrayList();
            }
            this.mappings.add(mapping);
        }
    }

    public Mapping getMappingForNamespaceURI(String string, boolean bl, boolean bl2) {
        MappingScope mappingScope = this;
        boolean bl3 = false;
        while (mappingScope != null) {
            if (mappingScope.singleMapping != null && mappingScope.singleMapping.getNamespaceURI().equals(string) && (!bl2 || mappingScope.singleMapping.getPrefix().length() > 0)) {
                return bl3 && mappingScope.singleMapping != this.getMappingForPrefix(mappingScope.singleMapping.getPrefix(), bl) ? null : mappingScope.singleMapping;
            }
            if (mappingScope.mappings != null) {
                for (int i = 0; i < mappingScope.mappings.size(); ++i) {
                    Mapping mapping = (Mapping)mappingScope.mappings.get(i);
                    if (!mapping.getNamespaceURI().equals(string) || bl2 && mapping.getPrefix().length() <= 0) continue;
                    return bl3 && mapping != this.getMappingForPrefix(mapping.getPrefix(), bl) ? null : mapping;
                }
            }
            bl3 = bl3 || mappingScope.singleMapping != null;
            mappingScope = bl ? null : mappingScope.parent;
        }
        return null;
    }

    public boolean hasMappings() {
        return this.singleMapping != null;
    }

    public int size() {
        if (this.mappings == null) {
            return this.singleMapping != null ? 1 : 0;
        }
        return this.mappings.size() + (this.singleMapping != null ? 1 : 0);
    }

    public Mapping get(int n) {
        if (n == 0) {
            return this.singleMapping;
        }
        if (this.mappings == null) {
            return null;
        }
        return (Mapping)this.mappings.get(n - 1);
    }

    public boolean removeMappingForPrefix(String string) {
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage((String)"readOnlyMS00"));
        }
        if (this.singleMapping != null && this.singleMapping.getPrefix().equals(string)) {
            this.singleMapping = this.mappings != null && this.mappings.size() > 0 ? (Mapping)this.mappings.remove(0) : null;
            return true;
        }
        if (this.mappings != null) {
            for (int i = 0; i < this.mappings.size(); ++i) {
                Mapping mapping = (Mapping)this.mappings.get(i);
                if (!mapping.getPrefix().equals(string)) continue;
                this.mappings.remove(i);
                return true;
            }
        }
        return false;
    }

    public boolean removeMapping(Mapping mapping) {
        int n;
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage((String)"readOnlyMS00"));
        }
        if (this.singleMapping != null && this.singleMapping == mapping) {
            this.singleMapping = this.mappings != null && this.mappings.size() > 0 ? (Mapping)this.mappings.remove(0) : null;
            return true;
        }
        if (this.mappings != null && (n = this.mappings.indexOf(mapping)) >= 0) {
            this.mappings.remove(n);
            return true;
        }
        return false;
    }

    public void clear() {
        if (this.readOnly) {
            throw new RuntimeException(Messages.getMessage((String)"readOnlyMS00"));
        }
        this.singleMapping = null;
        if (this.mappings != null) {
            this.mappings.clear();
        }
    }

    public MappingScope flatten() {
        MappingScope mappingScope = new MappingScope();
        Stack<MappingScope> stack = new Stack<MappingScope>();
        MappingScope mappingScope2 = this;
        while (mappingScope2 != null) {
            stack.push(mappingScope2);
            mappingScope2 = mappingScope2.parent;
        }
        while (!stack.empty()) {
            mappingScope2 = (MappingScope)stack.pop();
            for (int i = 0; i < mappingScope2.size(); ++i) {
                mappingScope.addMapping(mappingScope2.get(i));
            }
        }
        return mappingScope;
    }

    private Mapping getOrCreateMappingForNamespaceURI(String string, boolean bl, boolean bl2, String string2) {
        Mapping mapping = this.getMappingForNamespaceURI(string, bl, bl2);
        if (mapping == null) {
            mapping = string2 == null && !bl2 ? MappingTable.createMapping((String)string, (String)"") : (string2 == null ? MappingTable.createMapping((String)string) : MappingTable.createMapping((String)string, (String)string2));
            this.addMapping(mapping);
        }
        return mapping;
    }

    public void setReadOnly(boolean bl, Object object) {
        if (bl == this.readOnly) {
            return;
        }
        if (this.readOnly && !bl && this.owner != object) {
            throw new RuntimeException(Messages.getMessage((String)"readOnlyMS00"));
        }
        this.readOnly = bl;
        this.owner = object;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isReadOnlyOwner(Object object) {
        return object == this.owner;
    }

    public String toString() {
        String string = "\n-------------------\n";
        if (this.getParent() != null) {
            string = this.getParent().toString();
        }
        for (int i = 0; i < this.size(); ++i) {
            Mapping mapping = this.get(i);
            string = string + mapping.getPrefix() + " --> " + mapping.getNamespaceURI() + "\n";
        }
        string = string + "-------------------\n";
        return string;
    }
}

