/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.types;

import com.ibm.ws.webservices.engine.resources.Messages;
import java.io.Serializable;

public class Duration
implements Serializable {
    boolean isNegative = false;
    int years;
    int months;
    int days;
    int hours;
    int minutes;
    double seconds;

    public Duration() {
    }

    public Duration(boolean bl, int n, int n2, int n3, int n4, int n5, double d) {
        this.isNegative = bl;
        this.years = n;
        this.months = n2;
        this.days = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = d;
    }

    public Duration(String string) throws IllegalArgumentException {
        int n = 1;
        int n2 = string.indexOf("T");
        if (string.indexOf("P") == -1) {
            throw new IllegalArgumentException(Messages.getMessage((String)"badDuration"));
        }
        if (string.startsWith("-")) {
            this.isNegative = true;
            ++n;
        }
        if (n2 != -1) {
            this.parseTime(string.substring(n2 + 1));
        } else {
            n2 = string.length();
        }
        this.parseDate(string.substring(n, n2));
    }

    public void parseTime(String string) {
        int n = 0;
        int n2 = string.indexOf("H");
        if (n2 != -1) {
            this.hours = Integer.parseInt(string.substring(0, n2));
            n = n2 + 1;
        }
        if ((n2 = string.indexOf("M")) != -1) {
            this.minutes = Integer.parseInt(string.substring(n, n2));
            n = n2 + 1;
        }
        if ((n2 = string.indexOf("S")) != -1) {
            this.seconds = Double.parseDouble(string.substring(n, n2));
        }
    }

    public void parseDate(String string) {
        int n = 0;
        int n2 = string.indexOf("Y");
        if (n2 != -1) {
            this.years = Integer.parseInt(string.substring(0, n2));
            n = n2 + 1;
        }
        if ((n2 = string.indexOf("M")) != -1) {
            this.months = Integer.parseInt(string.substring(n, n2));
            n = n2 + 1;
        }
        if ((n2 = string.indexOf("D")) != -1) {
            this.days = Integer.parseInt(string.substring(n, n2));
        }
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public void setNegative(boolean bl) {
        this.isNegative = bl;
    }

    public void setYears(int n) {
        this.years = n;
    }

    public void setMonths(int n) {
        this.months = n;
    }

    public void setDays(int n) {
        this.days = n;
    }

    public void setHours(int n) {
        this.hours = n;
    }

    public void setMinutes(int n) {
        this.minutes = n;
    }

    public void setSeconds(int n) {
        this.seconds = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("P");
        if (this.years != 0) {
            stringBuffer.append(this.years + "Y");
        }
        if (this.months != 0) {
            stringBuffer.append(this.months + "M");
        }
        if (this.days != 0) {
            stringBuffer.append(this.days + "D");
        }
        if (this.hours != 0 || this.minutes != 0 || this.seconds != 0.0) {
            stringBuffer.append("T");
            if (this.hours != 0) {
                stringBuffer.append(this.hours + "H");
            }
            if (this.minutes != 0) {
                stringBuffer.append(this.minutes + "M");
            }
            if (this.seconds != 0.0) {
                if (this.seconds == (double)((int)this.seconds)) {
                    stringBuffer.append((int)this.seconds + "S");
                } else {
                    stringBuffer.append(this.seconds + "S");
                }
            }
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append("T0S");
        }
        if (this.isNegative) {
            stringBuffer.insert(0, "-");
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)object;
        int n = this.years * 12 + this.months;
        int n2 = duration.years * 12 + duration.months;
        double d = (double)(((this.days * 24 + this.hours) * 60 + this.minutes) * 60) + this.seconds;
        double d2 = (double)(((duration.days * 24 + duration.hours) * 60 + duration.minutes) * 60) + duration.seconds;
        return this.isNegative == duration.isNegative && n == n2 && d == d2;
    }

    public int hashCode() {
        int n = 0;
        if (this.isNegative) {
            ++n;
        }
        n += this.years;
        n += this.months;
        n += this.days;
        n += this.hours;
        n += this.minutes;
        n = (int)((double)n + this.seconds);
        return n;
    }
}

