/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.utils;

import com.ibm.ws.webservices.Version;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.description.TypeDesc;
import com.ibm.ws.webservices.engine.encoding.utils.FieldDesc;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class BeanDesc {
    private static Log log = LogFactory.getLog((String)BeanDesc.class.getName());
    protected Class javaClass = null;
    protected ArrayList fields = new ArrayList();
    protected HashMap fieldDescMap = new HashMap();
    protected HashMap fieldNameMap = new HashMap();
    protected BeanPropertyDescriptor[] propertyDescriptors = null;
    protected Map propertyMap = null;
    protected boolean _hasAttributes = false;
    protected String buildNumber = null;

    protected BeanDesc() {
    }

    public static BeanDesc getBeanDescForClass(Class clazz) {
        TypeDesc typeDesc = TypeDesc.getTypeDescForClass(clazz);
        if (typeDesc == null) {
            return null;
        }
        BeanDesc beanDesc = new BeanDesc();
        beanDesc.javaClass = clazz;
        beanDesc.buildNumber = (String)typeDesc.getOption("buildNum");
        if (beanDesc.buildNumber == null) {
            beanDesc.buildNumber = "pre-WAS 6.0 build";
        } else if (beanDesc.buildNumber.equals(Version.getRawBuildNum())) {
            beanDesc.buildNumber = null;
        }
        com.ibm.ws.webservices.engine.description.FieldDesc[] fieldDescArray = typeDesc.getFields();
        if (fieldDescArray != null) {
            for (int i = 0; i < fieldDescArray.length; ++i) {
                FieldDesc fieldDesc = new FieldDesc(fieldDescArray[i]);
                beanDesc.addFieldDesc(fieldDesc);
                beanDesc.fields.add(fieldDesc);
            }
        }
        beanDesc._prime();
        return beanDesc;
    }

    public final BeanPropertyDescriptor getAnyDesc() {
        return (BeanPropertyDescriptor)this.propertyMap.get("_any");
    }

    public final ArrayList getFields() {
        return this.fields;
    }

    public final FieldDesc getFieldByName(String string) {
        return (FieldDesc)this.fieldNameMap.get(string);
    }

    public final boolean hasAttributes() {
        return this._hasAttributes;
    }

    public final BeanPropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            this.propertyDescriptors = BeanUtils.getPd((Class)this.javaClass, (BeanDesc)this);
            this.propertyMap = null;
            this.getPropertyDescriptorMap();
        }
        return this.propertyDescriptors;
    }

    public final synchronized BeanPropertyDescriptor[] setBeanPropertyDescriptors(Class clazz) {
        this.propertyDescriptors = BeanUtils.getPd((Class)clazz, (BeanDesc)this);
        this.propertyMap = null;
        this.getPropertyDescriptorMap();
        return this.propertyDescriptors;
    }

    public final Map getPropertyDescriptorMap() {
        if (this.propertyMap != null) {
            return this.propertyMap;
        }
        if (this.propertyDescriptors == null) {
            this.getPropertyDescriptors();
        }
        this.propertyMap = new HashMap();
        for (int i = 0; i < this.propertyDescriptors.length; ++i) {
            BeanPropertyDescriptor beanPropertyDescriptor = this.propertyDescriptors[i];
            this.propertyMap.put(beanPropertyDescriptor.getName(), beanPropertyDescriptor);
            FieldDesc fieldDesc = this.getFieldByName(beanPropertyDescriptor.getName());
            if (fieldDesc == null) continue;
            this.setJavaType(fieldDesc, beanPropertyDescriptor);
            fieldDesc.setPropertyDescriptor(beanPropertyDescriptor);
        }
        return this.propertyMap;
    }

    protected void setJavaType(FieldDesc fieldDesc, BeanPropertyDescriptor beanPropertyDescriptor) {
        Class clazz = beanPropertyDescriptor.getFullType();
        if (!clazz.isArray()) {
            fieldDesc.setJavaType(clazz);
        } else {
            if (!fieldDesc.isMaxOccurs() && ("pre-WAS 6.0 build".equals(this.buildNumber) || Constants.equals(Constants.XSD_ANY, fieldDesc.getXmlType())) && beanPropertyDescriptor.isIndexed()) {
                fieldDesc.setMaxOccurs(true);
            }
            if (!fieldDesc.isMaxOccurs()) {
                fieldDesc.setJavaType(clazz);
            } else {
                fieldDesc.setJavaType(clazz.getComponentType());
            }
        }
    }

    public final synchronized void addFieldDesc(FieldDesc fieldDesc) {
        Serializable serializable;
        String string = fieldDesc.getXmlName().getLocalPart();
        String string2 = fieldDesc.getXmlName().getNamespaceURI();
        Object v = this.fieldDescMap.get(string);
        if (v == null) {
            this.fieldDescMap.put(string, fieldDesc);
        } else if (v instanceof FieldDesc) {
            serializable = (FieldDesc)v;
            if (!((com.ibm.ws.webservices.engine.description.FieldDesc)serializable).getXmlName().getNamespaceURI().equals(string2)) {
                HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
                this.fieldDescMap.put(string, hashMap);
                hashMap.put(string2, fieldDesc);
                hashMap.put(((com.ibm.ws.webservices.engine.description.FieldDesc)serializable).getXmlName().getNamespaceURI(), serializable);
            }
        } else {
            serializable = (HashMap)v;
            FieldDesc fieldDesc2 = (FieldDesc)((HashMap)serializable).get(string2);
            if (fieldDesc2 == null) {
                ((HashMap)serializable).put(string2, fieldDesc);
            }
        }
        this.fieldNameMap.put(fieldDesc.getFieldName(), fieldDesc);
        if (!fieldDesc.isElement()) {
            this._hasAttributes = true;
        }
        if (this.propertyMap != null && (serializable = (BeanPropertyDescriptor)this.propertyMap.get(fieldDesc.getFieldName())) != null) {
            this.setJavaType(fieldDesc, (BeanPropertyDescriptor)serializable);
            fieldDesc.setPropertyDescriptor((BeanPropertyDescriptor)serializable);
        }
    }

    public final FieldDesc getFieldDesc(String string, String string2) {
        Object v;
        if (string == null) {
            string = "";
        }
        if ((v = this.fieldDescMap.get(string2)) == null) {
            return null;
        }
        if (v.getClass() == FieldDesc.class) {
            String string3 = ((FieldDesc)v).getXmlName().getNamespaceURI();
            if (string3 == string || string3.equals(string)) {
                return (FieldDesc)v;
            }
            return null;
        }
        return (FieldDesc)((HashMap)v).get(string);
    }

    protected void _prime() {
        BeanDesc beanDesc;
        this.getPropertyDescriptorMap();
        Class clazz = this.javaClass.getSuperclass();
        if (clazz != null && !clazz.getName().startsWith("java.") && (beanDesc = BeanDesc.getBeanDescForClass(clazz)) != null) {
            this.fields.addAll(0, beanDesc.fields);
            beanDesc.getFieldDesc("", "");
            Iterator iterator = beanDesc.fieldDescMap.values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                if (v instanceof FieldDesc) {
                    this.addFieldDesc((FieldDesc)v);
                    continue;
                }
                Map map = (Map)v;
                Iterator iterator2 = map.values().iterator();
                while (iterator2.hasNext()) {
                    FieldDesc fieldDesc = (FieldDesc)iterator2.next();
                    this.addFieldDesc(fieldDesc);
                }
            }
        }
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }
}

