/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DefaultDeserializer;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.utils.DeserializerTarget;
import com.ibm.ws.webservices.engine.events.DEventProcessor;
import com.ibm.ws.webservices.engine.events.NOOPProcessor;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class VectorDeserializer
extends Deserializer {
    protected static Log log = LogFactory.getLog((String)VectorDeserializer.class.getName());
    public int curIndex = 0;

    public VectorDeserializer(Class clazz, QName qName) {
        super(clazz, qName);
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: VectorDeserializer::startElement()");
        }
        if (AttributeUtils.isNil((Attributes)attributes)) {
            return;
        }
        this.setValue(new Vector());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: VectorDeserializer::startElement()");
        }
    }

    public DEventProcessor onStartChild(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: VectorDeserializer::onStartChild()");
        }
        if (attributes == null) {
            throw new SAXException(Messages.getMessage((String)"noType01"));
        }
        if (AttributeUtils.isNil((Attributes)attributes)) {
            this.setValue(null, new Integer(this.curIndex++));
            return new NOOPProcessor();
        }
        QName qName = AttributeUtils.getTypeFromAttributes((String)string, (String)string2, (Attributes)attributes, (MappingScope)mappingScope);
        Deserializer deserializer = null;
        if (qName != null) {
            deserializer = deserializationContext.getDeserializer(null, qName);
        }
        if (deserializer == null) {
            deserializer = new DefaultDeserializer();
        }
        deserializer.registerValueTarget(new DeserializerTarget(this, new Integer(this.curIndex)));
        ++this.curIndex;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: VectorDeserializer::onStartChild()");
        }
        this.addChildDeserializer(deserializer, attributes.getValue("href"));
        return deserializer;
    }

    public void setValue(Object object, Object object2) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"gotValue00", (String)"VectorDeserializer", (String)("" + object)));
        }
        if (object2 instanceof Deserializer) {
            super.setValue(object, object2);
        } else {
            Vector vector;
            int n = (Integer)object2;
            if (n >= (vector = (Vector)this.value).size()) {
                vector.setSize(n + 1);
            }
            vector.setElementAt(object, n);
        }
    }

    public boolean recycle() {
        boolean bl = super.recycle();
        if (bl) {
            this.curIndex = 0;
        }
        return bl;
    }
}

