/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.Deserializer;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class ListDeserializer
extends SimpleDeserializer {
    private QName componentTypeQName = null;
    private Class javaCompType = null;
    private Deserializer dSer = null;
    private DeserializationContext context = null;

    public ListDeserializer(Class clazz, QName qName) {
        this(clazz, qName, (QName)null, (QName)null);
    }

    public ListDeserializer(Class clazz, QName qName, QName qName2, QName qName3) {
        super(clazz, qName);
        this.componentTypeQName = qName3;
    }

    public void onStartElement(String string, String string2, String string3, Attributes attributes, MappingScope mappingScope, DeserializationContext deserializationContext) throws SAXException {
        this.context = deserializationContext;
        this.initialize();
        super.onStartElement(string, string2, string3, attributes, mappingScope, deserializationContext);
        this.dSer.onStartElement(string, string2, string3, attributes, mappingScope, deserializationContext);
    }

    public Object makeValue(String string) throws Exception {
        if (this.javaType.isArray()) {
            return this.makeArrayValue(string);
        }
        return this.makeListValue(string);
    }

    public final Object makeArrayValue(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        Object object = Array.newInstance(this.javaCompType, n);
        for (int i = 0; i < n; ++i) {
            Array.set(object, i, ((SimpleDeserializer)this.dSer).makeValue(stringTokenizer.nextToken()));
        }
        return object;
    }

    public final Object makeListValue(String string) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Collection collection = (Collection)this.javaType.newInstance();
        while (stringTokenizer.hasMoreTokens()) {
            collection.add(((SimpleDeserializer)this.dSer).makeValue(stringTokenizer.nextToken()));
        }
        return collection;
    }

    private void initialize() throws SAXException {
        Class<?> clazz = this.javaCompType = this.javaType.isArray() ? this.javaType.getComponentType() : this.javaType;
        if (this.componentTypeQName != null) {
            this.dSer = this.context.getDeserializer(this.javaCompType, this.componentTypeQName);
        }
        if (this.dSer == null) {
            throw new SAXException(Messages.getMessage((String)"noDeser00", this.componentTypeQName != null ? this.componentTypeQName.toString() : null));
        }
        if (!(this.dSer instanceof SimpleDeserializer)) {
            throw new SAXException(Messages.getMessage((String)"ListCompNotSimpleType00", (String)this.javaCompType.toString()));
        }
    }
}

